/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import pl.pabilo8.immersiveintelligence.common.blocks.multiblocks.metal.tileentities.second.TileEntityAmmunitionWorkshop;

public class AmmunitionWorkshopRecipe
extends MultiblockRecipe {
    public static float energyModifier = 1.0f;
    public static float timeModifier = 1.0f;
    public final BiFunction<ItemStack, ItemStack, ItemStack> process;
    public final IngredientStack coreInput;
    public final IngredientStack casingInput;
    public static LinkedList<AmmunitionWorkshopRecipe> recipeList = new LinkedList();
    int totalProcessTime;
    int totalProcessEnergy;

    public AmmunitionWorkshopRecipe(BiFunction<ItemStack, ItemStack, ItemStack> process, Object coreInput, Object casingInput, int energy, int time) {
        this.process = process;
        this.coreInput = ApiUtils.createIngredientStack((Object)coreInput);
        this.casingInput = ApiUtils.createIngredientStack((Object)casingInput);
        this.totalProcessEnergy = (int)Math.floor((float)energy * energyModifier);
        this.totalProcessTime = (int)Math.floor((float)time * timeModifier);
        this.inputList = Lists.newArrayList((Object[])new IngredientStack[]{this.coreInput, this.casingInput});
        this.outputList = this.getExampleItems();
    }

    private NonNullList<ItemStack> getExampleItems() {
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{this.process.apply(this.coreInput.getExampleStack(), this.casingInput.getExampleStack().func_77946_l())});
    }

    public static AmmunitionWorkshopRecipe addRecipe(BiFunction<ItemStack, ItemStack, ItemStack> process, IngredientStack coreInput, IngredientStack casingInput, int energy, int time) {
        AmmunitionWorkshopRecipe r = new AmmunitionWorkshopRecipe(process, coreInput, casingInput, energy, time);
        recipeList.add(r);
        return r;
    }

    public static List<AmmunitionWorkshopRecipe> removeRecipesForCore(ItemStack stack) {
        ArrayList<AmmunitionWorkshopRecipe> list = new ArrayList<AmmunitionWorkshopRecipe>();
        Iterator it = recipeList.iterator();
        while (it.hasNext()) {
            AmmunitionWorkshopRecipe ir = (AmmunitionWorkshopRecipe)((Object)it.next());
            if (!ir.coreInput.matchesItemStack(stack)) continue;
            list.add(ir);
            it.remove();
        }
        return list;
    }

    public static AmmunitionWorkshopRecipe findRecipe(ItemStack inputCore, ItemStack inputCasing) {
        return recipeList.stream().filter(recipe -> recipe.coreInput.matchesItemStackIgnoringSize(inputCore)).filter(recipe -> recipe.casingInput.matchesItemStackIgnoringSize(inputCasing)).findFirst().orElse(null);
    }

    public NonNullList<ItemStack> getActualItemOutputs(TileEntity te) {
        if (te instanceof TileEntityAmmunitionWorkshop) {
            return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{this.process.apply((ItemStack)((TileEntityAmmunitionWorkshop)te).inventory.get(0), ((ItemStack)((TileEntityAmmunitionWorkshop)te).inventory.get(1)).func_77946_l())});
        }
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[0]);
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("core", (NBTBase)this.coreInput.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("casing", (NBTBase)this.casingInput.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public static AmmunitionWorkshopRecipe loadFromNBT(NBTTagCompound nbt) {
        IngredientStack core = IngredientStack.readFromNBT((NBTTagCompound)nbt.func_74775_l("core"));
        IngredientStack casing = IngredientStack.readFromNBT((NBTTagCompound)nbt.func_74775_l("casing"));
        return AmmunitionWorkshopRecipe.findRecipe(core.stack, casing.stack);
    }

    public int getTotalProcessTime() {
        return this.totalProcessTime;
    }

    public int getTotalProcessEnergy() {
        return this.totalProcessEnergy;
    }
}

