/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.bullets;

import blusunrize.immersiveengineering.common.IEContent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.bullets.BulletHelper;
import pl.pabilo8.immersiveintelligence.api.bullets.BulletRegistry;
import pl.pabilo8.immersiveintelligence.api.bullets.DamageBlockPos;
import pl.pabilo8.immersiveintelligence.api.bullets.penhandlers.PenetrationHandlerClay;
import pl.pabilo8.immersiveintelligence.api.bullets.penhandlers.PenetrationHandlerConcretes;
import pl.pabilo8.immersiveintelligence.api.bullets.penhandlers.PenetrationHandlerDirt;
import pl.pabilo8.immersiveintelligence.api.bullets.penhandlers.PenetrationHandlerGeneral;
import pl.pabilo8.immersiveintelligence.api.bullets.penhandlers.PenetrationHandlerGlass;
import pl.pabilo8.immersiveintelligence.api.bullets.penhandlers.PenetrationHandlerGrass;
import pl.pabilo8.immersiveintelligence.api.bullets.penhandlers.PenetrationHandlerLeaves;
import pl.pabilo8.immersiveintelligence.api.bullets.penhandlers.PenetrationHandlerMetals;
import pl.pabilo8.immersiveintelligence.api.bullets.penhandlers.PenetrationHandlerSand;
import pl.pabilo8.immersiveintelligence.api.bullets.penhandlers.PenetrationHandlerStone;
import pl.pabilo8.immersiveintelligence.api.bullets.penhandlers.PenetrationHandlerWood;
import pl.pabilo8.immersiveintelligence.common.IIContent;

public class PenetrationRegistry {
    public static HashMap<Predicate<Entity>, IPenetrationHandler> registeredEntities = new HashMap();
    public static HashMap<Predicate<IBlockState>, IPenetrationHandler> registeredBlocks = new HashMap();
    public static LinkedHashMap<Predicate<Material>, IPenetrationHandler> registeredMaterials = new LinkedHashMap();
    public static ArrayList<DamageBlockPos> blockDamage = new ArrayList();
    public static ArrayList<DamageBlockPos> blockDamageClient = new ArrayList<DamageBlockPos>(){

        @Override
        public boolean add(DamageBlockPos damageBlockPos) {
            if (this.size() > 16) {
                this.remove(0);
            }
            return super.add(damageBlockPos);
        }
    };
    private static final IPenetrationHandler DEFAULT = new PenetrationHandlerGeneral();

    public static IPenetrationHandler getPenetrationHandler(IBlockState state) {
        for (Map.Entry<Predicate<IBlockState>, IPenetrationHandler> entry : registeredBlocks.entrySet()) {
            if (!entry.getKey().test(state)) continue;
            return entry.getValue();
        }
        for (Map.Entry<Predicate<IBlockState>, IPenetrationHandler> entry : registeredMaterials.entrySet()) {
            if (!entry.getKey().test((IBlockState)state.func_185904_a())) continue;
            return entry.getValue();
        }
        return DEFAULT;
    }

    public static float getBlockHitpoints(IPenetrationHandler pen, BlockPos pos, World world) {
        float hp = pen.getIntegrity() / pen.getDensity();
        DamageBlockPos blockHitPos = new DamageBlockPos(pos, world, pen.getIntegrity());
        for (DamageBlockPos damageBlockPos : blockDamage) {
            if (!damageBlockPos.equals((Object)blockHitPos)) continue;
            return damageBlockPos.damage;
        }
        blockDamage.add(new DamageBlockPos(blockHitPos, hp));
        return hp;
    }

    static {
        BulletHelper.batchRegisterHandler(new PenetrationHandlerMetals.PenetrationHandlerSteel(), new Block[]{IEContent.blockMetalDecoration0, IEContent.blockMetalDevice0, IEContent.blockMetalDevice1, IEContent.blockMetalMultiblock});
        BulletHelper.batchRegisterHandler(new PenetrationHandlerMetals.PenetrationHandlerSteel(), new Block[]{IIContent.blockMetalDecoration, IIContent.blockMetalMultiblock0, IIContent.blockMetalMultiblock1});
        registeredBlocks.put(iBlockState -> Utils.compareBlockstateOredict(iBlockState, "logWood"), new PenetrationHandlerWood.PenetrationHandlerLog());
        BulletHelper.registerMetalMaterial(new PenetrationHandlerMetals.PenetrationHandlerIron(), "iron");
        BulletHelper.registerMetalMaterial(new PenetrationHandlerMetals.PenetrationHandlerCopper(), "copper");
        BulletHelper.registerMetalMaterial(new PenetrationHandlerMetals.PenetrationHandlerSteel(), "steel");
        BulletHelper.registerMetalMaterial(new PenetrationHandlerMetals.PenetrationHandlerGold(), "gold");
        BulletHelper.registerMetalMaterial(new PenetrationHandlerMetals.PenetrationHandlerGold(), "electrum");
        BulletHelper.registerMetalMaterial(new PenetrationHandlerMetals.PenetrationHandlerGold(), "silver");
        BulletHelper.registerMetalMaterial(new PenetrationHandlerMetals.PenetrationHandlerGold(), "platinum");
        BulletHelper.registerMetalMaterial(new PenetrationHandlerMetals.PenetrationHandlerBronze(), "bronze");
        BulletHelper.registerMetalMaterial(new PenetrationHandlerMetals.PenetrationHandlerBronze(), "lead");
        BulletHelper.registerMetalMaterial(new PenetrationHandlerMetals.PenetrationHandlerBronze(), "constantan");
        BulletHelper.registerMetalMaterial(new PenetrationHandlerMetals.PenetrationHandlerTungsten(), "tungsten");
        BulletHelper.registerMetalMaterial(new PenetrationHandlerMetals.PenetrationHandlerAluminium(), "aluminum");
        BulletHelper.registerMetalMaterial(new PenetrationHandlerMetals.PenetrationHandlerAluminium(), "tin");
        BulletHelper.registerMetalMaterial(new PenetrationHandlerMetals.PenetrationHandlerAluminium(), "zinc");
        registeredBlocks.put(iBlockState -> Utils.compareBlockstateOredict(iBlockState, "uberConcrete"), new PenetrationHandlerConcretes.PenetrationHandlerUberConcrete());
        registeredBlocks.put(iBlockState -> Utils.compareBlockstateOredict(iBlockState, "sturdyBricksConcrete"), new PenetrationHandlerConcretes.PenetrationHandlerPanzerConcrete());
        registeredBlocks.put(iBlockState -> Utils.compareBlockstateOredict(iBlockState, "bricksConcrete"), new PenetrationHandlerConcretes.PenetrationHandlerConcreteBricks());
        registeredBlocks.put(iBlockState -> Utils.compareBlockstateOredict(iBlockState, "leadedConcrete"), new PenetrationHandlerConcretes.PenetrationHandlerLeadedConcrete());
        registeredBlocks.put(iBlockState -> Utils.compareBlockstateOredict(iBlockState, "concrete"), new PenetrationHandlerConcretes.PenetrationHandlerConcrete());
        registeredMaterials.put(material -> material == Material.field_151592_s, new PenetrationHandlerGlass());
        registeredMaterials.put(material -> material == Material.field_151574_g, new PenetrationHandlerMetals.PenetrationHandlerIron());
        registeredMaterials.put(material -> material == Material.field_151573_f, new PenetrationHandlerMetals.PenetrationHandlerIron());
        registeredMaterials.put(material -> material == Material.field_151576_e, new PenetrationHandlerStone());
        registeredMaterials.put(material -> material == Material.field_151577_b, new PenetrationHandlerGrass());
        registeredMaterials.put(material -> material == Material.field_151578_c, new PenetrationHandlerDirt());
        registeredMaterials.put(material -> material == Material.field_151572_C, new PenetrationHandlerClay());
        registeredMaterials.put(material -> material == Material.field_151595_p, new PenetrationHandlerSand());
        registeredMaterials.put(material -> material == Material.field_151584_j, new PenetrationHandlerLeaves());
        registeredMaterials.put(material -> material == Material.field_151575_d, new PenetrationHandlerWood.PenetrationHandlerPlanks());
    }

    public static enum HitEffect {
        IMPACT,
        RICOCHET;

    }

    public static interface IPenetrationHandler {
        public float getIntegrity();

        public float getDensity();

        @Nullable
        default public SoundEvent getSpecialSound(HitEffect effect) {
            return null;
        }

        public BulletRegistry.PenMaterialTypes getPenetrationType();
    }
}

