/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.bullets;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import pl.pabilo8.immersiveintelligence.api.Utils;
import pl.pabilo8.immersiveintelligence.api.bullets.DamageBlockPos;
import pl.pabilo8.immersiveintelligence.api.bullets.PenetrationRegistry;
import pl.pabilo8.immersiveintelligence.common.IIPotions;
import pl.pabilo8.immersiveintelligence.common.entity.bullets.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.MessageBlockDamageSync;

public class BulletHelper {
    public static EntityBullet createBullet(World world, ItemStack stack, Vec3d pos, Vec3d dir, float force) {
        return new EntityBullet(world, stack, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, force, dir.field_72450_a, dir.field_72448_b, dir.field_72449_c);
    }

    public static EntityBullet createBullet(World world, ItemStack stack, Vec3d pos, Vec3d dir) {
        return new EntityBullet(world, stack, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 1.0f, dir.field_72450_a, dir.field_72448_b, dir.field_72449_c);
    }

    public static void dealBlockDamage(World world, float bulletDamage, BlockPos pos, PenetrationRegistry.IPenetrationHandler pen) {
        DamageBlockPos dimensionBlockPos = new DamageBlockPos(pos, world, pen.getIntegrity());
        float newHp = PenetrationRegistry.getBlockHitpoints(pen, pos, world) - bulletDamage * pen.getDensity();
        if (newHp > 0.0f) {
            List<DamageBlockPos> list = PenetrationRegistry.blockDamage.stream().filter(damageBlockPos -> damageBlockPos.equals((Object)dimensionBlockPos)).collect(Collectors.toList());
            if (list.size() > 0) {
                list.forEach(damageBlockPos -> {
                    damageBlockPos.damage = newHp;
                });
            } else {
                PenetrationRegistry.blockDamage.add(new DamageBlockPos(dimensionBlockPos, newHp));
            }
            IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageBlockDamageSync(new DamageBlockPos(dimensionBlockPos, newHp / (pen.getIntegrity() / pen.getDensity()))), Utils.targetPointFromPos((BlockPos)dimensionBlockPos, world, 32));
        } else if (newHp <= 0.0f) {
            PenetrationRegistry.blockDamage.removeIf(damageBlockPos -> damageBlockPos.equals((Object)dimensionBlockPos));
            world.func_180495_p(pos).func_177230_c().func_180663_b(world, pos, world.func_180495_p(pos));
            world.func_175655_b((BlockPos)dimensionBlockPos, false);
            IIPacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageBlockDamageSync(new DamageBlockPos(dimensionBlockPos, 0.0f)), Utils.targetPointFromPos((BlockPos)dimensionBlockPos, world, 32));
        }
    }

    public static void registerMetalMaterial(PenetrationRegistry.IPenetrationHandler handler, String name) {
        BulletHelper.registerMetalMaterial(handler, name, true, true, true);
    }

    public static void registerMetalMaterial(PenetrationRegistry.IPenetrationHandler handler, String name, boolean hasSlab, boolean hasSheetMetal, boolean hasSheetmetalSlab) {
        PenetrationRegistry.registeredBlocks.put(iBlockState -> Utils.compareBlockstateOredict(iBlockState, "block" + Utils.toCamelCase(name, false)), handler);
        if (hasSlab) {
            PenetrationRegistry.registeredBlocks.put(iBlockState -> Utils.compareBlockstateOredict(iBlockState, "slab" + Utils.toCamelCase(name, false)), handler);
        }
        if (hasSheetMetal) {
            PenetrationRegistry.registeredBlocks.put(iBlockState -> Utils.compareBlockstateOredict(iBlockState, "blockSheetmetal" + Utils.toCamelCase(name, false)), handler);
        }
        if (hasSheetmetalSlab) {
            PenetrationRegistry.registeredBlocks.put(iBlockState -> Utils.compareBlockstateOredict(iBlockState, "slabSheetmetal" + Utils.toCamelCase(name, false)), handler);
        }
    }

    public static void batchRegisterHandler(PenetrationRegistry.IPenetrationHandler handler, Block ... blocks) {
        for (Block b : blocks) {
            PenetrationRegistry.registeredBlocks.put(iBlockState -> iBlockState.func_177230_c() == b, handler);
        }
    }

    public static void suppress(World world, double posX, double posY, double posZ, float supressionRadius, int suppressionPower) {
        List entities = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(posX, posY, posZ, posX, posY, posZ).func_186662_g((double)supressionRadius));
        for (EntityLivingBase entity : entities) {
            PotionEffect effect = entity.func_70660_b(IIPotions.suppression);
            if (effect == null) {
                effect = new PotionEffect(IIPotions.suppression, 120, suppressionPower, false, false);
            } else {
                effect.field_76460_b = 10;
                effect.func_76452_a(new PotionEffect(IIPotions.suppression, 120, Math.min(255, effect.func_76458_c() + suppressionPower)));
            }
            entity.func_70690_d(effect);
        }
    }

    public static void breakArmour(Entity entity, int damageToArmour) {
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase ent = (EntityLivingBase)entity;
            PotionEffect effect = ent.func_70660_b(IIPotions.broken_armor);
            if (effect == null) {
                effect = new PotionEffect(IIPotions.broken_armor, 60, damageToArmour, false, false);
            } else {
                effect.field_76460_b = 10;
                effect.func_76452_a(new PotionEffect(IIPotions.broken_armor, 60, Math.min(255, effect.func_76458_c() + damageToArmour)));
            }
            for (ItemStack stack : ent.func_184193_aE()) {
                stack.func_77972_a(damageToArmour, ent);
            }
            ent.func_70690_d(effect);
        }
    }
}

