/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.api;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import mctmods.immersivetechnology.api.client.MechanicalEnergyAnimation;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.IFluidTank;

public class ITUtils {
    public static IFluidTank[] emptyIFluidTankList = new IFluidTank[0];
    public static final Set<TileEntity> REMOVE_FROM_TICKING = new HashSet<TileEntity>();
    public static EnumSet<EnumFacing> allSides = EnumSet.allOf(EnumFacing.class);

    public static void RemoveDummyFromTicking(TileEntity te) {
        REMOVE_FROM_TICKING.add(te);
    }

    public static float remapRange(float inMin, float inMax, float outMin, float outMax, float value) {
        return outMin + (value - inMin) / inMax * (outMax - outMin);
    }

    public static boolean AreBlockPosIdentical(BlockPos a, BlockPos b) {
        return a.func_177958_n() == b.func_177958_n() && a.func_177956_o() == b.func_177956_o() && a.func_177952_p() == b.func_177952_p();
    }

    public static BlockPos LocalOffsetToWorldBlockPos(BlockPos origin, int x, int y, int z, EnumFacing facing) {
        return ITUtils.LocalOffsetToWorldBlockPos(origin, x, y, z, facing, EnumFacing.UP);
    }

    public static BlockPos LocalOffsetToWorldBlockPos(BlockPos origin, int x, int y, int z, EnumFacing facing, boolean mirrored) {
        return ITUtils.LocalOffsetToWorldBlockPos(origin, mirrored ? -x : x, y, z, facing, EnumFacing.UP);
    }

    public static BlockPos LocalOffsetToWorldBlockPos(BlockPos origin, int x, int y, int z, EnumFacing facing, EnumFacing up) {
        if (facing.func_176740_k() == up.func_176740_k()) {
            throw new IllegalArgumentException("'facing' and 'up' must be perpendicular to each other!");
        }
        switch (up) {
            case UP: {
                switch (facing) {
                    case SOUTH: {
                        return origin.func_177982_a(-x, y, z);
                    }
                    case NORTH: {
                        return origin.func_177982_a(x, y, -z);
                    }
                    case EAST: {
                        return origin.func_177982_a(z, y, x);
                    }
                    case WEST: {
                        return origin.func_177982_a(-z, y, -x);
                    }
                }
                break;
            }
            case DOWN: {
                switch (facing) {
                    case SOUTH: {
                        return origin.func_177982_a(x, -y, z);
                    }
                    case NORTH: {
                        return origin.func_177982_a(-x, -y, -z);
                    }
                    case EAST: {
                        return origin.func_177982_a(z, -y, -x);
                    }
                    case WEST: {
                        return origin.func_177982_a(-z, -y, x);
                    }
                }
                break;
            }
            case NORTH: {
                switch (facing) {
                    case UP: {
                        return origin.func_177982_a(-x, z, -y);
                    }
                    case DOWN: {
                        return origin.func_177982_a(x, -z, -y);
                    }
                    case EAST: {
                        return origin.func_177982_a(z, x, -y);
                    }
                    case WEST: {
                        return origin.func_177982_a(-z, -x, -y);
                    }
                }
                break;
            }
            case SOUTH: {
                switch (facing) {
                    case UP: {
                        return origin.func_177982_a(x, z, y);
                    }
                    case DOWN: {
                        return origin.func_177982_a(-x, -z, y);
                    }
                    case EAST: {
                        return origin.func_177982_a(z, -x, y);
                    }
                    case WEST: {
                        return origin.func_177982_a(-z, x, y);
                    }
                }
                break;
            }
            case EAST: {
                switch (facing) {
                    case UP: {
                        return origin.func_177982_a(y, z, -x);
                    }
                    case DOWN: {
                        return origin.func_177982_a(y, -z, x);
                    }
                    case SOUTH: {
                        return origin.func_177982_a(y, x, z);
                    }
                    case NORTH: {
                        return origin.func_177982_a(y, -x, -z);
                    }
                }
                break;
            }
            case WEST: {
                switch (facing) {
                    case UP: {
                        return origin.func_177982_a(-y, z, x);
                    }
                    case DOWN: {
                        return origin.func_177982_a(-y, -z, -x);
                    }
                    case SOUTH: {
                        return origin.func_177982_a(-y, -x, z);
                    }
                    case NORTH: {
                        return origin.func_177982_a(-y, x, -z);
                    }
                }
            }
        }
        throw new IllegalArgumentException("This part of the code should never be reached! Has EnumFacing changed ? ");
    }

    public static <T> T First(ArrayList<T> list, Object o) {
        for (T item : list) {
            if (!item.equals(o)) continue;
            return item;
        }
        return null;
    }

    public static double[] smartBoundingBox(double A, double B, double C, double D, double minY, double maxY, EnumFacing fl, EnumFacing fw) {
        double[] boundingArray = new double[6];
        boundingArray[0] = fl == EnumFacing.WEST ? A : (fl == EnumFacing.EAST ? B : (fw == EnumFacing.EAST ? C : D));
        boundingArray[1] = minY;
        double d = fl == EnumFacing.NORTH ? A : (fl == EnumFacing.SOUTH ? B : (boundingArray[2] = fw == EnumFacing.SOUTH ? C : D));
        boundingArray[3] = fl == EnumFacing.EAST ? 1.0 - A : (fl == EnumFacing.WEST ? 1.0 - B : (fw == EnumFacing.EAST ? 1.0 - D : 1.0 - C));
        boundingArray[4] = maxY;
        boundingArray[5] = fl == EnumFacing.SOUTH ? 1.0 - A : (fl == EnumFacing.NORTH ? 1.0 - B : (fw == EnumFacing.SOUTH ? 1.0 - D : 1.0 - C));
        return boundingArray;
    }

    public static double[] alternativeSmartBoundingBox(double A, double B, double C, double D, double minY, double maxY, EnumFacing fl, EnumFacing fw) {
        double[] boundingArray = new double[6];
        boundingArray[0] = fl == EnumFacing.WEST ? 1.0 - A : (fl == EnumFacing.EAST ? A : (fw == EnumFacing.EAST ? 1.0 - C : C));
        boundingArray[1] = minY;
        double d = fl == EnumFacing.NORTH ? 1.0 - A : (fl == EnumFacing.SOUTH ? A : (boundingArray[2] = fw == EnumFacing.SOUTH ? 1.0 - C : C));
        boundingArray[3] = fl == EnumFacing.EAST ? B : (fl == EnumFacing.WEST ? 1.0 - B : (fw == EnumFacing.EAST ? 1.0 - D : D));
        boundingArray[4] = maxY;
        boundingArray[5] = fl == EnumFacing.SOUTH ? B : (fl == EnumFacing.NORTH ? 1.0 - B : (fw == EnumFacing.SOUTH ? 1.0 - D : D));
        return boundingArray;
    }

    public static boolean setRotationAngle(MechanicalEnergyAnimation animation, float rotationSpeed) {
        float oldMomentum = animation.getAnimationMomentum();
        float rotateTo = (animation.getAnimationRotation() + rotationSpeed) % 360.0f;
        animation.setAnimationRotation(rotateTo);
        animation.setAnimationMomentum(rotationSpeed);
        return oldMomentum != rotationSpeed;
    }

    public static void improvedMarkBlockForUpdate(World world, BlockPos pos, @Nullable IBlockState newState) {
        ITUtils.improvedMarkBlockForUpdate(world, pos, newState, allSides);
    }

    public static void improvedMarkBlockForUpdate(World world, BlockPos pos, @Nullable IBlockState newState, EnumSet<EnumFacing> directions) {
        IBlockState state = world.func_180495_p(pos);
        if (newState == null) {
            newState = state;
        }
        world.func_184138_a(pos, state, newState, 3);
        if (!ForgeEventFactory.onNeighborNotify((World)world, (BlockPos)pos, (IBlockState)newState, EnumSet.allOf(EnumFacing.class), (boolean)true).isCanceled()) {
            Block blockType = newState.func_177230_c();
            for (EnumFacing facing : directions) {
                BlockPos toNotify = pos.func_177972_a(facing);
                if (!world.func_175667_e(toNotify)) continue;
                world.func_190524_a(toNotify, blockType, pos);
            }
            world.func_190522_c(pos, blockType);
        }
    }
}

