/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.capabilities.inventory;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.machinemuse.numina.capabilities.inventory.IModularItemCapability;
import net.machinemuse.numina.nbt.MuseNBTUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemStackHandler;

public class ModularItemWrapper
extends ItemStackHandler
implements IModularItemCapability {
    protected ItemStack container;
    int slotCount;

    public ModularItemWrapper(@Nonnull ItemStack container, int slotCount, NBTTagCompound nbt) {
        super(slotCount);
        this.container = container;
        this.slotCount = slotCount;
        if (nbt != null) {
            this.deserializeNBT(nbt);
        }
    }

    @Override
    public boolean isModuleOnline(String unLocalizedName) {
        for (int i = 0; i < this.slotCount; ++i) {
            ItemStack module = this.getStackInSlot(i);
            if (module.func_190926_b() || !module.func_77977_a().equals(unLocalizedName)) continue;
            NBTTagCompound nbt = MuseNBTUtils.getMuseItemTag(module);
            if (nbt.func_74764_b("Active")) {
                return nbt.func_74767_n("Active");
            }
            return false;
        }
        return false;
    }

    @Override
    public void toggleModule(String unLocalizedName, boolean online) {
        for (int i = 0; i < this.slotCount; ++i) {
            ItemStack module = this.getStackInSlot(i);
            if (module.func_190926_b() || !module.func_77977_a().equals(unLocalizedName)) continue;
            NBTTagCompound nbt = MuseNBTUtils.getMuseItemTag(module);
            nbt.func_74757_a("Active", online);
        }
    }

    @Override
    public void setModuleTweakInteger(String unLocalizedName, String tweakName, int teakVal) {
        for (int i = 0; i < this.slotCount; ++i) {
            ItemStack module = this.getStackInSlot(i);
            if (module.func_190926_b() || !module.func_77977_a().equals(unLocalizedName)) continue;
            NBTTagCompound nbt = MuseNBTUtils.getMuseItemTag(module);
            nbt.func_74768_a(tweakName, teakVal);
        }
    }

    @Override
    public void setModuleTweakDouble(String unLocalizedName, String tweakName, double teakVal) {
        for (int i = 0; i < this.slotCount; ++i) {
            ItemStack module = this.getStackInSlot(i);
            if (module.func_190926_b() || !module.func_77977_a().equals(unLocalizedName)) continue;
            NBTTagCompound nbt = MuseNBTUtils.getMuseItemTag(module);
            nbt.func_74780_a(tweakName, teakVal);
        }
    }

    @Override
    public List<String> getInstalledModuleNames() {
        ArrayList<String> moduleNames = new ArrayList<String>();
        for (int i = 0; i < this.slotCount; ++i) {
            ItemStack module = this.getStackInSlot(i);
            if (module.func_190926_b()) continue;
            moduleNames.add(module.func_77977_a());
        }
        return moduleNames;
    }

    @Override
    public NonNullList<ItemStack> getInstallledModules() {
        return this.stacks;
    }

    @Override
    public boolean isModuleInstalled(String unLocalizedName) {
        for (int i = 0; i < this.slotCount; ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (stack.func_190926_b() || !stack.func_77977_a().equals(unLocalizedName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isModuleInstalled(@Nonnull ItemStack module) {
        for (int i = 0; i < this.slotCount; ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (stack.func_190926_b() || !stack.func_77977_a().equals(module.func_77977_a())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public ItemStack installModule(@Nonnull ItemStack module) {
        if (this.isModuleInstalled(module)) {
            return module;
        }
        for (int i = 0; i < this.slotCount; ++i) {
            if (!this.getStackInSlot(i).func_190926_b()) continue;
            return this.insertItem(i, module, false);
        }
        return module;
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> removeModule(String moduleName) {
        NonNullList retList = NonNullList.func_191196_a();
        for (int i = 0; i < this.slotCount; ++i) {
            ItemStack module = this.getStackInSlot(i);
            if (module.func_190926_b() || !moduleName.equals(module.func_77977_a())) continue;
            retList.add((Object)this.extractItem(i, this.getStackInSlot(i).func_190916_E(), false));
        }
        return retList;
    }

    public void updateFromNBT() {
        NBTTagCompound nbt = MuseNBTUtils.getMuseItemTag(this.container);
        if (nbt != null && nbt.func_150297_b("modules", 10)) {
            this.deserializeNBT((NBTTagCompound)nbt.func_74781_a("modules"));
            if (this.stacks.size() != this.slotCount) {
                NonNullList oldStacks = this.stacks;
                this.setSize(this.slotCount);
                int count = Math.min(this.slotCount, oldStacks.size());
                for (int slot = 0; slot < count; ++slot) {
                    this.stacks.set(slot, oldStacks.get(slot));
                }
            }
        }
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        return 1;
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        NBTTagCompound nbt = MuseNBTUtils.getMuseItemTag(this.container);
        nbt.func_74782_a("modules", (NBTBase)this.serializeNBT());
    }
}

