/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.tileentity;

import its_meow.betteranimalsplus.util.HeadTypes;
import java.util.HashMap;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.client.model.ModelBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityHead
extends TileEntity {
    public HeadTypes type = null;
    public HashMap<Integer, ResourceLocation> textures;
    protected int typeNum = 0;
    private Class<? extends ModelBase> modelT = null;
    private float offset;
    private float rotation = 0.0f;
    private boolean shouldDrop = true;
    private Function<Integer, ResourceLocation> textureFunc = null;

    public TileEntityHead() {
    }

    public TileEntityHead(HeadTypes type, float yOffset, ResourceLocation ... textureList) {
        this(type, yOffset, (Function<Integer, ResourceLocation>)null, textureList);
    }

    public TileEntityHead(HeadTypes type, float yOffset, Function<Integer, ResourceLocation> textureFunc, ResourceLocation ... textureList) {
        this.type = type;
        this.modelT = type.getModelSupplier().get().get();
        this.textures = new HashMap();
        int i = 1;
        for (ResourceLocation texture : textureList) {
            this.textures.put(i, texture);
            ++i;
        }
        if (!this.getTileData().func_74764_b("TYPENUM")) {
            this.setType(new Random().nextInt(type.textureCount) + 1);
            this.func_70296_d();
        }
        this.offset = yOffset;
        this.textureFunc = textureFunc;
    }

    public static void disableDrop(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityHead) {
            ((TileEntityHead)te).shouldDrop = false;
        }
    }

    public ModelBase getModel() {
        try {
            return this.modelT.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, -1, -1), this.func_174877_v().func_177982_a(2, 2, 2));
    }

    public ResourceLocation getTexture() {
        if (this.textureFunc == null) {
            return this.textures.get(this.typeNum);
        }
        ResourceLocation rl = this.textureFunc.apply(this.typeNum);
        if (rl == null || rl.toString().equals("")) {
            rl = this.textures.get(this.typeNum);
        }
        return rl;
    }

    public void setType(int i) {
        this.typeNum = i;
        this.func_70296_d();
    }

    public int typeValue() {
        return this.typeNum;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("TYPENUM")) {
            this.typeNum = compound.func_74762_e("TYPENUM");
        } else {
            this.setType(new Random().nextInt(this.textures.size()) + 1);
        }
        if (compound.func_74764_b("rotation")) {
            this.rotation = compound.func_74760_g("rotation");
        }
        if (compound.func_74764_b("GENERIC_TYPE")) {
            this.type = HeadTypes.valueOf(compound.func_74779_i("GENERIC_TYPE"));
            TileEntityHead te2 = this.type.teFactory.apply(this.type);
            this.modelT = te2.modelT;
            this.textures = te2.textures;
            this.offset = te2.offset;
            this.textureFunc = te2.textureFunc;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("TYPENUM", this.typeNum);
        compound.func_74776_a("rotation", this.rotation);
        compound.func_74778_a("GENERIC_TYPE", this.type.name());
        return compound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        this.field_145850_b.func_175684_a(this.field_174879_c, this.field_145854_h, 100);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public float getOffset() {
        return this.offset;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
        this.func_70296_d();
    }

    public float getSkullRotation() {
        return this.rotation;
    }

    public boolean shouldDrop() {
        return this.shouldDrop;
    }
}

