/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.worldgen.structures.dungeons.tlaloc;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import zollerngalaxy.worldgen.structures.dungeons.tlaloc.CorridorTlaloc;
import zollerngalaxy.worldgen.structures.dungeons.tlaloc.DungeonConfigurationTlaloc;
import zollerngalaxy.worldgen.structures.dungeons.tlaloc.DungeonStartTlaloc;
import zollerngalaxy.worldgen.structures.dungeons.tlaloc.RoomBossTlaloc;
import zollerngalaxy.worldgen.structures.dungeons.tlaloc.RoomChestTlaloc;
import zollerngalaxy.worldgen.structures.dungeons.tlaloc.RoomEmptyTlaloc;
import zollerngalaxy.worldgen.structures.dungeons.tlaloc.RoomEntranceTlaloc;
import zollerngalaxy.worldgen.structures.dungeons.tlaloc.RoomSpawnerTlaloc;
import zollerngalaxy.worldgen.structures.dungeons.tlaloc.RoomTreasureTlaloc;

public class MapGenDungeonTlaloc
extends MapGenStructure {
    private static boolean initialized;
    private DungeonConfigurationTlaloc configuration;

    public MapGenDungeonTlaloc(DungeonConfigurationTlaloc configuration) {
        this.configuration = configuration;
    }

    public static void initiateStructures() throws Throwable {
        if (!initialized) {
            MapGenStructureIO.func_143034_b(Start.class, (String)"TlalocDungeon");
            MapGenStructureIO.func_143031_a(DungeonStartTlaloc.class, (String)"TlalocDungeonStart");
            MapGenStructureIO.func_143031_a(CorridorTlaloc.class, (String)"TlalocDungeonCorridor");
            MapGenStructureIO.func_143031_a(RoomEmptyTlaloc.class, (String)"TlalocDungeonEmptyRoom");
            MapGenStructureIO.func_143031_a(RoomBossTlaloc.class, (String)"TlalocDungeonBossRoom");
            MapGenStructureIO.func_143031_a(RoomTreasureTlaloc.class, (String)"TlalocDungeonTreasureRoom");
            MapGenStructureIO.func_143031_a(RoomSpawnerTlaloc.class, (String)"TlalocDungeonSpawnerRoom");
            MapGenStructureIO.func_143031_a(RoomChestTlaloc.class, (String)"TlalocDungeonChestRoom");
            MapGenStructureIO.func_143031_a(RoomEntranceTlaloc.class, (String)"TlalocDungeonEntranceRoom");
        }
        initialized = true;
    }

    public String func_143025_a() {
        return "Tlaloc_Dungeon";
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        long dungeonPos = MapGenDungeonTlaloc.getDungeonPosForCoords(this.field_75039_c, chunkX, chunkZ, ((IGalacticraftWorldProvider)this.field_75039_c.field_73011_w).getDungeonSpacing());
        int i = (int)(dungeonPos >> 32);
        int j = (int)dungeonPos;
        return i == chunkX && j == chunkZ;
    }

    public static long getDungeonPosForCoords(World world, int chunkX, int chunkZ, int spacing) {
        int numChunks = spacing / 16;
        if (chunkX < 0) {
            chunkX -= numChunks - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= numChunks - 1;
        }
        int k = chunkX / numChunks;
        int l = chunkZ / numChunks;
        long seed = (long)k * 341873128712L + (long)l * 132897987541L + world.func_72912_H().func_76063_b() + 10387340L + (long)world.field_73011_w.getDimension();
        Random random = new Random();
        random.setSeed(seed);
        k = k * numChunks + random.nextInt(numChunks);
        l = l * numChunks + random.nextInt(numChunks);
        return ((long)k << 32) + (long)l;
    }

    public static float directionToNearestDungeon(World world, double xpos, double zpos) {
        int spacing = ((IGalacticraftWorldProvider)world.field_73011_w).getDungeonSpacing();
        if (spacing == 0) {
            return 0.0f;
        }
        int x = MathHelper.func_76128_c((double)xpos);
        int z = MathHelper.func_76128_c((double)zpos);
        int quadrantX = x % spacing;
        int quadrantZ = z % spacing;
        int searchOffsetX = quadrantX / (spacing / 2);
        int searchOffsetZ = quadrantZ / (spacing / 2);
        double nearestX = 0.0;
        double nearestZ = 0.0;
        double nearestDistance = Double.MAX_VALUE;
        for (int cx = searchOffsetX - 1; cx < searchOffsetX + 1; ++cx) {
            for (int cz = searchOffsetZ - 1; cz < searchOffsetZ + 1; ++cz) {
                int j;
                double oZ;
                long dungeonPos = MapGenDungeonTlaloc.getDungeonPosForCoords(world, (x + cx * spacing) / 16, (z + cz * spacing) / 16, spacing);
                int i = 2 + ((int)(dungeonPos >> 32) << 4);
                double oX = (double)i - xpos;
                double distanceSq = oX * oX + (oZ = (double)(j = 2 + ((int)dungeonPos << 4)) - zpos) * oZ;
                if (!(distanceSq < nearestDistance)) continue;
                nearestDistance = distanceSq;
                nearestX = oX;
                nearestZ = oZ;
            }
        }
        return GCCoreUtil.getAngleForRelativePosition((double)nearestX, (double)nearestZ);
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ, this.configuration);
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean p_180706_3_) {
        return null;
    }

    public static void main(String[] args) {
        Random rand = new Random();
        Start start = new Start(null, rand, 0, 0, new DungeonConfigurationTlaloc(null, 25, 8, 16, 5, 6, RoomBossTlaloc.class, RoomTreasureTlaloc.class));
        EventQueue.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
                ex.printStackTrace();
            }
            JFrame frame = new JFrame("Dungeon Test");
            frame.setDefaultCloseOperation(3);
            frame.add(new DungeonGenPanel(start.startPiece.componentBounds));
            frame.pack();
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
        });
    }

    static {
        try {
            MapGenDungeonTlaloc.initiateStructures();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static class DungeonGenPanel
    extends JPanel {
        DungeonGenPanel(List<StructureBoundingBox> componentBounds) {
            int absMinX = Integer.MAX_VALUE;
            int absMinZ = Integer.MAX_VALUE;
            int absMaxX = Integer.MIN_VALUE;
            int absMaxZ = Integer.MIN_VALUE;
            for (StructureBoundingBox b : componentBounds) {
                if (b.field_78897_a < absMinX) {
                    absMinX = b.field_78897_a;
                }
                if (b.field_78896_c < absMinZ) {
                    absMinZ = b.field_78896_c;
                }
                if (b.field_78893_d > absMaxX) {
                    absMaxX = b.field_78893_d;
                }
                if (b.field_78892_f <= absMaxZ) continue;
                absMaxZ = b.field_78892_f;
            }
            this.setLayout(new GridLayout(absMaxX - absMinX, absMaxZ - absMinZ, 0, 0));
            Color[] colors = new Color[]{Color.GREEN, Color.BLUE, Color.RED, Color.MAGENTA};
            ArrayList cells = Lists.newArrayList();
            for (int row = 0; row < absMaxX - absMinX; ++row) {
                ArrayList rowCells = Lists.newArrayList();
                for (int col = 0; col < absMaxZ - absMinZ; ++col) {
                    JPanel cell = new JPanel(){

                        @Override
                        public Dimension getPreferredSize() {
                            return new Dimension(8, 8);
                        }
                    };
                    cell.setBackground(Color.GRAY);
                    this.add(cell);
                    rowCells.add(cell);
                }
                cells.add(rowCells);
            }
            int color = 0;
            for (StructureBoundingBox bb : componentBounds) {
                ++color;
                color %= colors.length;
                for (int i = bb.field_78897_a; i < bb.field_78893_d; ++i) {
                    for (int j = bb.field_78896_c; j < bb.field_78892_f; ++j) {
                        ((JPanel)((List)cells.get(i - absMinX)).get(j - absMinZ)).setBackground(colors[color]);
                    }
                }
            }
        }
    }

    public static class Start
    extends StructureStart {
        private DungeonConfigurationTlaloc configuration;
        DungeonStartTlaloc startPiece;

        public Start() {
        }

        public Start(World worldIn, Random rand, int chunkX, int chunkZ, DungeonConfigurationTlaloc configuration) {
            super(chunkX, chunkZ);
            this.configuration = configuration;
            this.startPiece = new DungeonStartTlaloc(worldIn, configuration, rand, (chunkX << 4) + 2, (chunkZ << 4) + 2);
            this.startPiece.func_74861_a(this.startPiece, this.field_75075_a, rand);
            List<StructureComponent> list = this.startPiece.attachedComponents;
            while (!list.isEmpty()) {
                int i = rand.nextInt(list.size());
                StructureComponent structurecomponent = list.remove(i);
                structurecomponent.func_74861_a((StructureComponent)this.startPiece, this.field_75075_a, rand);
            }
            this.func_75072_c();
        }
    }
}

