/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public abstract class ZGWorldGenMaster
extends WorldGenerator {
    protected void setBlock(World world, BlockPos pos, Block block) {
        world.func_180501_a(pos, block.func_176223_P(), 3);
    }

    protected void setBlock(World world, BlockPos pos, IBlockState blockState) {
        world.func_180501_a(pos, blockState, 2);
    }

    protected void setBlock(World world, BlockPos pos, int x, int y, int z, Block block) {
        this.setBlock(world, pos.func_177982_a(x, y, z), block);
    }

    protected Block getBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c();
    }

    public Block getBlock(World world, int x, int y, int z) {
        return this.getBlock(world, new BlockPos(x, y, z));
    }

    protected boolean replaceBlock(World world, BlockPos pos, IBlockState replaceIn, IBlockState replaceWithIn) {
        if (this.getBlock(world, pos).func_176223_P() == replaceIn) {
            this.setBlock(world, pos, replaceWithIn);
            return true;
        }
        return false;
    }

    protected String getSpawnedAtString(BlockPos pos) {
        return "Spawned at: " + pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p();
    }

    protected boolean isValidSpawn(World world, BlockPos pos) {
        if (world == null) {
            return false;
        }
        if (pos == null) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos.func_177977_b());
        if (state == null) {
            return false;
        }
        Block blockBelow = state.func_177230_c();
        if (blockBelow == null) {
            return false;
        }
        return blockBelow != Blocks.field_150350_a && blockBelow != Blocks.field_150355_j;
    }

    public static void generateChest(World world, BlockPos chestPos, Random rand, ResourceLocation LOOT_TABLE, boolean isBigChest) {
        world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176458_f(world, chestPos, Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.NORTH)), 2);
        TileEntity tileentity1 = world.func_175625_s(chestPos);
        if (tileentity1 instanceof TileEntityChest) {
            ((TileEntityChest)tileentity1).func_189404_a(LOOT_TABLE, rand.nextLong());
        }
    }

    public static void generateChest(World world, BlockPos chestPos, Random rand, ResourceLocation LOOT_TABLE) {
        ZGWorldGenMaster.generateChest(world, chestPos, rand, LOOT_TABLE, false);
    }
}

