/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.worldgen.ZGWorldGenMaster;

public class WorldGenTunnel
extends ZGWorldGenMaster {
    private int tunnelDepth = 10;
    private IBlockState airBlock = Blocks.field_150350_a.func_176223_P();

    public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
        if (!this.isValidSpawn(worldIn, pos)) {
            return false;
        }
        this.generateTunnel(worldIn, pos);
        return true;
    }

    private void generateTunnels(World worldIn, BlockPos pos) {
        this.generateTunnel(worldIn, pos);
        if (new Random().nextInt(5) == 0) {
            this.generateTunnel(worldIn, pos.func_177982_a(0, -1, 0));
            this.generateTunnel(worldIn, pos.func_177982_a(0, -2, 1));
            this.generateTunnel(worldIn, pos.func_177982_a(0, -3, 0));
            this.generateTunnel(worldIn, pos.func_177982_a(0, -4, 0));
        }
    }

    private void generateTunnel(World worldIn, BlockPos pos) {
        for (int i = 0; i < this.tunnelDepth; ++i) {
            worldIn.func_175656_a(pos.func_177982_a(i, 0, 0), this.airBlock);
            worldIn.func_175656_a(pos.func_177982_a(i, 1, 0), this.airBlock);
            worldIn.func_175656_a(pos.func_177982_a(i, 2, 0), this.airBlock);
        }
    }

    @Override
    protected void setBlock(World world, BlockPos pos, Block block) {
        IBlockState state = world.func_180495_p(pos);
        if (state != ZGBlocks.tlalocDungeonBricks.func_176223_P() && state != ZGBlocks.edenDungeonBricks.func_176223_P() && state != Blocks.field_150385_bj.func_176223_P()) {
            super.setBlock(world, pos, block);
        }
    }
}

