/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.network.teleporter;

import io.netty.buffer.ByteBuf;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.celestial.ZGPlanetaryBody;
import zollerngalaxy.network.teleporter.CustomTeleporter;

public class MessageTeleportToDimension
implements IMessage {
    int dim;
    int id;

    public MessageTeleportToDimension() {
    }

    public MessageTeleportToDimension(int dim, int id) {
        this.dim = dim;
        this.id = id;
    }

    public void fromBytes(ByteBuf buf) {
        this.dim = buf.readInt();
        this.id = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dim);
        buf.writeInt(this.id);
    }

    public static class TeleportHandler
    implements IMessageHandler<MessageTeleportToDimension, IMessage> {
        public synchronized IMessage onMessage(MessageTeleportToDimension message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> TeleportHandler.teleportPlayer(message, ctx));
            return message;
        }

        public static void teleportPlayer(MessageTeleportToDimension message, MessageContext ctx) {
            Entity ent = ctx.getServerHandler().field_147369_b.func_130014_f_().func_73045_a(message.id);
            if (ent instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)ent;
                int oldDim = player.field_71093_bK;
                int x = (int)player.field_70165_t;
                int y = (int)player.field_70163_u;
                int z = (int)player.field_70161_v;
                int dim = message.dim;
                MinecraftServer server = player.func_130014_f_().func_73046_m();
                WorldServer worldServ = server.func_71218_a(dim);
                MinecraftServer serverWorld = worldServ.func_73046_m();
                PlayerList playerList = serverWorld.func_184103_al();
                CustomTeleporter custTel = new CustomTeleporter(worldServ, x, y, z);
                player.func_70634_a((double)x, (double)y, (double)z);
                playerList.transferPlayerToDimension(player, dim, (Teleporter)custTel);
                worldServ.func_72866_a((Entity)player, false);
                player.func_82242_a(0);
                World worldObj = player.field_70170_p;
                WorldProvider worldProvider = worldObj.field_73011_w;
                Block blockAir = Blocks.field_150350_a;
                Block blockStone = Blocks.field_150348_b;
                if (worldProvider instanceof WorldProviderSpace) {
                    WorldProviderSpace spaceProvider = (WorldProviderSpace)worldProvider;
                    y = spaceProvider.func_76557_i();
                    CelestialBody cb = spaceProvider.getCelestialBody();
                    if (cb instanceof ZGPlanetaryBody) {
                        BiomeSpace spaceBiome;
                        ZGPlanetaryBody planet = (ZGPlanetaryBody)cb;
                        BlockPos blockPos = new BlockPos(player.field_70165_t, player.func_174813_aQ().field_72338_b, player.field_70161_v);
                        Chunk chunk = worldObj.func_175726_f(blockPos);
                        Biome biome = chunk.func_177411_a(blockPos, worldObj.func_72959_q());
                        if (biome != null && biome instanceof BiomeSpace && (spaceBiome = (BiomeSpace)biome).getStoneBlock() != null) {
                            blockStone = spaceBiome.getStoneBlock();
                        }
                    }
                }
                IBlockState airState = blockAir.func_176223_P();
                IBlockState stoneState = blockStone.func_176223_P();
                if (worldObj.func_180495_p(new BlockPos(x, y - 1, z)) == airState) {
                    worldObj.func_175656_a(new BlockPos(x, y - 1, z), stoneState);
                    worldObj.func_175656_a(new BlockPos(x + 1, y - 1, z + 1), stoneState);
                    worldObj.func_175656_a(new BlockPos(x - 1, y - 1, z - 1), stoneState);
                    worldObj.func_175656_a(new BlockPos(x + 1, y - 1, z - 1), stoneState);
                    worldObj.func_175656_a(new BlockPos(x - 1, y - 1, z + 1), stoneState);
                    worldObj.func_175656_a(new BlockPos(x - 1, y - 1, z), stoneState);
                    worldObj.func_175656_a(new BlockPos(x, y - 1, z - 1), stoneState);
                    worldObj.func_175656_a(new BlockPos(x + 1, y - 1, z), stoneState);
                    worldObj.func_175656_a(new BlockPos(x, y - 1, z + 1), stoneState);
                }
                worldObj.func_175656_a(new BlockPos(x, y, z), airState);
                worldObj.func_175656_a(new BlockPos(x, y + 1, z), airState);
                worldObj.func_175656_a(new BlockPos(x + 1, y, z + 1), airState);
                worldObj.func_175656_a(new BlockPos(x + 1, y + 1, z + 1), airState);
                worldObj.func_175656_a(new BlockPos(x - 1, y, z - 1), airState);
                worldObj.func_175656_a(new BlockPos(x - 1, y + 1, z - 1), airState);
                worldObj.func_175656_a(new BlockPos(x + 1, y, z - 1), airState);
                worldObj.func_175656_a(new BlockPos(x + 1, y + 1, z - 1), airState);
                worldObj.func_175656_a(new BlockPos(x - 1, y, z + 1), airState);
                worldObj.func_175656_a(new BlockPos(x - 1, y + 1, z + 1), airState);
                worldObj.func_175656_a(new BlockPos(x - 1, y, z), airState);
                worldObj.func_175656_a(new BlockPos(x - 1, y + 1, z), airState);
                worldObj.func_175656_a(new BlockPos(x, y, z - 1), airState);
                worldObj.func_175656_a(new BlockPos(x, y + 1, z - 1), airState);
                worldObj.func_175656_a(new BlockPos(x + 1, y, z), airState);
                worldObj.func_175656_a(new BlockPos(x + 1, y + 1, z), airState);
                worldObj.func_175656_a(new BlockPos(x, y, z + 1), airState);
                worldObj.func_175656_a(new BlockPos(x, y + 1, z + 1), airState);
                player.field_70143_R = 0.0f;
            }
        }
    }
}

