/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.mobs.entities.zombiemutations;

import java.util.Calendar;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.mobs.entities.base.EntityMutantZombie;

public class EntityOverlord
extends EntityMutantZombie {
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityOverlord.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityOverlord(World world) {
        super(world);
        this.setMutantMultiplyChance(10);
        this.setMutantName("Overlord");
        this.setMutantFireTime(2);
        this.setMutantScale(2.0f);
        this.func_70105_a(this.field_70130_N * 2.0f, this.field_70131_O * 2.0f);
        this.func_175456_n();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(70.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.330000011920929);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(15.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(85.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    protected SoundEvent func_190731_di() {
        return SoundEvents.field_187823_fN;
    }

    public void func_70110_aj() {
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        if (potioneffectIn.func_188419_a() == MobEffects.field_76436_u) {
            PotionEvent.PotionApplicableEvent event = new PotionEvent.PotionApplicableEvent((EntityLivingBase)this, potioneffectIn);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.func_70687_e(potioneffectIn);
    }

    @Override
    public double func_70042_X() {
        return this.field_70131_O * 0.5f;
    }

    @Override
    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public void func_70074_a(EntityLivingBase entityLivingIn) {
        super.func_70074_a(entityLivingIn);
        if ((this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL || this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) && entityLivingIn instanceof EntityVillager) {
            if (this.field_70170_p.func_175659_aa() != EnumDifficulty.HARD && this.field_70146_Z.nextBoolean()) {
                return;
            }
            EntityVillager entityvillager = (EntityVillager)entityLivingIn;
            EntityOverlord entityzombievillager = new EntityOverlord(this.field_70170_p);
            entityzombievillager.func_82149_j((Entity)entityvillager);
            this.field_70170_p.func_72900_e((Entity)entityvillager);
            entityzombievillager.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityzombievillager)), new GroupData(false));
            entityzombievillager.func_82227_f(entityvillager.func_70631_g_());
            entityzombievillager.func_94061_f(entityvillager.func_175446_cd());
            if (entityvillager.func_145818_k_()) {
                entityzombievillager.func_96094_a(entityvillager.func_95999_t());
                entityzombievillager.func_174805_g(ConfigManagerZG.enableMutantNameTags);
            }
            this.field_70170_p.func_72838_d((Entity)entityzombievillager);
            this.field_70170_p.func_180498_a((EntityPlayer)null, 1026, new BlockPos((Entity)this), 0);
        }
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        Potion potion;
        Calendar calendar;
        livingdata = super.func_180482_a(difficulty, livingdata);
        float f = difficulty.func_180170_c();
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * f);
        if (livingdata == null) {
            livingdata = new GroupData(this.field_70170_p.field_73012_v.nextFloat() < ForgeModContainer.zombieBabyChance);
        }
        if (livingdata instanceof GroupData) {
            GroupData entityzombie$groupdata = (GroupData)livingdata;
            if (entityzombie$groupdata.isChild) {
                this.func_82227_f(true);
            }
        }
        this.func_146070_a(this.field_70146_Z.nextFloat() < f * 0.1f);
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        if (this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && (calendar = this.field_70170_p.func_83015_S()).get(2) + 1 == 10 && calendar.get(5) == 31 && this.field_70146_Z.nextFloat() < 0.25f) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_150428_aP : Blocks.field_150423_aK));
            this.field_184655_bs[EntityEquipmentSlot.HEAD.func_188454_b()] = 0.0f;
        }
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextDouble() * (double)0.05f, 0));
        double d0 = this.field_70146_Z.nextDouble() * 1.5 * (double)f;
        if (d0 > 1.0) {
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random zombie-spawn bonus", d0, 2));
        }
        if (this.field_70146_Z.nextFloat() < f * 0.05f) {
            this.func_110148_a(field_110186_bp).func_111121_a(new AttributeModifier("Leader zombie bonus", this.field_70146_Z.nextDouble() * 0.25 + 0.5, 0));
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("Leader zombie bonus", this.field_70146_Z.nextDouble() * 3.0 + 1.0, 2));
            this.func_146070_a(true);
        }
        if (this.field_70170_p.field_73012_v.nextInt(100) == 0) {
            EntitySkeleton entityskeleton = new EntitySkeleton(this.field_70170_p);
            entityskeleton.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            entityskeleton.func_180482_a(difficulty, (IEntityLivingData)null);
            this.field_70170_p.func_72838_d((Entity)entityskeleton);
            entityskeleton.func_184220_m((Entity)this);
        }
        livingdata = new GroupData(this.func_70631_g_());
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && this.field_70170_p.field_73012_v.nextFloat() < 0.1f * difficulty.func_180170_c()) {
            ((GroupData)livingdata).setRandomEffect(this.field_70170_p.field_73012_v);
        }
        if (livingdata instanceof GroupData && (potion = ((GroupData)livingdata).effect) != null) {
            this.func_70690_d(new PotionEffect(potion, Integer.MAX_VALUE));
        }
        return livingdata;
    }

    static class AIOverlordTarget<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        public AIOverlordTarget(EntityOverlord overlord, Class<T> classTarget) {
            super((EntityCreature)overlord, classTarget, true);
        }

        public boolean func_75250_a() {
            float f = this.field_75299_d.func_70013_c();
            return f >= 0.5f ? false : super.func_75250_a();
        }
    }

    static class AIOverlordAttack
    extends EntityAIAttackMelee {
        public AIOverlordAttack(EntityOverlord spider) {
            super((EntityCreature)spider, 1.0, true);
        }

        public boolean func_75253_b() {
            float f = this.field_75441_b.func_70013_c();
            if (f >= 0.5f && this.field_75441_b.func_70681_au().nextInt(100) == 0) {
                this.field_75441_b.func_70624_b((EntityLivingBase)null);
                return false;
            }
            return super.func_75253_b();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 6.0f + attackTarget.field_70130_N;
        }
    }

    class GroupData
    implements IEntityLivingData {
        public boolean isChild;
        public Potion effect;

        private GroupData(boolean p_i47328_2_) {
            this.isChild = p_i47328_2_;
        }

        public void setRandomEffect(Random rand) {
            int i = rand.nextInt(5);
            if (i <= 1) {
                this.effect = MobEffects.field_76424_c;
            } else if (i <= 2) {
                this.effect = MobEffects.field_76420_g;
            } else if (i <= 3) {
                this.effect = MobEffects.field_76428_l;
            } else if (i <= 4) {
                this.effect = MobEffects.field_76441_p;
            }
        }
    }
}

