/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.mobs.entities.boss;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.core.ZGLootTables;
import zollerngalaxy.core.ZollernGalaxyCore;
import zollerngalaxy.events.ZGSoundEvents;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.mobs.entities.EntityScorpion;
import zollerngalaxy.mobs.entities.EntitySpiderling;
import zollerngalaxy.mobs.entities.interfaces.IShadeEntity;
import zollerngalaxy.proxy.IProxy;
import zollerngalaxy.util.ZGUtils;

public class EntityShadowAlien
extends EntityMob
implements IShadeEntity {
    private int maxHealth = 2000;
    private int xp = 2000;
    private double attackDamage = 8.0;
    BlockPos entPos = this.func_180425_c();
    private IProxy proxy;
    private final BossInfoServer bossInfo;

    public EntityShadowAlien(World worldIn) {
        super(worldIn);
        ZollernGalaxyCore.instance();
        this.proxy = ZollernGalaxyCore.proxy;
        this.bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS);
        this.func_70105_a(this.field_70130_N * 1.4f, this.field_70131_O * 1.4f);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityGolem.class, 16.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 2.5, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityGolem.class, true));
        this.field_70728_aV = this.xp;
        this.field_70744_aE = this.xp;
        this.field_70138_W = 2.0f;
        this.attackDamage = 8.0;
        this.entPos = this.func_180425_c();
        this.func_98053_h(true);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
    }

    protected SoundEvent func_184639_G() {
        return ZGSoundEvents.ENTITY_SHADOW_ALIEN_SAY;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ZGSoundEvents.ENTITY_SHADOW_ALIEN_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ZGSoundEvents.ENTITY_SHADOW_ALIEN_DEATH;
    }

    protected float func_70599_aP() {
        return 5.0f;
    }

    public void func_180430_e(float par1, float par2) {
    }

    public void func_70636_d() {
        double maxAtkDmg;
        double atkDmg;
        double health;
        this.entPos = this.func_180425_c();
        Random rand = new Random();
        int randInt = rand.nextInt(900);
        if (randInt <= 10 && (health = (double)this.func_110143_aJ()) < (double)this.maxHealth && health > 0.0 && !this.field_70128_L) {
            this.func_70606_j((float)(health += rand.nextInt(10) >= 5 ? 10.0 : 20.0));
        }
        if (rand.nextInt(4632) <= 16 && this.func_110143_aJ() <= 500.0f && !this.field_70170_p.field_72995_K) {
            EntityCaveSpider entToSpawn = ZGHelper.getRNGChance(5, 10) ? new EntityScorpion(this.field_70170_p) : new EntitySpiderling(this.field_70170_p);
            ZGHelper.spawnEntity((Entity)entToSpawn, this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        if (this.func_110143_aJ() <= 250.0f && rand.nextInt(1000) <= 10 && (atkDmg = this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b()) < (maxAtkDmg = this.attackDamage * 2.0)) {
            this.attackDamage += 0.1;
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.attackDamage);
        }
        this.entPos = this.func_180425_c();
        super.func_70636_d();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 16828890;
    }

    public float func_70013_c() {
        return 5.0f;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(45.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(2000.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.attackDamage);
    }

    public boolean func_70652_k(Entity p_70652_1_) {
        super.func_70652_k(p_70652_1_);
        return true;
    }

    public void func_70110_aj() {
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public void func_70645_a(DamageSource par1) {
        super.func_70645_a(par1);
        if (this.field_70717_bb != null) {
            this.proxy.sendChatMessage(this.field_70717_bb, ZGUtils.translate("tooltips.shadowbossbeaten"));
            this.onDefeat(this.field_70717_bb, this.field_70170_p, this.entPos, this.field_70146_Z);
        }
    }

    public boolean func_70814_o() {
        return true;
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public void func_70074_a(EntityLivingBase par1EntityLivingBase) {
        float health = this.maxHealth;
        if (health <= (float)(this.maxHealth / 2)) {
            int randInt = new Random().nextInt(50);
            this.func_70606_j(this.maxHealth / 2 + randInt);
        }
    }

    public void onDefeat(EntityPlayer player, World world, BlockPos chestPos, Random rand) {
        ZGLootTables.generateChest(world, chestPos, rand, ZGLootTables.CHEST_SHADOW_BOSS);
        String txtFormat = TextFormatting.GOLD + "" + TextFormatting.BOLD;
        String primeMsg = txtFormat + ZGUtils.translate("tooltips.treasurespawned");
        int chestX = chestPos.func_177958_n();
        int chestY = chestPos.func_177956_o();
        int chestZ = chestPos.func_177952_p();
        String chestPosStr = " (" + chestX + " " + chestY + " " + chestZ + ")";
        String fullMsg = primeMsg + chestPosStr;
        this.proxy.sendChatMessage(player, fullMsg);
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }
}

