/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.mobs.entities;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.ZollernGalaxyCore;
import zollerngalaxy.proxy.IProxy;
import zollerngalaxy.worldgen.toci.WorldGenWandererHouse;

public class EntityWanderer
extends EntityAgeable {
    protected int dangerSense = 0;
    protected boolean canInteract = true;
    protected ArrayList<String> sayings = new ArrayList();
    protected int randNameInt = new Random().nextInt(100);
    protected String customName = "Wanderer";
    protected ZollernGalaxyCore core = ZollernGalaxyCore.instance();
    protected IProxy proxy = ZollernGalaxyCore.proxy;

    public EntityWanderer(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 2.0f);
        this.func_96094_a(this.customName);
        this.addSayings();
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.func_98053_h(true);
    }

    public boolean func_98052_bS() {
        return true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityMob.class, 8.0f, 0.6, 0.6));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityLiving.class, 8.0f, 1.0f));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3400000041723251);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (ConfigManagerZG.enableWandererHouses) {
            if (!this.field_70170_p.func_72935_r()) {
                if (!this.dangerSenseReached()) {
                    this.increaseDangerSense();
                } else {
                    this.avoidDanger();
                }
            } else {
                this.clearDangerSense();
            }
        }
    }

    public void increaseDangerSense(int byAmount) {
        this.dangerSense += byAmount;
    }

    public void increaseDangerSense() {
        this.increaseDangerSense(1);
    }

    public void clearDangerSense() {
        this.dangerSense = 0;
    }

    public boolean dangerSenseReached() {
        return this.dangerSense >= 5000;
    }

    public void avoidDanger() {
        if (!this.func_110175_bO() && ConfigManagerZG.enableWandererHouses) {
            this.buildHouse(this.field_70170_p, this.field_70146_Z, this);
        }
    }

    public void buildHouse(World world, Random random, EntityWanderer entity) {
        if (entity.field_70163_u >= 60.0) {
            int entX = (int)entity.field_70165_t + 4;
            int entY = (int)entity.field_70163_u;
            int entZ = (int)entity.field_70161_v + 4;
            BlockPos pos = new BlockPos(entX, entY, entZ);
            WorldGenWandererHouse wandererHouse = new WorldGenWandererHouse();
            wandererHouse.func_180709_b(world, random, pos);
            entity.func_175449_a(pos, 4);
            this.dangerSense = 0;
        }
    }

    public void addSayings() {
        this.addSaying("Hello there.");
        this.addSaying("How are you today?");
        this.addSaying("I sure do love mining.");
        this.addSaying("Dude, Mega Creepers freak me out.");
        this.addSaying("I'm so, like, bummed.");
        this.addSaying("The moon is full tonight.");
        this.addSaying("Fear Toci, lest it consume you.");
        this.addSaying("Legend says that Crystal Towers spawn, and that chests lie within them.");
        this.addSaying("You are of no interest to me.");
        if (this.func_110175_bO()) {
            this.addSaying("I should get home...");
        } else {
            this.addSaying("I need a house...");
        }
        this.addSaying("Sometimes chests can be found underneath the dirt. There are usually crystals nearby.");
        this.addSaying("I need more zinc in my diet.");
        this.addSaying("Ugh, I seriously need water.");
        this.addSaying("I love trees.");
        this.addSaying("I am a busy, busy man.");
        this.addSaying("You're ugly.");
        this.addSaying("Well, look who crawled out from under a rock.");
        this.addSaying("You don't belong here.");
        this.addSaying("Welcome to Toci!");
        this.addSaying("Have you ever thought about exercising?");
        this.addSaying("Wow, you sure look good. *cough*");
    }

    public void addSaying(String par1Saying) {
        this.sayings.add(par1Saying);
    }

    public String pickSaying() {
        return this.sayings.get(new Random().nextInt(this.sayings.size()));
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K) {
            String txtFormatGold = TextFormatting.GOLD + "";
            String txtFormatWhite = TextFormatting.WHITE + "";
            String nameTag = "<" + txtFormatGold + this.func_95999_t() + txtFormatWhite + "> ";
            String txt = nameTag + this.pickSaying();
            this.proxy.sendChatMessage(player, txt);
            return true;
        }
        return false;
    }

    public void func_70645_a(DamageSource ds) {
        super.func_70645_a(ds);
        if (!this.field_70170_p.field_72995_K && !this.field_70170_p.func_72935_r()) {
            EntityZombie zombie = new EntityZombie(this.field_70170_p);
            zombie.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            if (this.func_145818_k_()) {
                zombie.func_96094_a(this.func_95999_t() + " Zombie");
            }
            zombie.func_98053_h(true);
            this.field_70170_p.func_72838_d((Entity)zombie);
        }
        this.func_70106_y();
    }

    public EntityWanderer createChild(EntityAgeable ageable) {
        EntityWanderer entityWanderer = new EntityWanderer(this.field_70170_p);
        entityWanderer.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityWanderer)), null);
        return entityWanderer;
    }
}

