/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.mobs.entities;

import java.util.Random;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.core.entities.EntityAlienVillager;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.blocks.centotl.BlockFacehuggerEgg;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.mobs.entities.EntityKree;
import zollerngalaxy.mobs.entities.EntityXenomorph;
import zollerngalaxy.mobs.entities.base.EntityZGVillagerBase;
import zollerngalaxy.mobs.entities.boss.EntityXenomorphQueen;
import zollerngalaxy.mobs.entities.interfaces.IShadeEntity;

public class EntityFacehugger
extends EntityMob
implements IShadeEntity,
IEntityBreathable {
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityFacehugger.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityFacehugger(World worldIn) {
        super(worldIn);
        this.func_70105_a(this.field_70130_N * 0.6f, this.field_70131_O * 0.6f);
    }

    public void func_180430_e(float par1, float par2) {
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.6f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIFacehuggerAttack(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.8));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 1.4f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new AIFacehuggerTarget<EntityPlayer>(this, EntityPlayer.class));
        this.field_70715_bh.func_75776_a(3, new AIFacehuggerTarget<EntityZGVillagerBase>(this, EntityZGVillagerBase.class));
        this.field_70715_bh.func_75776_a(4, new AIFacehuggerTarget<EntityAlienVillager>(this, EntityAlienVillager.class));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityZGVillagerBase.class, true));
        this.field_70715_bh.func_75776_a(7, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityAlienVillager.class, true));
        this.field_70715_bh.func_75776_a(8, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityZombie.class, true));
        this.field_70715_bh.func_75776_a(9, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySpider.class, true));
        this.field_70715_bh.func_75776_a(10, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCreeper.class, true));
        this.field_70715_bh.func_75776_a(11, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityEnderman.class, true));
        this.field_70715_bh.func_75776_a(12, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityAgeable.class, true));
        this.field_70715_bh.func_75776_a(13, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityKree.class, true));
    }

    public void func_70074_a(EntityLivingBase entityLivingIn) {
        super.func_70074_a(entityLivingIn);
        BlockPos pos = new BlockPos(entityLivingIn.field_70165_t, entityLivingIn.field_70163_u, entityLivingIn.field_70161_v);
        if (this.field_70146_Z.nextInt(100) <= 5) {
            EntityXenomorphQueen xeno = new EntityXenomorphQueen(this.field_70170_p);
            ZGHelper.spawnEntity((Entity)xeno, this.field_70170_p, pos);
        } else {
            EntityXenomorph xeno = new EntityXenomorph(this.field_70170_p);
            ZGHelper.spawnEntity((Entity)xeno, this.field_70170_p, pos);
        }
        this.killFacehugger();
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.3f, 0.5f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.296213411920929);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(55.0);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof EntityLivingBase) {
                int i = 1;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    i = 7;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    i = 15;
                }
                if (i > 0) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76436_u, i * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public void func_70636_d() {
        if (this.field_70146_Z.nextInt(500) <= 25) {
            BlockPos entPos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            BlockPos entPosUp = entPos.func_177984_a();
            BlockPos entPosDown = entPos.func_177977_b();
            World world = this.field_70170_p;
            IBlockState state = world.func_180495_p(entPos);
            IBlockState stateUp = world.func_180495_p(entPosUp);
            IBlockState stateDown = world.func_180495_p(entPosDown);
            boolean hasHatchedEgg = false;
            if (state == ZGBlocks.facehuggerEgg.func_176223_P() && !hasHatchedEgg) {
                ((BlockFacehuggerEgg)state.func_177230_c()).hatchEgg(world, entPos);
            } else if (stateUp == ZGBlocks.facehuggerEgg.func_176223_P() && !hasHatchedEgg) {
                ((BlockFacehuggerEgg)stateUp.func_177230_c()).hatchEgg(world, entPosUp);
            } else if (stateDown == ZGBlocks.facehuggerEgg.func_176223_P() && !hasHatchedEgg) {
                ((BlockFacehuggerEgg)stateDown.func_177230_c()).hatchEgg(world, entPosDown);
            }
            if (hasHatchedEgg) {
                this.killFacehugger();
            }
        }
        super.func_70636_d();
    }

    public void killFacehugger() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            this.field_70173_aa = 0;
        }
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public void func_70110_aj() {
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        if (potioneffectIn.func_188419_a() == MobEffects.field_76436_u) {
            PotionEvent.PotionApplicableEvent event = new PotionEvent.PotionApplicableEvent((EntityLivingBase)this, potioneffectIn);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.func_70687_e(potioneffectIn);
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        Potion potion;
        if ((livingdata = super.func_180482_a(difficulty, livingdata)) == null) {
            livingdata = new GroupData();
            EnumDifficulty difficultyLevel = this.field_70170_p.func_175659_aa();
            if (difficultyLevel == EnumDifficulty.HARD && this.field_70170_p.field_73012_v.nextFloat() < 0.1f * difficulty.func_180170_c()) {
                ((GroupData)livingdata).setRandomEffect(this.field_70170_p.field_73012_v);
            }
        }
        if (livingdata instanceof GroupData && (potion = ((GroupData)livingdata).effect) != null) {
            this.func_70690_d(new PotionEffect(potion, Integer.MAX_VALUE));
        }
        return livingdata;
    }

    public float func_70047_e() {
        return 0.65f;
    }

    public boolean canBreath() {
        return true;
    }

    public static class GroupData
    implements IEntityLivingData {
        public Potion effect;

        public void setRandomEffect(Random rand) {
            int i = rand.nextInt(5);
            if (i <= 1) {
                this.effect = MobEffects.field_76424_c;
            } else if (i <= 2) {
                this.effect = MobEffects.field_76420_g;
            } else if (i <= 3) {
                this.effect = MobEffects.field_76428_l;
            } else if (i <= 4) {
                this.effect = MobEffects.field_76441_p;
            }
        }
    }

    static class AIFacehuggerTarget<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        public AIFacehuggerTarget(EntityFacehugger spider, Class<T> classTarget) {
            super((EntityCreature)spider, classTarget, true);
        }

        public boolean func_75250_a() {
            float f = this.field_75299_d.func_70013_c();
            return f >= 0.5f ? false : super.func_75250_a();
        }
    }

    static class AIFacehuggerAttack
    extends EntityAIAttackMelee {
        public AIFacehuggerAttack(EntityFacehugger spider) {
            super((EntityCreature)spider, 1.6, true);
        }

        public boolean func_75253_b() {
            if (this.field_75441_b.func_70681_au().nextInt(100) == 0) {
                this.field_75441_b.func_70624_b((EntityLivingBase)null);
                return false;
            }
            return super.func_75253_b();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.5f + attackTarget.field_70130_N;
        }
    }
}

