/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.lib.helpers.json;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.ZollernGalaxyCore;

public class JSONRecipeFactory {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static File RECIPE_DIR = null;
    private static File ADVANCE_DIR = null;
    private static final Set<String> USED_OD_NAMES = new TreeSet<String>();
    private static final boolean ENABLE = ZollernGalaxyCore.instance().isInDevMode();
    private static final String MOD_ID = "zollerngalaxy";
    private static final String ASSETS_PATH = "../../../../src/main/resources/assets/";
    private static final String FULL_PATH = "../../../../src/main/resources/assets/zollerngalaxy";

    private static void setupDir() {
        if (RECIPE_DIR == null) {
            RECIPE_DIR = ConfigManagerZG.config.getConfigFile().toPath().resolve("../../../../src/main/resources/assets/zollerngalaxy/recipes/").toFile();
        }
        if (!RECIPE_DIR.exists()) {
            RECIPE_DIR.mkdir();
        }
    }

    private static void setupAdvDir() {
        if (ADVANCE_DIR == null) {
            ADVANCE_DIR = ConfigManagerZG.config.getConfigFile().toPath().resolve("../../../../src/main/resources/assets/zollerngalaxy/advancements/").toFile();
        }
        if (!ADVANCE_DIR.exists()) {
            ADVANCE_DIR.mkdir();
        }
    }

    public static void addShapedRecipe(ItemStack output, Object ... components) {
        int i;
        if (!ENABLE) {
            return;
        }
        JSONRecipeFactory.setupDir();
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        ArrayList<String> pattern = new ArrayList<String>();
        for (i = 0; i < components.length && components[i] instanceof String; ++i) {
            pattern.add(((String)components[i]).toUpperCase());
        }
        boolean isOreDict = false;
        HashMap<String, Map<String, Object>> key = new HashMap<String, Map<String, Object>>();
        Character curKey = null;
        while (i < components.length) {
            Object obj = components[i];
            if (obj instanceof Character) {
                if (curKey != null) {
                    throw new IllegalArgumentException("Provided two char keys in a row");
                }
                curKey = (Character)obj;
            } else {
                if (curKey == null) {
                    throw new IllegalArgumentException("Providing object without a char key");
                }
                if (obj instanceof String) {
                    isOreDict = true;
                }
                key.put(Character.toString(Character.toUpperCase(curKey.charValue())), JSONRecipeFactory.serializeItem(obj));
                curKey = null;
            }
            ++i;
        }
        json.put("type", isOreDict ? "forge:ore_shaped" : "minecraft:crafting_shaped");
        json.put("pattern", pattern);
        json.put("key", key);
        json.put("result", JSONRecipeFactory.serializeItem(output));
        String suffix = output.func_77973_b().func_77614_k() ? "_" + output.func_77952_i() : "";
        File file = new File(RECIPE_DIR, output.func_77973_b().getRegistryName().func_110623_a() + suffix + ".json");
        while (file.exists()) {
            file.delete();
            file = new File(RECIPE_DIR, output.func_77973_b().getRegistryName().func_110623_a() + ".json");
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addShapelessRecipe(ItemStack output, Object ... components) {
        if (!ENABLE) {
            return;
        }
        JSONRecipeFactory.setupDir();
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        boolean isOreDict = false;
        ArrayList<Map<String, Object>> ingredients = new ArrayList<Map<String, Object>>();
        for (Object obj : components) {
            if (obj instanceof String) {
                isOreDict = true;
            }
            ingredients.add(JSONRecipeFactory.serializeItem(obj));
        }
        json.put("type", isOreDict ? "forge:ore_shapeless" : "minecraft:crafting_shapeless");
        json.put("ingredients", ingredients);
        json.put("result", JSONRecipeFactory.serializeItem(output));
        String suffix = output.func_77973_b().func_77614_k() ? "_" + output.func_77952_i() : "";
        File file = new File(RECIPE_DIR, output.func_77973_b().getRegistryName().func_110623_a() + suffix + ".json");
        while (file.exists()) {
            file.delete();
            file = new File(RECIPE_DIR, output.func_77973_b().getRegistryName().func_110623_a() + suffix + ".json");
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Map<String, Object> serializeItem(Object obj) {
        if (obj instanceof Item) {
            return JSONRecipeFactory.serializeItem(new ItemStack((Item)obj));
        }
        if (obj instanceof Block) {
            return JSONRecipeFactory.serializeItem(new ItemStack((Block)obj));
        }
        if (obj instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)obj;
            LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
            if (itemStack.func_77942_o()) {
                ret.put("type", "minecraft:item_nbt");
            }
            ret.put("item", itemStack.func_77973_b().getRegistryName().toString());
            if (itemStack.func_77973_b().func_77614_k() || itemStack.func_77952_i() != 0) {
                ret.put("data", itemStack.func_77952_i());
            }
            if (itemStack.func_77942_o()) {
                ret.put("nbt", itemStack.func_77978_p().toString());
            }
            if (itemStack.func_190916_E() > 1) {
                ret.put("count", itemStack.func_190916_E());
            }
            return ret;
        }
        if (obj instanceof String) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            USED_OD_NAMES.add((String)obj);
            ret.put("item", "#" + ((String)obj).toUpperCase(Locale.ROOT));
            return ret;
        }
        throw new IllegalArgumentException("Not a block, item, stack, or od name");
    }

    public static void writeAdvancements(String result) {
        if (!ENABLE) {
            return;
        }
        JSONRecipeFactory.setupAdvDir();
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        LinkedHashMap rewards = new LinkedHashMap();
        LinkedList<String> recipes = new LinkedList<String>();
        LinkedHashMap criteria = new LinkedHashMap();
        LinkedHashMap<String, Object> has_item = new LinkedHashMap<String, Object>();
        LinkedHashMap conditions = new LinkedHashMap();
        LinkedHashMap<String, String> conditions2 = new LinkedHashMap<String, String>();
        LinkedHashMap<String, Object> has_the_recipe = new LinkedHashMap<String, Object>();
        LinkedList requirements = new LinkedList();
        LinkedList<String> reqs = new LinkedList<String>();
        json.put("parent", "minecraft:recipes/root");
        recipes.add("zollerngalaxy:" + result);
        rewards.put("recipes", recipes);
        has_item.put("trigger", "minecraft:inventory_changed");
        conditions.put("items", new LinkedList());
        conditions2.put("recipe", result);
        has_the_recipe.put("trigger", "minecraft:recipe_unlocked");
        has_the_recipe.put("conditions", conditions2);
        has_item.put("conditions", conditions);
        criteria.put("has_item", has_item);
        criteria.put("has_the_recipe", has_the_recipe);
        reqs.add("has_item");
        reqs.add("has_the_recipe");
        requirements.add(reqs);
        json.put("rewards", rewards);
        json.put("criteria", criteria);
        json.put("requirements", requirements);
        String suffix = "";
        File f = new File(ADVANCE_DIR, result + suffix + ".json");
        while (f.exists()) {
            f.delete();
            f = new File(ADVANCE_DIR, result + suffix + ".json");
        }
        try (FileWriter w = new FileWriter(f);){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void generateConstants() {
        JSONRecipeFactory.setupDir();
        ArrayList json = new ArrayList();
        for (String s : USED_OD_NAMES) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("name", s.toUpperCase(Locale.ROOT));
            entry.put("ingredient", (String)ImmutableMap.of((Object)"type", (Object)"forge:ore_dict", (Object)"ore", (Object)s));
            json.add(entry);
        }
        try (FileWriter w = new FileWriter(new File(RECIPE_DIR, "_constants.json"));){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

