/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.lib.helpers.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import net.minecraftforge.common.config.Configuration;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.ZollernGalaxyCore;

public final class JSONFactory {
    private static final boolean ENABLE = ZollernGalaxyCore.instance().isInDevMode();
    private static final String MOD_ID = "zollerngalaxy";
    private static final Configuration config = ConfigManagerZG.config;
    private static final String ASSETS_PATH = "../../../../src/main/resources/assets/";
    private static final String FULL_PATH = "../../../../src/main/resources/assets/zollerngalaxy";
    private static final String MAIN_PATH = "../../../../";
    private static final String JSON_TEMPLATE_PATH = "C:\\Forge1-12-2-ZollernGalaxy\\JSON_Templates\\";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static File ITEM_DIR = null;
    private static File BLOCK_DIR = null;
    private static File BLOCK_STATES_DIR = null;
    private static File BLOCK_CUSTOM_DIR = null;

    private static void setupItemDir() {
        if (ITEM_DIR == null) {
            ITEM_DIR = JSONFactory.getPath("models/item");
        }
        if (!ITEM_DIR.exists()) {
            ITEM_DIR.mkdir();
        }
    }

    private static void setupBlockDirs() {
        if (BLOCK_DIR == null) {
            BLOCK_DIR = JSONFactory.getPath("models/block");
        }
        if (BLOCK_STATES_DIR == null) {
            BLOCK_STATES_DIR = JSONFactory.getPath("blockstates");
        }
        if (BLOCK_CUSTOM_DIR == null) {
            BLOCK_CUSTOM_DIR = JSONFactory.getPath("models/custom");
        }
        JSONFactory.setupItemDir();
        if (!BLOCK_DIR.exists()) {
            BLOCK_DIR.mkdir();
        }
        if (!BLOCK_STATES_DIR.exists()) {
            BLOCK_STATES_DIR.mkdir();
        }
        if (!BLOCK_CUSTOM_DIR.exists()) {
            BLOCK_CUSTOM_DIR.mkdir();
        }
    }

    private static File getPath(String path) {
        return config.getConfigFile().toPath().resolve("../../../../src/main/resources/assets/zollerngalaxy/" + path + "/").toFile();
    }

    public static void registerItem(String itemName) {
        if (!ENABLE) {
            return;
        }
        JSONFactory.setupItemDir();
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, String> layers = new LinkedHashMap<String, String>();
        layers.put("layer0", "zollerngalaxy:items/" + itemName);
        json.put("parent", "item/generated");
        json.put("textures", layers);
        String jsonFileName = itemName + ".json";
        File file = new File(ITEM_DIR, jsonFileName);
        while (file.exists()) {
            file.delete();
            file = new File(ITEM_DIR, jsonFileName);
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void registerTool(String toolName) {
        if (!ENABLE) {
            return;
        }
        JSONFactory.setupItemDir();
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, String> layers = new LinkedHashMap<String, String>();
        layers.put("layer0", "zollerngalaxy:items/" + toolName);
        json.put("parent", "item/handheld");
        json.put("textures", layers);
        String jsonFileName = toolName + ".json";
        File file = new File(ITEM_DIR, jsonFileName);
        while (file.exists()) {
            file.delete();
            file = new File(ITEM_DIR, jsonFileName);
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void registerBlock(String blockName) {
        if (!ENABLE) {
            return;
        }
        String jsonFileName = blockName + ".json";
        JSONFactory.setupBlockDirs();
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, String> all = new LinkedHashMap<String, String>();
        all.put("all", "zollerngalaxy:blocks/" + blockName);
        json.put("parent", "block/cube_all");
        json.put("textures", all);
        File file = new File(BLOCK_DIR, jsonFileName);
        while (file.exists()) {
            file.delete();
            file = new File(BLOCK_DIR, jsonFileName);
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONFactory.registerBlockState(blockName);
    }

    public static void registerLeaves(String blockName) {
        if (!ENABLE) {
            return;
        }
        String jsonFileName = blockName + ".json";
        JSONFactory.setupBlockDirs();
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, String> all = new LinkedHashMap<String, String>();
        all.put("all", "zollerngalaxy:blocks/" + blockName);
        json.put("parent", "block/leaves");
        json.put("textures", all);
        File file = new File(BLOCK_DIR, jsonFileName);
        while (file.exists()) {
            file.delete();
            file = new File(BLOCK_DIR, jsonFileName);
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONFactory.registerBlockState(blockName);
    }

    private static void registerBlockState(String blockName) {
        String jsonFileName = blockName + ".json";
        LinkedHashMap json = new LinkedHashMap();
        LinkedHashMap normal = new LinkedHashMap();
        LinkedHashMap<String, String> model = new LinkedHashMap<String, String>();
        model.put("model", "zollerngalaxy:" + blockName);
        normal.put("normal", model);
        json.put("variants", normal);
        File file = new File(BLOCK_STATES_DIR, jsonFileName);
        while (file.exists()) {
            file.delete();
            file = new File(BLOCK_STATES_DIR, jsonFileName);
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONFactory.registerBlockItem(blockName);
    }

    private static void registerBlockItem(String blockName) {
        String jsonFileName = blockName + ".json";
        LinkedHashMap<String, String> json = new LinkedHashMap<String, String>();
        json.put("parent", "zollerngalaxy:block/" + blockName);
        File file = new File(ITEM_DIR, jsonFileName);
        while (file.exists()) {
            file.delete();
            file = new File(ITEM_DIR, jsonFileName);
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void registerFlowerBlock(String blockName) {
        if (!ENABLE) {
            return;
        }
        String jsonFileName = blockName + ".json";
        JSONFactory.setupBlockDirs();
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, String> cross = new LinkedHashMap<String, String>();
        cross.put("cross", "zollerngalaxy:blocks/" + blockName);
        json.put("parent", "block/cross");
        json.put("textures", cross);
        File file = new File(BLOCK_DIR, jsonFileName);
        while (file.exists()) {
            file.delete();
            file = new File(BLOCK_DIR, jsonFileName);
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONFactory.registerFlowerBlockState(blockName);
    }

    public static void registerCrop(String blockName) {
        if (!ENABLE) {
            return;
        }
        String jsonFileName = blockName + ".json";
        JSONFactory.setupBlockDirs();
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, String> crop = new LinkedHashMap<String, String>();
        crop.put("crop", "zollerngalaxy:blocks/" + blockName);
        json.put("parent", "block/crop");
        json.put("textures", crop);
        File file = new File(BLOCK_DIR, jsonFileName);
        while (file.exists()) {
            file.delete();
            file = new File(BLOCK_DIR, jsonFileName);
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void registerSapling(String blockName) {
        if (!ENABLE) {
            return;
        }
        String jsonFileName = blockName + ".json";
        JSONFactory.setupBlockDirs();
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, String> cross = new LinkedHashMap<String, String>();
        cross.put("cross", "zollerngalaxy:blocks/" + blockName);
        json.put("parent", "block/cross");
        json.put("textures", cross);
        File file = new File(BLOCK_DIR, jsonFileName);
        while (file.exists()) {
            file.delete();
            file = new File(BLOCK_DIR, jsonFileName);
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONFactory.registerSaplingBlockState(blockName);
    }

    private static void registerSaplingBlockState(String blockName) {
        String jsonFileName = blockName + ".json";
        LinkedHashMap json = new LinkedHashMap();
        LinkedHashMap stages = new LinkedHashMap();
        LinkedHashMap<String, String> model = new LinkedHashMap<String, String>();
        model.put("model", "zollerngalaxy:" + blockName);
        stages.put("stage=0", model);
        stages.put("stage=1", model);
        json.put("variants", stages);
        File file = new File(BLOCK_STATES_DIR, jsonFileName);
        while (file.exists()) {
            file.delete();
            file = new File(BLOCK_STATES_DIR, jsonFileName);
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONFactory.registerBlockAsItem(blockName);
    }

    public static void registerCropBlockState(String blockName) {
        String jsonFileName = blockName + ".json";
        LinkedHashMap json = new LinkedHashMap();
        LinkedHashMap ages = new LinkedHashMap();
        LinkedHashMap<String, String> model0 = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> model1 = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> model2 = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> model3 = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> model4 = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> model5 = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> model6 = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> model7 = new LinkedHashMap<String, String>();
        blockName = blockName.replace("_crop", "");
        model0.put("model", "zollerngalaxy:" + blockName + "_stage_0");
        model1.put("model", "zollerngalaxy:" + blockName + "_stage_0");
        model2.put("model", "zollerngalaxy:" + blockName + "_stage_1");
        model3.put("model", "zollerngalaxy:" + blockName + "_stage_1");
        model4.put("model", "zollerngalaxy:" + blockName + "_stage_2");
        model5.put("model", "zollerngalaxy:" + blockName + "_stage_2");
        model6.put("model", "zollerngalaxy:" + blockName + "_stage_3");
        model7.put("model", "zollerngalaxy:" + blockName + "_stage_3");
        ages.put("age=0", model0);
        ages.put("age=1", model1);
        ages.put("age=2", model2);
        ages.put("age=3", model3);
        ages.put("age=4", model4);
        ages.put("age=5", model5);
        ages.put("age=6", model6);
        ages.put("age=7", model7);
        json.put("variants", ages);
        File file = new File(BLOCK_STATES_DIR, jsonFileName);
        while (file.exists()) {
            file.delete();
            file = new File(BLOCK_STATES_DIR, jsonFileName);
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONFactory.registerBlockAsItem(blockName);
    }

    private static void registerFlowerBlockState(String blockName) {
        String jsonFileName = blockName + ".json";
        LinkedHashMap json = new LinkedHashMap();
        LinkedHashMap normal = new LinkedHashMap();
        LinkedHashMap<String, String> model = new LinkedHashMap<String, String>();
        model.put("model", "zollerngalaxy:" + blockName);
        normal.put("normal", model);
        json.put("variants", normal);
        File file = new File(BLOCK_STATES_DIR, jsonFileName);
        while (file.exists()) {
            file.delete();
            file = new File(BLOCK_STATES_DIR, jsonFileName);
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONFactory.registerBlockAsItem(blockName);
    }

    private static void registerBlockAsItem(String blockName) {
        String jsonFileName = blockName + ".json";
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, String> layers = new LinkedHashMap<String, String>();
        layers.put("layer0", "zollerngalaxy:blocks/" + blockName);
        json.put("parent", "item/generated");
        json.put("textures", layers);
        File file = new File(ITEM_DIR, jsonFileName);
        while (file.exists()) {
            file.delete();
            file = new File(ITEM_DIR, jsonFileName);
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void registerLogBlock(String blockName) {
        if (!ENABLE) {
            return;
        }
        String jsonFileName = blockName + ".json";
        JSONFactory.setupBlockDirs();
        LinkedHashMap<String, Serializable> json = new LinkedHashMap<String, Serializable>();
        LinkedHashMap<String, Object> defaults = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, String> textures = new LinkedHashMap<String, String>();
        LinkedHashMap variants = new LinkedHashMap();
        textures.put("bottom", "zollerngalaxy:blocks/" + blockName + "_top");
        textures.put("top", "zollerngalaxy:blocks/" + blockName + "_top");
        textures.put("side", "zollerngalaxy:blocks/" + blockName);
        defaults.put("textures", textures);
        defaults.put("model", "cube_bottom_top");
        LinkedList<InnerArray> yList = new LinkedList<InnerArray>();
        yList.add(new InnerArray(90));
        yList.add(new InnerArray(180));
        yList.add(new InnerArray(270));
        LinkedList<EmptyArray> eList = new LinkedList<EmptyArray>();
        eList.add(new EmptyArray());
        variants.put("normal", yList);
        variants.put("inventory", eList);
        json.put("forge_marker", Integer.valueOf(1));
        json.put("defaults", defaults);
        json.put("variants", variants);
        File file = new File(BLOCK_STATES_DIR, jsonFileName);
        while (file.exists()) {
            file.delete();
            file = new File(BLOCK_STATES_DIR, jsonFileName);
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONFactory.registerLogBlockState(blockName);
    }

    private static void registerLogBlockState(String blockName) {
        String jsonFileName = blockName + ".json";
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, String> textures = new LinkedHashMap<String, String>();
        textures.put("all", "zollerngalaxy:blocks/" + blockName + "_top");
        textures.put("top", "zollerngalaxy:blocks/" + blockName + "_top");
        textures.put("right", "zollerngalaxy:blocks/" + blockName);
        textures.put("left", "zollerngalaxy:blocks/" + blockName);
        json.put("parent", "block/cube");
        json.put("textures", textures);
        File file = new File(BLOCK_DIR, jsonFileName);
        while (file.exists()) {
            file.delete();
            file = new File(BLOCK_DIR, jsonFileName);
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONFactory.registerBlockItem(blockName);
    }

    public static void registerGrassBlock(String blockName, String blockBottomName) {
        if (!ENABLE) {
            return;
        }
        String jsonFileName = blockName + ".json";
        JSONFactory.setupBlockDirs();
        LinkedHashMap<String, Serializable> json = new LinkedHashMap<String, Serializable>();
        LinkedHashMap<String, Object> defaults = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, String> textures = new LinkedHashMap<String, String>();
        LinkedHashMap variants = new LinkedHashMap();
        textures.put("bottom", "zollerngalaxy:blocks/" + blockBottomName);
        textures.put("top", "zollerngalaxy:blocks/" + blockName);
        textures.put("side", "zollerngalaxy:blocks/" + blockName + "_side");
        defaults.put("textures", textures);
        defaults.put("model", "cube_bottom_top");
        LinkedList<InnerArray> yList = new LinkedList<InnerArray>();
        yList.add(new InnerArray(90));
        yList.add(new InnerArray(180));
        yList.add(new InnerArray(270));
        LinkedList<EmptyArray> eList = new LinkedList<EmptyArray>();
        eList.add(new EmptyArray());
        variants.put("normal", yList);
        variants.put("inventory", eList);
        json.put("forge_marker", Integer.valueOf(1));
        json.put("defaults", defaults);
        json.put("variants", variants);
        File file = new File(BLOCK_STATES_DIR, jsonFileName);
        while (file.exists()) {
            file.delete();
            file = new File(BLOCK_STATES_DIR, jsonFileName);
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONFactory.registerGrassBlockState(blockName, blockBottomName);
    }

    private static void registerGrassBlockState(String blockName, String blockBottomName) {
        String jsonFileName = blockName + ".json";
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, String> textures = new LinkedHashMap<String, String>();
        textures.put("all", "zollerngalaxy:blocks/" + blockBottomName);
        textures.put("top", "zollerngalaxy:blocks/" + blockName);
        textures.put("right", "zollerngalaxy:blocks/" + blockName + "_side");
        textures.put("left", "zollerngalaxy:blocks/" + blockName + "_side");
        json.put("parent", "block/cube");
        json.put("textures", textures);
        File file = new File(BLOCK_DIR, jsonFileName);
        while (file.exists()) {
            file.delete();
            file = new File(BLOCK_DIR, jsonFileName);
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONFactory.registerBlockItem(blockName);
    }

    public static void registerIngotStack(String blockName) {
        if (!ENABLE) {
            return;
        }
    }

    private static void registerIngotStackBlockState(String blockName) {
        JSONFactory.registerIngotStackBlockItem(blockName);
    }

    private static void registerIngotStackBlockItem(String blockName) {
    }

    protected static class EmptyArray {
        protected EmptyArray() {
        }
    }

    protected static class InnerArray {
        int y = 0;

        protected InnerArray(int yIn) {
            this.y = yIn;
        }
    }
}

