/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.lib.helpers;

import java.io.File;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.util.DamageSourceGC;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.creativetabs.CreativeTabsHelper;
import zollerngalaxy.creativetabs.ZGTabs;
import zollerngalaxy.util.ZGDamageSrc;

public final class ZGHelper {
    private static final Logger LOGGER = LogManager.getLogger((String)"Zollern Galaxy");
    private static Random rand = new Random();

    public static Block getBlock(World world, BlockPos pos) {
        return ZGHelper.getBlockState(world, pos).func_177230_c();
    }

    public static IBlockState getBlockState(World world, BlockPos pos) {
        return world.func_180495_p(pos);
    }

    public static void spawnEntity(Entity entityIn, World worldIn, double x, double y, double z) {
        ZGHelper.spawnEntity(entityIn, worldIn, x, y, z, 0.0f, 0.0f);
    }

    public static void spawnEntity(Entity entityIn, World worldIn, double x, double y, double z, float pitch, float yaw) {
        entityIn.func_70012_b(x, y, z, pitch, yaw);
        worldIn.func_72838_d(entityIn);
    }

    public static void spawnEntity(Entity entityIn, World worldIn, BlockPos pos) {
        entityIn.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f, 0.0f);
        worldIn.func_72838_d(entityIn);
    }

    public static void spawnEntity(Entity entityIn, World worldIn, BlockPos pos, float pitch, float yaw) {
        entityIn.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), pitch, yaw);
        worldIn.func_72838_d(entityIn);
    }

    public static void dropItem(Item droppedItem, World worldObj, Entity theEntity) {
        if (!worldObj.field_72995_K) {
            ItemStack itemStack = new ItemStack(droppedItem, ZGHelper.rngInt(1, 2));
            EntityItem itemEntity = new EntityItem(worldObj, theEntity.field_70165_t, theEntity.field_70163_u, theEntity.field_70161_v, itemStack);
            worldObj.func_72838_d((Entity)itemEntity);
        }
    }

    public static void dropItem(Item droppedItem, World worldObj, BlockPos pos) {
        if (!worldObj.field_72995_K) {
            ItemStack itemStack = new ItemStack(droppedItem, ZGHelper.rngInt(1, 2));
            EntityItem itemEntity = new EntityItem(worldObj, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), itemStack);
            worldObj.func_72838_d((Entity)itemEntity);
        }
    }

    public static void dropItem(Block droppedBlock, World worldObj, BlockPos pos) {
        if (!worldObj.field_72995_K) {
            ItemStack itemStack = new ItemStack(droppedBlock, ZGHelper.rngInt(1, 2));
            EntityItem itemEntity = new EntityItem(worldObj, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), itemStack);
            worldObj.func_72838_d((Entity)itemEntity);
        }
    }

    public static void dropItem(ItemStack itemStack, World worldObj, Entity theEntity) {
        if (!worldObj.field_72995_K) {
            EntityItem itemEntity = new EntityItem(worldObj, theEntity.field_70165_t, theEntity.field_70163_u, theEntity.field_70161_v, itemStack);
            worldObj.func_72838_d((Entity)itemEntity);
        }
    }

    public static void dropItem(ItemStack itemStack, World worldObj, BlockPos pos) {
        if (!worldObj.field_72995_K) {
            EntityItem itemEntity = new EntityItem(worldObj, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), itemStack);
            worldObj.func_72838_d((Entity)itemEntity);
        }
    }

    public static Random getRNG() {
        return rand;
    }

    public static boolean getRNGChance(int min, int max) {
        assert (min >= max) : "Min can't be greater than max!";
        int randInt = rand.nextInt(max);
        return randInt == min;
    }

    public static int rngInt(int min, int max) {
        assert (min >= max) : "Min can't be greater than max!";
        int randInt = rand.nextInt(max);
        if (randInt < min) {
            randInt = min;
        }
        return randInt;
    }

    public static double rngDbl(double min, double max) {
        assert (min >= max) : "Min can't be greater than max!";
        double randDbl = rand.nextDouble() * max;
        if (randDbl < min) {
            randDbl = min;
        }
        return randDbl;
    }

    public static float rngFloat(float min, float max) {
        assert (min >= max) : "Min can't be greater than max!";
        float randFlt = rand.nextFloat() * max;
        if (randFlt < min) {
            randFlt = min;
        }
        return randFlt;
    }

    public static String capitalizeFirstLetter(String original) {
        if (original == null || original.length() == 0) {
            return original;
        }
        return original.substring(0, 1).toUpperCase() + original.substring(1);
    }

    public static void setTab(Block block) {
        block.func_149647_a(ZGTabs.zgBlocksTab);
    }

    public static void setTab(Item item) {
        item.func_77637_a(ZGTabs.zgItemsTab);
    }

    public static CreativeTabs createCreativeTabs(String name, ItemStack itemStack) {
        return new CreativeTabsHelper(name, itemStack);
    }

    public static void setName(Block block, String strName) {
        block.func_149663_c(strName);
    }

    public static void setName(Item item, String strName) {
        item.func_77655_b(strName);
    }

    public static void setHardResist(Block block, float hardness, float resistance) {
        block.func_149711_c(hardness);
        block.func_149752_b(resistance);
    }

    public static void setHardResist(Block block, float hardResist) {
        ZGHelper.setHardResist(block, hardResist, hardResist);
    }

    public static File getFilePath(FMLPreInitializationEvent event) {
        return new File(event.getModConfigurationDirectory().getAbsolutePath() + "ZollernGalaxy/");
    }

    public static void addChatMessage(EntityPlayer player, String text) {
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString(text));
        }
    }

    public static void Log(Level level, String strMessage) {
        if (level == Level.INFO) {
            LOGGER.info(strMessage);
        } else if (level == Level.ERROR) {
            LOGGER.error(strMessage);
        } else if (level == Level.WARN) {
            LOGGER.warn(strMessage);
        } else if (level == Level.DEBUG) {
            LOGGER.debug(strMessage);
        }
    }

    public static void Log(String str) {
        ZGHelper.Log(Level.INFO, str);
    }

    public static void LogErr(String strErr) {
        ZGHelper.Log(Level.ERROR, strErr);
    }

    public static void LogWarn(String strErr) {
        ZGHelper.Log(Level.WARN, strErr);
    }

    public static void LogDebug(String strErr) {
        ZGHelper.Log(Level.DEBUG, strErr);
    }

    public static ItemStack getItemStack(Item item, EntityPlayer player) {
        InventoryPlayer matrix = player.field_71071_by;
        for (int i = 0; i < matrix.func_70302_i_(); ++i) {
            ItemStack stackNew;
            if (matrix.func_70301_a(i) == null || (stackNew = matrix.func_70301_a(i)) == null || stackNew.func_77973_b() != item) continue;
            ItemStack k = stackNew.func_77946_l();
            return k;
        }
        return null;
    }

    public static void damageItemStack(Item item, float damageAmount, EntityPlayer player) {
        InventoryPlayer matrix = player.field_71071_by;
        for (int i = 0; i < matrix.func_70302_i_(); ++i) {
            ItemStack stackNew;
            if (matrix.func_70301_a(i) == null || (stackNew = matrix.func_70301_a(i)) == null || stackNew.func_77973_b() != item) continue;
            ItemStack k = new ItemStack(item);
            k.func_77964_b(k.func_77952_i() + (int)damageAmount);
            matrix.func_70299_a(i, k);
        }
    }

    public static boolean checkInventoryForItem(Item itemIn, EntityPlayer playerIn) {
        InventoryPlayer matrix = playerIn.field_71071_by;
        for (int i = 0; i < matrix.func_70302_i_(); ++i) {
            ItemStack matrixStack;
            if (matrix.func_70301_a(i) == null || (matrixStack = matrix.func_70301_a(i)) == null || !matrixStack.func_77973_b().equals(itemIn)) continue;
            return true;
        }
        return false;
    }

    public static void repairItemStack(ItemStack itemStack) {
        itemStack.func_77964_b(0);
    }

    public static void performBlueprintCheck(Random rand, Item blueprintItem, EntityPlayer player, ZGDamageSrc dSrc) {
        if (rand.nextInt(100) <= 5) {
            float dmg = dSrc.getDamageBase();
            if (!ZGHelper.checkInventoryForItem(blueprintItem, player)) {
                player.func_70097_a((DamageSource)dSrc, dmg);
            } else if (rand.nextInt(100) <= 10) {
                int damage = (int)dmg;
                ZGHelper.damageBlueprint(blueprintItem, player, damage);
            }
        }
    }

    public static void performBluePrintCheck(Random rand, Item blueprintItem, EntityPlayer player, DamageSourceGC dSrc, float dmg) {
        if (rand.nextInt(100) <= 5) {
            if (!ZGHelper.checkInventoryForItem(blueprintItem, player)) {
                player.func_70097_a((DamageSource)dSrc, dmg);
            } else if (rand.nextInt(100) <= 10) {
                int damage = (int)dmg;
                ZGHelper.damageBlueprint(blueprintItem, player, damage);
            }
        }
    }

    public static void performBluePrintCheck(Random rand, Item blueprintItem, EntityPlayer player, DamageSource dSrc, float dmg) {
        if (rand.nextInt(100) <= 5) {
            if (!ZGHelper.checkInventoryForItem(blueprintItem, player)) {
                player.func_70097_a(dSrc, dmg);
            } else if (rand.nextInt(100) <= 10) {
                int damage = (int)dmg;
                ZGHelper.damageBlueprint(blueprintItem, player, damage);
            }
        }
    }

    public static void damageBlueprint(Item blueprintItem, EntityPlayer player, int damageAmount) {
        ItemStack stack = ZGHelper.getItemStack(blueprintItem, player);
        stack.func_77972_a(damageAmount, (EntityLivingBase)player);
        ItemStack dmgStack = stack.func_77946_l();
        InventoryPlayer playerInventory = player.field_71071_by;
        int invSlot = playerInventory.func_184429_b(stack);
        playerInventory.func_70299_a(invSlot, dmgStack);
    }

    public static DimensionType registerDimension(String dimName, String dimUnlocalizedName, int dimID, Class<? extends WorldProvider> worldProvider) {
        DimensionType dim = DimensionType.register((String)dimName, (String)dimUnlocalizedName, (int)dimID, worldProvider, (boolean)false);
        DimensionManager.registerDimension((int)dimID, (DimensionType)dim);
        return dim;
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public static void setupMobSpawner(World world, Random rand, BlockPos pos, ResourceLocation mob) {
        world.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 2);
        TileEntityMobSpawner spawner = (TileEntityMobSpawner)world.func_175625_s(pos);
        if (spawner != null) {
            spawner.func_145881_a().func_190894_a(mob);
        }
    }

    public static Block getRandomCrop(Random par1Random) {
        switch (par1Random.nextInt(11)) {
            default: {
                return ZGBlocks.cropBlueberry;
            }
            case 1: {
                return ZGBlocks.cropBlackberry;
            }
            case 2: {
                return ZGBlocks.cropStrawberry;
            }
            case 3: {
                return ZGBlocks.cropGrape;
            }
            case 4: {
                return ZGBlocks.cropTomato;
            }
            case 5: {
                return ZGBlocks.cropCorn;
            }
            case 6: {
                return ZGBlocks.cropCucumber;
            }
            case 7: {
                return ZGBlocks.cropRadish;
            }
            case 8: {
                return ZGBlocks.cropOnion;
            }
            case 9: {
                return ZGBlocks.cropPea;
            }
            case 10: 
        }
        return ZGBlocks.cropGarlic;
    }

    public static ResourceLocation getRandomMob(Random rand) {
        String mobName = "evolved_zombie";
        String modId = "galacticraftcore";
        switch (rand.nextInt(17)) {
            default: {
                mobName = "evolved_zombie";
                modId = "galacticraftcore";
                break;
            }
            case 0: {
                mobName = "evolved_spider";
                modId = "galacticraftcore";
                break;
            }
            case 1: {
                mobName = "evolved_creeper";
                modId = "galacticraftcore";
                break;
            }
            case 2: {
                mobName = "evolved_skeleton";
                modId = "galacticraftcore";
                break;
            }
            case 3: {
                mobName = "evolved_witch";
                modId = "galacticraftcore";
                break;
            }
            case 4: {
                mobName = "evolved_enderman";
                modId = "galacticraftcore";
                break;
            }
            case 5: {
                mobName = "vexbot";
                modId = "zollerngalaxy";
                break;
            }
            case 6: {
                mobName = "mummy";
                modId = "zollerngalaxy";
                break;
            }
            case 7: {
                mobName = "scorpion";
                modId = "zollerngalaxy";
                break;
            }
            case 8: {
                mobName = "shadowskeleton";
                modId = "zollerngalaxy";
                break;
            }
            case 9: {
                mobName = "shade";
                modId = "zollerngalaxy";
                break;
            }
            case 10: {
                mobName = "volatile";
                modId = "zollerngalaxy";
                break;
            }
            case 11: {
                mobName = "overlord";
                modId = "zollerngalaxy";
                break;
            }
            case 12: {
                mobName = "seeker";
                modId = "zollerngalaxy";
                break;
            }
            case 13: {
                mobName = "ghoul";
                modId = "zollerngalaxy";
                break;
            }
            case 14: {
                mobName = "vexbotgold";
                modId = "zollerngalaxy";
                break;
            }
            case 15: {
                mobName = "helleton";
                modId = "zollerngalaxy";
                break;
            }
            case 16: {
                mobName = "bloodworm";
                modId = "zollerngalaxy";
                break;
            }
            case 17: {
                mobName = "kree";
                modId = "zollerngalaxy";
            }
        }
        return new ResourceLocation(modId, mobName);
    }

    public static WorldGenAbstractTree getRandomFruitTree(Random rand) {
        WorldGenAbstractTree CHERRY_TREE = ZGBlocks.cherryWoodGen;
        WorldGenAbstractTree BANANA_TREE = ZGBlocks.bananaGen;
        WorldGenAbstractTree GUAVA_TREE = ZGBlocks.guavaGen;
        WorldGenAbstractTree PEACH_TREE = ZGBlocks.peachGen;
        WorldGenAbstractTree GRAPEFRUIT_TREE = ZGBlocks.grapefruitGen;
        WorldGenAbstractTree ORANGE_TREE = ZGBlocks.orangeGen;
        WorldGenAbstractTree LEMON_TREE = ZGBlocks.lemonGen;
        WorldGenAbstractTree LIME_TREE = ZGBlocks.limeGen;
        WorldGenAbstractTree LIMON_TREE = ZGBlocks.limonGen;
        switch (rand.nextInt(10)) {
            default: {
                return BANANA_TREE;
            }
            case 1: {
                return CHERRY_TREE;
            }
            case 2: {
                return GUAVA_TREE;
            }
            case 3: {
                return PEACH_TREE;
            }
            case 4: {
                return GRAPEFRUIT_TREE;
            }
            case 5: {
                return ORANGE_TREE;
            }
            case 6: {
                return LEMON_TREE;
            }
            case 7: {
                return LIME_TREE;
            }
            case 8: 
        }
        return LIMON_TREE;
    }
}

