/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.lib.helpers;

import com.google.common.base.Function;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.lwjgl.input.Keyboard;
import zollerngalaxy.blocks.ISingleZGBlockRender;
import zollerngalaxy.items.ISingleZGItemRender;

public class CommonZGRegisterHelper {
    public static Map<Block, String> SINGLE_BLOCK_RENDER_LIST = new HashMap<Block, String>();
    public static Map<Item, String> SINGLE_ITEM_RENDER_LIST = new HashMap<Item, String>();

    public static void registerBlock(Block block) {
        CommonZGRegisterHelper.registerBlock(block, (Function<Block, ItemBlock>)((Function)ItemBlock::new));
    }

    public static void registerBlock(Block block, @Nullable Function<Block, ItemBlock> itemBlock) {
        ISingleZGBlockRender blockRender;
        String name = block.func_149739_a().substring(5);
        ForgeRegistries.BLOCKS.register(block.setRegistryName(name));
        if (block instanceof ISingleZGBlockRender && (blockRender = (ISingleZGBlockRender)block).getName() != null) {
            SINGLE_BLOCK_RENDER_LIST.put(block, name);
        }
        if (itemBlock != null) {
            ForgeRegistries.ITEMS.register(((ItemBlock)itemBlock.apply((Object)block)).setRegistryName(block.getRegistryName()));
        }
    }

    public static void registerItem(Item item) {
        ISingleZGItemRender itemRender;
        String name = item.func_77658_a().substring(5);
        item.setRegistryName(name);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        if (item instanceof ISingleZGItemRender && (itemRender = (ISingleZGItemRender)item).getName() != null) {
            SINGLE_ITEM_RENDER_LIST.put(item, name);
        }
    }

    public static void registerBiome(Biome biome) {
        ForgeRegistries.BIOMES.register((IForgeRegistryEntry)biome);
    }

    public static void registerBiomeType(Biome biome, BiomeDictionary.Type ... biomeType) {
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])biomeType);
    }

    public static void registerForgeBucket(Fluid fluid) {
        FluidRegistry.addBucketForFluid((Fluid)fluid);
    }

    public static void setFireBurn(Block block, int encouragement, int flammibility) {
        Blocks.field_150480_ab.func_180686_a(block, encouragement, flammibility);
    }

    public static void registerCarriable(Block block) {
        EntityEnderman.setCarriable((Block)block, (boolean)true);
    }

    public static void registerOreDictionary(String name, Block block) {
        OreDictionary.registerOre((String)name, (Block)block);
    }

    public static void registerOreDictionary(String name, Item item) {
        OreDictionary.registerOre((String)name, (Item)item);
    }

    public static void registerOreDictionary(String name, ItemStack itemStack) {
        OreDictionary.registerOre((String)name, (ItemStack)itemStack);
    }

    public static boolean isClient() {
        return FMLCommonHandler.instance().getSide() == Side.CLIENT;
    }

    public static boolean isEffectiveClient() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
    }

    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static boolean isControlKeyDown() {
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    public static String ticksToElapsedTime(int ticks) {
        int i = ticks / 20;
        int j = i / 60;
        return (i %= 60) < 10 ? j + ":0" + i : j + ":" + i;
    }

    public static ResourceLocation registerEntityLoot(String name) {
        return LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("zollerngalaxy:entities/" + name));
    }

    public static ResourceLocation registerChestLoot(String name) {
        return LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("zollerngalaxy:chests/" + name));
    }

    public static ResourceLocation registerGameplayLoot(String name) {
        return LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("zollerngalaxy:gameplay/" + name));
    }
}

