/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.items;

import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.compat.PlanetProgressionCompat;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.ZollernGalaxyCore;
import zollerngalaxy.core.dimensions.ZGDimensions;
import zollerngalaxy.items.ZGItemBase;
import zollerngalaxy.lib.helpers.CommonZGRegisterHelper;
import zollerngalaxy.lib.helpers.ModHelperBase;
import zollerngalaxy.network.teleporter.MessageTeleportToDimension;
import zollerngalaxy.proxy.IProxy;
import zollerngalaxy.util.ZGUtils;

public class ItemStargate
extends ZGItemBase {
    protected int gateTier = 0;
    protected SimpleNetworkWrapper snw = ZollernGalaxyCore.snw;
    protected IProxy proxy = ZollernGalaxyCore.proxy;

    public ItemStargate(int tier) {
        super("stargate_tier" + tier);
        this.func_77625_d(1);
        this.gateTier = tier;
    }

    private void teleportPlayer(World world, EntityPlayer player) {
        int dim = player.field_71093_bK;
        if (!ConfigManagerZG.disableStarGates) {
            switch (this.gateTier) {
                default: {
                    this.proxy.sendChatMessage(player, ZGUtils.translate("tooltips.protocolnotfunctional"));
                    break;
                }
                case 0: {
                    this.proxy.sendChatMessage(player, ZGUtils.translate("tooltips.unknownprotocol"));
                    break;
                }
                case 1: {
                    this.sendToPlanet(ConfigManagerZG.planetKriffonDimensionId, ConfigManagerZG.planetZollusDimensionId, player);
                    break;
                }
                case 2: {
                    this.sendToPlanet(ConfigManagerZG.planetPurgotDimensionId, ConfigManagerZG.planetKriffonDimensionId, player);
                    break;
                }
                case 3: {
                    if (player.field_71093_bK == ConfigManagerZG.planetExodusDimensionId) {
                        this.sendToPlanet(ConfigManagerZG.planetVortexDimensionId, ConfigManagerZG.planetExodusDimensionId, player);
                        break;
                    }
                    this.sendToPlanet(ConfigManagerZG.planetPurgotDimensionId, ConfigManagerZG.planetEdenDimensionId, player);
                    break;
                }
                case 4: {
                    this.sendToPlanet(ConfigManagerZG.planetXathiusDimensionId, ConfigManagerZG.planetEdenDimensionId, player);
                    break;
                }
                case 5: {
                    this.sendToPlanet(ConfigManagerZG.planetOasisDimensionId, ConfigManagerZG.planetXathiusDimensionId, player);
                    break;
                }
                case 6: {
                    this.sendToPlanet(ConfigManagerZG.planetXantheonDimensionId, ConfigManagerZG.planetOasisDimensionId, player);
                    break;
                }
                case 7: {
                    this.sendToPlanet(ConfigManagerZG.planetAtheonDimensionId, ConfigManagerZG.planetXantheonDimensionId, player);
                    break;
                }
                case 8: {
                    this.sendToPlanet(ConfigManagerZG.planetPerditaDimensionId, ConfigManagerZG.planetAtheonDimensionId, player);
                    break;
                }
                case 9: {
                    this.sendToPlanet(ConfigManagerZG.planetAltumDimensionId, ConfigManagerZG.planetPerditaDimensionId, player);
                    break;
                }
                case 10: {
                    this.sendToPlanet(ConfigManagerZG.planetCaligroDimensionId, ConfigManagerZG.planetAltumDimensionId, player);
                    break;
                }
                case 918: {
                    this.sendToPlanet(ConfigManagerZG.planetCandoraDimensionId, ConfigManagerZG.planetOasisDimensionId, player);
                    break;
                }
            }
        } else {
            this.proxy.sendChatMessage(player, TextFormatting.DARK_RED + "Use of Star Gates has been disabled in the config.");
        }
    }

    private void sendToServer(int dimId, EntityPlayer player) {
        EntityPlayerMP playerMP;
        int playerId = player.func_145782_y();
        CelestialBody destination = ZGDimensions.getCelestialBodyByID(dimId);
        boolean canTP = true;
        String txtFormat = TextFormatting.BOLD + " " + TextFormatting.DARK_RED;
        String bodyName = destination.getLocalizedName();
        String msg = "Unable to teleport; " + bodyName + " not yet discovered.";
        msg = msg + " Could not locate destination on galaxy map.";
        if (ModHelperBase.usePlanetProgression && ConfigManagerZG.enablePlanetProgressionsCompat && player instanceof EntityPlayerMP && !PlanetProgressionCompat.hasResearched(playerMP = (EntityPlayerMP)player, destination)) {
            canTP = false;
            this.proxy.sendChatMessage(player, msg);
        }
        if (canTP) {
            this.snw.sendToServer((IMessage)new MessageTeleportToDimension(dimId, playerId));
        }
    }

    private void sendToPlanet(int toDimensionId, int fromDimensionId, EntityPlayer player) {
        int sendToDim;
        int dim = player.field_71093_bK;
        int n = sendToDim = dim == fromDimensionId ? toDimensionId : fromDimensionId;
        if (toDimensionId == ConfigManagerZG.planetEdenDimensionId && dim == ConfigManagerZG.planetExodusDimensionId) {
            sendToDim = ConfigManagerZG.planetVortexDimensionId;
        }
        this.sendToServer(sendToDim, player);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        this.teleportPlayer(worldIn, playerIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (CommonZGRegisterHelper.isShiftKeyDown()) {
            tooltip.add(TextFormatting.GREEN + ZGUtils.translate("tooltips.stargate"));
            tooltip.add(TextFormatting.GREEN + ZGUtils.translate("tooltips.stargate2"));
            tooltip.add(TextFormatting.GREEN + ZGUtils.translate("tooltips.stargate3"));
        } else {
            tooltip.add(TextFormatting.GOLD + ZGUtils.translate("tooltips.holdshift"));
        }
    }
}

