/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.celestial.IZollernBody;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderMoonZG;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderPlanetZG;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderZG;
import zollerngalaxy.core.enums.EnumBodyClass;
import zollerngalaxy.items.ZGItems;
import zollerngalaxy.lib.helpers.ZGHelper;

@SideOnly(value=Side.CLIENT)
public class GuiHUD
extends Gui {
    private Minecraft mc;
    protected FontRenderer fontRendererObj;
    public EntityPlayer player;
    int k3;

    public GuiHUD(Minecraft mc) {
        this.mc = mc;
        this.fontRendererObj = mc.field_71466_p;
    }

    @SubscribeEvent
    public void onRenderExperienceBar(RenderGameOverlayEvent event) {
        if (event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        int i3 = 0xE0E0E0;
        Entity rvEntity = this.mc.func_175606_aa();
        BlockPos blockPos = new BlockPos(rvEntity.field_70165_t, rvEntity.func_174813_aQ().field_72338_b, rvEntity.field_70161_v);
        ScaledResolution scaledresolution = new ScaledResolution(this.mc);
        int k = scaledresolution.func_78326_a();
        int l = scaledresolution.func_78328_b();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)32826);
        RenderHelper.func_74520_c();
        EntityPlayerSP player = this.mc.field_71439_g;
        Item handItem = player.func_184614_ca().func_77973_b();
        if (handItem == ZGItems.hud && this.mc.field_71441_e != null) {
            Chunk chunk = this.mc.field_71441_e.func_175726_f(blockPos);
            int yPos = 8;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            Biome biome = chunk.func_177411_a(blockPos, this.mc.field_71441_e.func_72959_q());
            WorldProvider worldProvider = this.mc.field_71441_e.field_73011_w;
            boolean isZGWorld = worldProvider instanceof WorldProviderZG;
            if (biome instanceof BiomeSpace && isZGWorld) {
                BiomeSpace biomeSpace = (BiomeSpace)biome;
                WorldProviderZG spaceProvider = (WorldProviderZG)worldProvider;
                boolean isPlanet = worldProvider instanceof WorldProviderPlanetZG;
                boolean isMoon = worldProvider instanceof WorldProviderMoonZG;
                float xTemp1 = 99999.0f;
                float xTemp = isPlanet ? ((WorldProviderPlanetZG)spaceProvider).getBodyTemp() : (isMoon ? ((WorldProviderMoonZG)spaceProvider).getBodyTemp() : xTemp1);
                String biomeName = biome.func_185359_l();
                String s = "Biome: " + biomeName;
                this.fontRendererObj.func_78276_b(s, 2, 26, i3);
                this.fontRendererObj.func_78276_b(s, 26, yPos - 20, i3);
                World world = spaceProvider.getWorldObj();
                boolean useCelsius = ConfigManagerZG.temperatureType;
                String tempType = useCelsius ? "C" : "F";
                float biomeTemp = biomeSpace.getBiomeTemp();
                float celestialTemp = xTemp;
                celestialTemp = spaceProvider.isDaytime() ? celestialTemp + biomeTemp : celestialTemp - biomeTemp;
                String string = tempType = tempType != "F" && tempType != "C" ? "F" : tempType;
                if (tempType == "F") {
                    String strTemp = "" + Math.round(celestialTemp * 1.0f);
                    strTemp = strTemp.length() > 4 ? strTemp.substring(0, 4) : strTemp;
                    String temp = "Temp: " + strTemp + " F";
                    this.fontRendererObj.func_78276_b(temp, 2, 36, i3);
                    this.fontRendererObj.func_78276_b(temp, 26, yPos - 30, i3);
                } else if (tempType == "C") {
                    float celestialTempCelsius = Math.round((celestialTemp - 32.0f) * 5.0f / 9.0f);
                    String strTemp = "" + celestialTempCelsius * 1.0f;
                    String temp = "Temp: " + strTemp + " C";
                    this.fontRendererObj.func_78276_b(temp, 2, 36, i3);
                    this.fontRendererObj.func_78276_b(temp, 26, yPos - 30, i3);
                } else {
                    String s2 = "Error";
                    this.fontRendererObj.func_78276_b(s2, 2, 36, i3);
                    this.fontRendererObj.func_78276_b(s2, 26, yPos - 30, i3);
                }
                String celestialStr = isPlanet ? "Planet" : "Moon";
                IZollernBody celestial = biomeSpace.getBodyForBiome();
                if (celestial != null) {
                    String celestialName = ZGHelper.capitalizeFirstLetter(celestial.getName());
                    String p = celestialStr + ": " + celestialName;
                    this.fontRendererObj.func_78276_b(p, 2, 46, i3);
                    this.fontRendererObj.func_78276_b(p, 26, yPos - 40, i3);
                }
                EnumBodyClass planetClass = celestial.getBodyClass();
                String pClass = planetClass.getPlanetStrClass();
                String pc = "Class " + pClass + " " + celestialStr;
                this.fontRendererObj.func_78276_b(pc, 2, 56, i3);
                this.fontRendererObj.func_78276_b(pc, 26, yPos - 54, i3);
                String strGasses = "Gasses: ";
                String gasses = celestial.getGasses();
                this.fontRendererObj.func_78276_b(strGasses, 2, 66, i3);
                this.fontRendererObj.func_78276_b(strGasses, 26, yPos - 64, i3);
                String actualGasses = gasses.toString();
                this.fontRendererObj.func_78276_b(actualGasses, 2, 76, i3);
                this.fontRendererObj.func_78276_b(actualGasses, 26, yPos - 74, i3);
                float planetRadLevel = celestial.getRadiationLevel();
                String strRad = "Radiation: " + planetRadLevel + "%";
                this.fontRendererObj.func_78276_b(strRad, 2, 86, i3);
                this.fontRendererObj.func_78276_b(strRad, 26, yPos - 84, i3);
                float planetToxLevel = celestial.getToxicLevel();
                String strTox = "Toxicity: " + planetToxLevel + "%";
                this.fontRendererObj.func_78276_b(strTox, 2, 96, i3);
                this.fontRendererObj.func_78276_b(strTox, 26, yPos - 94, i3);
                float planetWindLevel = celestial.getWindLevel();
                String strWind = "Wind Level: " + planetWindLevel + "%";
                this.fontRendererObj.func_78276_b(strWind, 2, 106, i3);
                this.fontRendererObj.func_78276_b(strWind, 26, yPos - 104, i3);
            }
        }
    }
}

