/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.events;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.ZollernGalaxyCore;
import zollerngalaxy.events.ZGSoundEvents;
import zollerngalaxy.items.ZGItems;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.potions.ZGPotions;
import zollerngalaxy.proxy.IProxy;
import zollerngalaxy.util.ZGUtils;

public final class WindBlowingEvent
extends Event {
    private ZollernGalaxyCore core = ZollernGalaxyCore.instance();
    private IProxy proxy = ZollernGalaxyCore.proxy;
    private WindDirection currentDirection = WindDirection.NORTH;
    private int directionalChance = ZGHelper.rngInt(1, 100);
    private int windStrength = ZGHelper.rngInt(1, 35);
    private World world;
    private BlockPos playerPos;

    public WindBlowingEvent(World worldIn, EntityPlayer player) {
        if (ConfigManagerZG.enableWindBlowEvent) {
            this.world = worldIn;
            this.playerPos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            if (this.directionalChance <= 10) {
                this.updateDirectionBasedOnChance();
            }
            int windBlowChance = ConfigManagerZG.windBlowChance;
            if (ZGHelper.rngInt(1, 150) <= windBlowChance && this.world.func_175710_j(this.playerPos)) {
                this.pushEntities();
            }
        }
    }

    private void checkBlockAt(double posX, double posY, double posZ, World world, EntityPlayer player) {
        BlockPos pos = new BlockPos(posX, posY, posZ);
        if (world.func_180495_p(pos) == Blocks.field_150350_a.func_176223_P() && world.func_175710_j(pos)) {
            this.playWindSound(world, player, posX, posY, posZ);
            player.func_70634_a(posX, posY, posZ);
            this.playWindSound(world, player, posX, posY, posZ);
        } else {
            this.checkBlockAt(posX, posY + 2.0, posZ, world, player);
        }
    }

    private void playWindSound(World worldIn, EntityPlayer player, double posX, double posY, double posZ) {
        BlockPos soundPos = new BlockPos(posX, posY, posZ);
        SoundEvent windSoundEvent = ZGSoundEvents.WEATHER_WIND;
        SoundCategory soundCtg = SoundCategory.WEATHER;
        float volume = 1000.0f;
        float pitch = 2.0f + player.func_70681_au().nextFloat() * 0.4f;
        worldIn.func_184133_a(player, soundPos, windSoundEvent, soundCtg, volume, pitch);
    }

    public void pushEntities() {
        if (!this.world.field_72995_K) {
            Object[] playerArray;
            double expandBy = 15.0;
            AxisAlignedBB boundingBox = new AxisAlignedBB(this.playerPos);
            AxisAlignedBB expandedBox = boundingBox.func_72321_a(expandBy, expandBy, expandBy);
            Class<EntityPlayer> playerClass = EntityPlayer.class;
            List playerList = this.world.func_72872_a(playerClass, expandedBox);
            for (Object o : playerArray = playerList.toArray()) {
                if (!(o instanceof EntityPlayer)) continue;
                EntityPlayer currentPlayer = (EntityPlayer)o;
                if (this.checkForAmulet(currentPlayer)) {
                    return;
                }
                BlockPos newPos = this.playerPos;
                switch (this.getDirection()) {
                    case NORTH: {
                        newPos = this.playerPos.func_177964_d(this.windStrength);
                        break;
                    }
                    case SOUTH: {
                        newPos = this.playerPos.func_177970_e(this.windStrength);
                        break;
                    }
                    case EAST: {
                        newPos = this.playerPos.func_177965_g(this.windStrength);
                        break;
                    }
                    case WEST: {
                        newPos = this.playerPos.func_177985_f(this.windStrength);
                        break;
                    }
                    default: {
                        newPos = this.playerPos.func_177981_b(this.windStrength);
                    }
                }
                this.playWindSound(this.world, currentPlayer, newPos.func_177958_n(), newPos.func_177956_o(), newPos.func_177952_p());
                this.checkBlockAt(newPos.func_177958_n(), newPos.func_177956_o(), newPos.func_177952_p(), this.world, currentPlayer);
                this.playWindSound(this.world, currentPlayer, newPos.func_177958_n(), newPos.func_177956_o(), newPos.func_177952_p());
            }
        }
    }

    private boolean checkForAmulet(EntityPlayer player) {
        InventoryPlayer playerInventory = player.field_71071_by;
        Item item = ZGItems.amuletStorm;
        ItemStack stack = new ItemStack(item, 1);
        boolean hasStack = playerInventory.func_70431_c(stack);
        boolean protectionActive = player.func_70644_a(ZGPotions.stormProtection);
        boolean isCreativeMode = player.field_71075_bZ.field_75098_d;
        if (hasStack && !protectionActive) {
            PotionEffect stormProtectionEffect = new PotionEffect(ZGPotions.stormProtection, 24000, 1);
            player.func_70690_d(stormProtectionEffect);
            if (playerInventory.func_70431_c(stack) && !isCreativeMode) {
                int invSlot = playerInventory.func_184429_b(stack);
                playerInventory.func_70298_a(invSlot, 1);
            }
            this.proxy.sendChatMessage(player, TextFormatting.GOLD + ZGUtils.translate("tooltips.amulet_storm"));
        }
        return player.func_70644_a(ZGPotions.stormProtection);
    }

    public void setDirection(WindDirection dir) {
        this.currentDirection = dir;
    }

    public void setStrength(int strength) {
        this.windStrength = strength;
    }

    public void setPlayerPos(BlockPos pos) {
        this.playerPos = pos;
    }

    public void updateDirectionBasedOnChance() {
        int dirChance = ZGHelper.rngInt(1, 4);
        WindDirection dir = this.currentDirection;
        switch (dirChance) {
            case 1: {
                dir = WindDirection.NORTH;
                break;
            }
            case 2: {
                dir = WindDirection.SOUTH;
                break;
            }
            case 3: {
                dir = WindDirection.EAST;
                break;
            }
            case 4: {
                dir = WindDirection.WEST;
            }
        }
        this.setDirection(dir);
    }

    public void updateChance() {
        this.directionalChance = ZGHelper.rngInt(1, 100);
    }

    public WindDirection getDirection() {
        return this.currentDirection;
    }

    public int getStrength() {
        return this.windStrength;
    }

    public BlockPos getPlayerPos() {
        return this.playerPos;
    }

    public World getWorld() {
        return this.world;
    }

    public static enum WindDirection {
        NORTH,
        EAST,
        WEST,
        SOUTH;

    }
}

