/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.core.dimensions.worldproviders.orbit;

import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderOverworldOrbit;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.celestial.ZGPlanets;
import zollerngalaxy.celestial.spacestations.ZGSpaceStations;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.dimensions.ZGDimensions;
import zollerngalaxy.core.dimensions.chunkproviders.ChunkProviderOrbitZG;

public class WorldProviderOrbitZollus
extends WorldProviderOverworldOrbit {
    public CelestialBody getCelestialBody() {
        return ZGSpaceStations.ZOLLUS_SPACE_STATION;
    }

    public float getSolarSize() {
        return 0.01f;
    }

    public Vector3 getFogColor() {
        float f = 1.0f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.078431375f * f), (double)(0.105882354f * f), (double)(0.1764706f * f));
    }

    public Vector3 getSkyColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public boolean canRainOrSnow() {
        return false;
    }

    public boolean hasSunset() {
        return false;
    }

    public long getDayLength() {
        return 68010L;
    }

    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return ChunkProviderOrbitZG.class;
    }

    public boolean isDaytime() {
        float a = this.field_76579_a.func_72826_c(0.0f);
        return a < 0.42f || a > 0.58f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float var2 = this.field_76579_a.func_72826_c(par1);
        float var3 = 1.0f - (MathHelper.func_76134_b((float)(var2 * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        return var3 * var3 * 0.5f + 0.3f;
    }

    public boolean func_76561_g() {
        return false;
    }

    public double getHorizon() {
        return 44.0;
    }

    public int func_76557_i() {
        return 44;
    }

    public boolean func_76569_d() {
        return true;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    public float getGravity() {
        return 0.073f;
    }

    public boolean hasBreathableAtmosphere() {
        return false;
    }

    public double getMeteorFrequency() {
        return 0.0;
    }

    public double getFuelUsageMultiplier() {
        return 1.0;
    }

    public String getPlanetToOrbit() {
        return "planet.zollus";
    }

    public String getSaveFolder() {
        return "space_stations/zollus";
    }

    public double getSolarEnergyMultiplier() {
        return ConfigManagerCore.spaceStationEnergyScalar;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier > ZGPlanets.planetZollus.getTierRequirement();
    }

    public float getFallDamageModifier() {
        return 0.4f;
    }

    public float getSoundVolReductionAmount() {
        return 50.0f;
    }

    public float getThermalLevelModifier() {
        return 0.0f;
    }

    public float getWindLevel() {
        return 0.1f;
    }

    public DimensionType func_186058_p() {
        return ZGDimensions.ZOLLUS_ORBIT;
    }

    public int getPlanetIdToOrbit() {
        return ConfigManagerZG.planetZollusDimensionId;
    }
}

