/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.core.dimensions.worldproviders;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.VillageCollection;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.biomes.providers.BiomeProviderVortex;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.celestial.ZGPlanets;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.dimensions.ZGDimensions;
import zollerngalaxy.core.dimensions.chunkproviders.ChunkProviderVortex;
import zollerngalaxy.core.dimensions.skyproviders.SkyProviderVortex;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderPlanetZG;

public class WorldProviderVortex
extends WorldProviderPlanetZG {
    private long timeCurrentOffset = 0L;
    public long preTickTime = Long.MIN_VALUE;
    private long saveTCO = 0L;
    static Field tickCounter;

    public float getGravity() {
        return 0.024f;
    }

    @Override
    public float getSolarSize() {
        return 1.8f;
    }

    @Override
    public double getMeteorFrequency() {
        return ConfigManagerZG.meteorGenVortex;
    }

    @Override
    public double getFuelUsageMultiplier() {
        return 6.2;
    }

    @Override
    public boolean hasBreathableAtmosphere() {
        return false;
    }

    public float getFallDamageModifier() {
        return 0.24f;
    }

    public float getSoundVolReductionAmount() {
        return 0.5f;
    }

    public float getThermalLevelModifier() {
        return 0.0f;
    }

    @Override
    public float getWindLevel() {
        return 4.5f;
    }

    public double getSolarEnergyMultiplier() {
        return 6.55;
    }

    public double getYCoordinateToTeleport() {
        return 150.0;
    }

    public float func_76571_f() {
        return 128.0f;
    }

    @Override
    public Vector3 getFogColor() {
        float f = 1.1f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.78431374f * f), (double)(0.023529412f * f), (double)(0.972549f * f));
    }

    @Override
    public Vector3 getSkyColor() {
        float f = 1.15f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.039215688f * f), (double)(0.003921569f * f), (double)(0.9843137f * f));
    }

    public boolean canRainOrSnow() {
        return true;
    }

    public boolean hasSunset() {
        return true;
    }

    public long getDayLength() {
        return 20000L;
    }

    public boolean shouldDisablePrecipitation() {
        return false;
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return this.canRainOrSnow();
    }

    @Override
    public boolean func_76567_e() {
        return this.shouldForceRespawn();
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float f1 = this.field_76579_a.func_72826_c(par1);
        float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.3f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return f2 * f2 * 1.4f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float par1) {
        float f1 = this.field_76579_a.func_72826_c(1.0f);
        float f2 = 0.9f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 = 1.0f - f2;
        return f2 * 0.8f;
    }

    public CelestialBody getCelestialBody() {
        return ZGPlanets.planetVortex;
    }

    public double getHorizon() {
        return 82.0;
    }

    public int func_76557_i() {
        return 82;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    public ResourceLocation getDungeonChestType() {
        return null;
    }

    public List<Block> getSurfaceBlocks() {
        ArrayList<Block> blockList = new ArrayList<Block>();
        blockList.add(ZGBlocks.vortexSurfaceRock);
        return blockList;
    }

    @Override
    public void updateWeather() {
        if (!this.field_76579_a.field_72995_K) {
            long newTime = this.field_76579_a.func_72912_H().func_76073_f();
            if (this.preTickTime == Long.MIN_VALUE) {
                int savedTick = 0;
                try {
                    tickCounter.setAccessible(true);
                    savedTick = tickCounter.getInt(this.field_76579_a.field_72982_D);
                    if (savedTick < 0) {
                        savedTick = 0;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.timeCurrentOffset = (long)savedTick - newTime;
            } else {
                long diff = newTime - this.preTickTime;
                if (diff > 1L) {
                    this.timeCurrentOffset -= diff - 1L;
                    this.saveTime();
                }
            }
            this.preTickTime = newTime;
            this.saveTCO = 0L;
        }
        this.updateWeatherOverride();
        this.field_76579_a.func_72912_H().func_76080_g(10);
        this.field_76579_a.func_72912_H().func_76084_b(true);
        this.field_76579_a.func_72912_H().func_76090_f(10);
        this.field_76579_a.func_72912_H().func_76069_a(true);
        this.field_76579_a.field_73004_o = 0.5f;
        this.field_76579_a.field_73017_q = 0.5f;
    }

    private void saveTime() {
        try {
            VillageCollection vc = this.field_76579_a.field_72982_D;
            tickCounter.setAccessible(true);
            tickCounter.setInt(vc, (int)this.getWorldTime());
            vc.func_76185_a();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void updateWeatherOverride() {
        super.updateWeatherOverride();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void renderSky() {
        this.setSkyRenderer(new SkyProviderVortex((IGalacticraftWorldProvider)this));
    }

    @Override
    protected void renderCloud() {
        this.setCloudRenderer((IRenderHandler)new CloudRenderer());
    }

    @Override
    protected void renderWeather() {
    }

    public DimensionType func_186058_p() {
        return ZGDimensions.VORTEX;
    }

    public boolean func_76561_g() {
        return true;
    }

    public Class<? extends BiomeProvider> getBiomeProviderClass() {
        BiomeAdaptive.setBodyMultiBiome((CelestialBody)ZGPlanets.planetVortex);
        return BiomeProviderVortex.class;
    }

    @Override
    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return ChunkProviderVortex.class;
    }

    static {
        try {
            tickCounter = VillageCollection.class.getDeclaredField(GCCoreUtil.isDeobfuscated() ? "tickCounter" : "field_75553_e");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

