/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.core.dimensions.worldproviders;

import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.event.EventHandlerGC;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.celestial.ZGMoon;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderZG;

public abstract class WorldProviderMoonZG
extends WorldProviderZG {
    private static WorldProviderMoonZG instance;

    public WorldProviderMoonZG() {
        instance = this;
    }

    public static WorldProviderMoonZG instance() {
        return instance;
    }

    public String getSaveFolder() {
        return "moons/" + this.getMoon().getName();
    }

    @Override
    public World getWorldObj() {
        return this.field_76579_a;
    }

    @Override
    public boolean shouldForceRespawn() {
        return !ConfigManagerCore.forceOverworldRespawn;
    }

    public ZGMoon getMoon() {
        CelestialBody moon = this.getCelestialBody();
        ZGMoon moonNova = (ZGMoon)moon;
        return moonNova;
    }

    @Override
    public float getSolarSize() {
        return 1.0f;
    }

    @Override
    public Vector3 getFogColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public boolean canBlockFreeze(BlockPos pos, boolean byWater) {
        return this.getMoon().getIsColdBody();
    }

    @Override
    public void updateWeather() {
        World worldObj = this.getWorldObj();
        WorldInfo worldInfo = worldObj.func_72912_H();
        if (!this.shouldDisablePrecipitation()) {
            super.updateWeather();
        } else {
            worldInfo.func_76080_g(0);
            worldInfo.func_76084_b(false);
            worldInfo.func_76090_f(0);
            worldInfo.func_76069_a(false);
            worldObj.field_73004_o = 0.0f;
            worldObj.field_73017_q = 0.0f;
        }
    }

    public float getWindLevel() {
        return this.getMoon().getWindLevel();
    }

    @Override
    public Vector3 getSkyColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    @Override
    public boolean func_76567_e() {
        if (EventHandlerGC.bedActivated) {
            EventHandlerGC.bedActivated = false;
            return true;
        }
        return false;
    }

    @Override
    public double getFuelUsageMultiplier() {
        return 0.5;
    }

    @Override
    public double getMeteorFrequency() {
        return this.getMoon().getAtmosphericDensity();
    }

    @Override
    public float getArrowGravity() {
        return 0.003f;
    }

    @Override
    public int getDungeonSpacing() {
        return 704;
    }

    @Override
    public boolean hasBreathableAtmosphere() {
        return this.getMoon().getIsBreathable();
    }

    @Override
    public boolean canSpaceshipTierPass(int tier) {
        return tier >= this.getMoon().getTierRequirement();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        if (super.getSkyRenderer() == null) {
            this.renderSky();
        }
        return super.getSkyRenderer();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getCloudRenderer() {
        if (super.getCloudRenderer() == null) {
            this.renderCloud();
        }
        return super.getCloudRenderer();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getWeatherRenderer() {
        if (super.getWeatherRenderer() == null) {
            this.renderWeather();
        }
        return super.getWeatherRenderer();
    }

    @Override
    public boolean func_191066_m() {
        return true;
    }

    @Override
    protected abstract void renderSky();

    @Override
    protected abstract void renderCloud();

    @Override
    protected abstract void renderWeather();

    public float getBodyTemp() {
        ZGMoon moon = this.getMoon();
        float planetTemp = moon.getBodyTemperature();
        planetTemp = this.isDaytime() ? (planetTemp /= 2.2f) : moon.getBodyTemperature();
        return planetTemp;
    }

    @Override
    public abstract Class<? extends IChunkGenerator> getChunkProviderClass();
}

