/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.core.dimensions.worldproviders;

import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.biomes.providers.BiomeProviderKronos;
import zollerngalaxy.celestial.ZGPlanet;
import zollerngalaxy.celestial.ZGPlanets;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.dimensions.ZGDimensions;
import zollerngalaxy.core.dimensions.chunkproviders.ChunkProviderKronos;
import zollerngalaxy.core.dimensions.skyproviders.SkyProviderKronos;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderPlanetZG;

public class WorldProviderKronos
extends WorldProviderPlanetZG {
    public boolean func_177500_n() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76568_b(int x, int z) {
        return true;
    }

    public float getGravity() {
        return 0.055f;
    }

    @Override
    public float getSolarSize() {
        return 0.12f;
    }

    @Override
    public double getMeteorFrequency() {
        return ConfigManagerZG.meteorGenKronos;
    }

    @Override
    public double getFuelUsageMultiplier() {
        return 8.2;
    }

    @Override
    public boolean hasBreathableAtmosphere() {
        return this.getPlanet().getIsBreathable();
    }

    public float getFallDamageModifier() {
        return 0.34f;
    }

    public float getSoundVolReductionAmount() {
        return 4.0f;
    }

    public float getThermalLevelModifier() {
        return 3.2f;
    }

    @Override
    public float getBodyTemp() {
        ZGPlanet planet = this.getPlanet();
        float planetTemp = planet.getBodyTemperature();
        planetTemp = this.isDaytime() ? (planetTemp += 10.13f) : (planetTemp -= 3.2f);
        return planetTemp;
    }

    @Override
    public float getWindLevel() {
        return this.getPlanet().getWindLevel();
    }

    public double getSolarEnergyMultiplier() {
        return 0.5;
    }

    public double getYCoordinateToTeleport() {
        return 74.0;
    }

    public float func_76571_f() {
        return 128.0f;
    }

    @Override
    public Vector3 getSkyColor() {
        float f = 0.8f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.3137255f * f), (double)(0.0f * f), (double)(0.0f * f));
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float p_76562_1_, float p_76562_2_) {
        return new Vec3d(1.2300000029802323, (double)0.03f, (double)0.03f);
    }

    public boolean canRainOrSnow() {
        return this.getPlanet().getHasRain();
    }

    public boolean hasSunset() {
        return false;
    }

    public long getDayLength() {
        return 68010L;
    }

    public boolean shouldDisablePrecipitation() {
        return !this.canRainOrSnow();
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return this.canRainOrSnow();
    }

    @Override
    public boolean func_76567_e() {
        return this.shouldForceRespawn();
    }

    public CelestialBody getCelestialBody() {
        return ZGPlanets.planetKronos;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float f1 = this.field_76579_a.func_72826_c(par1);
        float f2 = 0.5f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.3f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return f2 * f2 * 0.05f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float par1) {
        float f1 = this.field_76579_a.func_72826_c(1.0f);
        float f2 = 0.7f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 = 1.0f - f2;
        return f2 * 0.2f;
    }

    public double getMovementFactor() {
        return 16.0;
    }

    public float func_76563_a(long par1, float par3) {
        return 0.6f;
    }

    public WorldBorder func_177501_r() {
        return new WorldBorder(){

            public double func_177731_f() {
                return super.func_177731_f() / 16.0;
            }

            public double func_177721_g() {
                return super.func_177721_g() / 16.0;
            }
        };
    }

    protected void func_76556_a() {
        float f = 0.2f;
        for (int i = 0; i <= 15; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            this.field_76573_f[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * 0.9f + 0.1f;
        }
    }

    public double getHorizon() {
        return 75.0;
    }

    public int func_76557_i() {
        return 58;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    public ResourceLocation getDungeonChestType() {
        return null;
    }

    public List<Block> getSurfaceBlocks() {
        ArrayList<Block> blockList = new ArrayList<Block>();
        blockList.add(Blocks.field_150424_aL);
        return blockList;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void renderSky() {
        this.setSkyRenderer(new SkyProviderKronos((IGalacticraftWorldProvider)this));
    }

    @Override
    protected void renderCloud() {
        this.setCloudRenderer((IRenderHandler)new CloudRenderer());
    }

    @Override
    protected void renderWeather() {
    }

    public DimensionType func_186058_p() {
        return ZGDimensions.KRONOS;
    }

    public boolean func_76561_g() {
        return true;
    }

    public Class<? extends BiomeProvider> getBiomeProviderClass() {
        BiomeAdaptive.setBodyMultiBiome((CelestialBody)ZGPlanets.planetKronos);
        return BiomeProviderKronos.class;
    }

    @Override
    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return ChunkProviderKronos.class;
    }
}

