/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.core.dimensions.worldproviders;

import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.biomes.providers.BiomeProviderAtheon;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.celestial.ZGPlanet;
import zollerngalaxy.celestial.ZGPlanets;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.dimensions.ZGDimensions;
import zollerngalaxy.core.dimensions.chunkproviders.ChunkProviderAtheon;
import zollerngalaxy.core.dimensions.skyproviders.SkyProviderAtheon;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderPlanetZG;

public class WorldProviderAtheon
extends WorldProviderPlanetZG {
    public float getGravity() {
        return 0.014f;
    }

    @Override
    public float getSolarSize() {
        return 2.0f;
    }

    @Override
    public double getMeteorFrequency() {
        return ConfigManagerZG.meteorGenAtheon;
    }

    @Override
    public double getFuelUsageMultiplier() {
        return 3.8;
    }

    @Override
    public boolean hasBreathableAtmosphere() {
        return this.getPlanet().getIsBreathable();
    }

    public float getFallDamageModifier() {
        return 0.56f;
    }

    public float getSoundVolReductionAmount() {
        return 0.0f;
    }

    public float getThermalLevelModifier() {
        return 2.5f;
    }

    @Override
    public float getBodyTemp() {
        ZGPlanet planet = this.getPlanet();
        float planetTemp = planet.getBodyTemperature();
        planetTemp = this.isDaytime() ? (planetTemp *= 4.5f) : planet.getBodyTemperature();
        return planetTemp;
    }

    @Override
    public float getWindLevel() {
        return this.getPlanet().getWindLevel();
    }

    public double getSolarEnergyMultiplier() {
        return 8.65;
    }

    public double getYCoordinateToTeleport() {
        return 150.0;
    }

    public float func_76571_f() {
        return 128.0f;
    }

    @Override
    public Vector3 getFogColor() {
        float f = 1.1f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.9098039f * f), (double)(0.7058824f * f), (double)(0.21960784f * f));
    }

    @Override
    public Vector3 getSkyColor() {
        float f = 1.15f - this.getStarBrightness(1.0f);
        return new Vector3((double)(1.0f * f), (double)(0.94509804f * f), (double)(0.35686275f * f));
    }

    public boolean canRainOrSnow() {
        return this.getPlanet().getHasRain();
    }

    public boolean hasSunset() {
        return true;
    }

    public long getDayLength() {
        return 10000L;
    }

    public boolean shouldDisablePrecipitation() {
        return !this.canRainOrSnow();
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return this.canRainOrSnow();
    }

    @Override
    public boolean func_76567_e() {
        return this.shouldForceRespawn();
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float f1 = this.field_76579_a.func_72826_c(par1);
        float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.3f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return f2 * f2 * 1.8f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float par1) {
        float f1 = this.field_76579_a.func_72826_c(1.0f);
        float f2 = 0.9f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 = 1.0f - f2;
        return f2 * 1.5f;
    }

    public CelestialBody getCelestialBody() {
        return ZGPlanets.planetAtheon;
    }

    public double getHorizon() {
        return 74.0;
    }

    public int func_76557_i() {
        return 62;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    public ResourceLocation getDungeonChestType() {
        return null;
    }

    public List<Block> getSurfaceBlocks() {
        ArrayList<Block> blockList = new ArrayList<Block>();
        blockList.add(ZGBlocks.atheonRock);
        return blockList;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void renderSky() {
        this.setSkyRenderer(new SkyProviderAtheon((IGalacticraftWorldProvider)this));
    }

    @Override
    protected void renderCloud() {
        this.setCloudRenderer((IRenderHandler)new CloudRenderer());
    }

    @Override
    protected void renderWeather() {
    }

    public DimensionType func_186058_p() {
        return ZGDimensions.ATHEON;
    }

    public boolean func_76561_g() {
        return true;
    }

    public Class<? extends BiomeProvider> getBiomeProviderClass() {
        BiomeAdaptive.setBodyMultiBiome((CelestialBody)ZGPlanets.planetAtheon);
        return BiomeProviderAtheon.class;
    }

    @Override
    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return ChunkProviderAtheon.class;
    }
}

