/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.core.dimensions.worldproviders;

import java.util.LinkedList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.biomes.providers.BiomeProviderAstros;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.celestial.ZGMoon;
import zollerngalaxy.celestial.ZGPlanets;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.dimensions.ZGDimensions;
import zollerngalaxy.core.dimensions.chunkproviders.ChunkProviderAstros;
import zollerngalaxy.core.dimensions.skyproviders.SkyProviderAstros;
import zollerngalaxy.core.dimensions.worldproviders.WorldProviderMoonZG;

public class WorldProviderAstros
extends WorldProviderMoonZG {
    public float getGravity() {
        return 0.065f;
    }

    public float getFallDamageModifier() {
        return 0.36f;
    }

    @Override
    public double getMeteorFrequency() {
        return ConfigManagerZG.meteorGenEden;
    }

    @Override
    public float getSolarSize() {
        return 1.21f;
    }

    @Override
    public double getFuelUsageMultiplier() {
        return 1.4;
    }

    public float getSoundVolReductionAmount() {
        return 2.0f;
    }

    public float getThermalLevelModifier() {
        return -0.2f;
    }

    @Override
    public float getBodyTemp() {
        ZGMoon moon = this.getMoon();
        float moonTemp = moon.getBodyTemperature();
        if (!this.isDaytime()) {
            moonTemp /= 1.5f;
        }
        return moonTemp;
    }

    public CelestialBody getCelestialBody() {
        return ZGPlanets.moonAstros;
    }

    public double getSolarEnergyMultiplier() {
        return 1.0045;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float f1 = this.field_76579_a.func_72826_c(par1);
        float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.3f);
        if (f2 < 0.0f) {
            f2 = 0.5f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return f2 * f2 * 0.8f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float par1) {
        float f1 = this.field_76579_a.func_72826_c(1.0f);
        float f2 = 0.9f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        if (f2 < 0.0f) {
            f2 = 0.3f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 = 1.0f - f2;
        return f2 * 1.0f;
    }

    public double getHorizon() {
        return 54.0;
    }

    public int func_76557_i() {
        return 62;
    }

    @Override
    public Vector3 getFogColor() {
        float f = 1.1f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.007843138f * f), (double)(0.5019608f * f), (double)(0.972549f * f));
    }

    @Override
    public Vector3 getSkyColor() {
        float f = 1.15f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.47058824f * f), (double)(0.08235294f * f), (double)(0.6313726f * f));
    }

    public boolean canRainOrSnow() {
        return false;
    }

    public boolean hasSunset() {
        return true;
    }

    public long getDayLength() {
        return 12000L;
    }

    public ResourceLocation getDungeonChestType() {
        return null;
    }

    public List<Block> getSurfaceBlocks() {
        LinkedList<Block> list = new LinkedList<Block>();
        list.add(ZGBlocks.astrosRock);
        list.add(ZGBlocks.astrosDirt);
        return list;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void renderSky() {
        this.setSkyRenderer(new SkyProviderAstros((IGalacticraftWorldProvider)this));
    }

    @Override
    protected void renderCloud() {
        this.setCloudRenderer((IRenderHandler)new CloudRenderer());
    }

    @Override
    protected void renderWeather() {
    }

    public Class<? extends BiomeProvider> getBiomeProviderClass() {
        BiomeAdaptive.setBodyMultiBiome((CelestialBody)ZGPlanets.moonAstros);
        return BiomeProviderAstros.class;
    }

    public DimensionType func_186058_p() {
        return ZGDimensions.ASTROS;
    }

    public double getYCoordinateToTeleport() {
        return 90.0;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    public boolean func_76561_g() {
        return true;
    }

    @Override
    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return ChunkProviderAstros.class;
    }
}

