/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.core;

import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.world.BiomeGenBaseGC;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;
import zollerngalaxy.api.ZollernGalaxyAPI;
import zollerngalaxy.biomes.ZGBiomes;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.blocks.fluids.ZGFluids;
import zollerngalaxy.celestial.ZGPlanets;
import zollerngalaxy.celestial.spacestations.ZGSpaceStations;
import zollerngalaxy.compat.ZGCompats;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.dimensions.ZGDimensions;
import zollerngalaxy.creativetabs.ZGTabs;
import zollerngalaxy.enchantments.EnchantmentListZG;
import zollerngalaxy.events.ZGSoundEvents;
import zollerngalaxy.items.ZGItems;
import zollerngalaxy.lib.ZGInfo;
import zollerngalaxy.lib.ZGStructures;
import zollerngalaxy.lib.helpers.ModHelperBase;
import zollerngalaxy.lib.helpers.ZGHandlers;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.mobs.MobRegistry;
import zollerngalaxy.network.teleporter.MessageTeleportToDimension;
import zollerngalaxy.potions.ZGPotions;
import zollerngalaxy.proxy.CommonProxy;
import zollerngalaxy.proxy.IProxy;
import zollerngalaxy.recipes.ZGRecipeRegistry;
import zollerngalaxy.util.OreDictRegistry;
import zollerngalaxy.util.RegisterUtilsZG;
import zollerngalaxy.util.ZGLore;

@Mod(modid="zollerngalaxy", version="2.0.42", name="Zollern Galaxy", dependencies="required-after:galacticraftcore@[4.0.2.261,); required-after:galacticraftplanets@[4.0.2.261,); required-after:micdoodlecore; after:forge@[14.23.5.2847,); after:tconstruct; before:planetprogression@[1.12.2-0.3.8,]; before:extraplanets; before:powersuits;", acceptedMinecraftVersions="[1.12.2]")
public class ZollernGalaxyCore {
    @SidedProxy(clientSide="zollerngalaxy.proxy.ClientProxy", serverSide="zollerngalaxy.proxy.CommonProxy")
    public static IProxy proxy;
    @Mod.Instance(value="zollerngalaxy")
    private static ZollernGalaxyCore INSTANCE;
    private static final boolean DEV_MODE = false;
    private static final boolean TEST_MODE = false;
    public static List<Item> itemList;
    public static List<Block> blocksList;
    public static SimpleNetworkWrapper snw;

    public static ZollernGalaxyCore instance() {
        return INSTANCE;
    }

    public boolean isInDevMode() {
        return false;
    }

    public boolean isInTestMode() {
        return false;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ZGHelper.Log("Beginning Pre-Initilization phase...");
        snw = NetworkRegistry.INSTANCE.newSimpleChannel("zollerngalaxy");
        snw.registerMessage(MessageTeleportToDimension.TeleportHandler.class, MessageTeleportToDimension.class, 1, Side.SERVER);
        ConfigManagerZG.init(event);
        ZGSoundEvents.init();
        ModHelperBase.detectMods();
        ZGInfo.init(event.getModMetadata());
        ZGLore.init();
        ZGPotions.init();
        EnchantmentListZG.init();
        RegisterUtilsZG.registerEventHandler(new RegistrationHandlerZG());
        ZGItems.init();
        ZGBlocks.init();
        ZGFluids.init();
        ZGBiomes.init();
        ZGStructures.init();
        ZGPlanets.init();
        ZGSpaceStations.init();
        OreDictRegistry.init();
        ZGCompats.init();
        ZollernGalaxyCore.instance();
        proxy.registerPreRendering();
        ZollernGalaxyCore.instance();
        proxy.preInit(event);
        ZGHelper.Log("Pre-Init phase complete.");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ZGHelper.Log("Beginning Initialization phase...");
        ZGTabs.init();
        ZGRecipeRegistry.init();
        ZGHandlers.init();
        for (BiomeGenBaseGC biome : ZGBiomes.biomeList) {
            biome.registerTypes((Biome)biome);
        }
        MobRegistry.init();
        ZollernGalaxyCore.instance();
        proxy.registerInitRendering();
        ZollernGalaxyCore.instance();
        proxy.init(event);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new CommonProxy());
        ZollernGalaxyAPI.init();
        ZGHelper.Log("Init phase complete.");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ZGHelper.Log("Beginning Post-Initialization phase...");
        ZGDimensions.init();
        ZollernGalaxyCore.instance();
        proxy.registerPostRendering();
        ZollernGalaxyCore.instance();
        proxy.postInit(event);
        ZGHelper.Log("Post-Init phase complete.");
    }

    static {
        itemList = new ArrayList<Item>();
        blocksList = new ArrayList<Block>();
        FluidRegistry.enableUniversalBucket();
    }

    @Mod.EventBusSubscriber(modid="zollerngalaxy")
    public static class RegistrationHandlerZG {
        @SubscribeEvent
        public static void registerBlocksEvent(RegistryEvent.Register<Block> event) {
            for (Block block : blocksList) {
                event.getRegistry().register((IForgeRegistryEntry)block);
            }
        }

        @SubscribeEvent
        public static void registerItemsEvent(RegistryEvent.Register<Item> event) {
            for (Item item : itemList) {
                event.getRegistry().register((IForgeRegistryEntry)item);
            }
        }
    }
}

