/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.compat;

import erogenousbeef.bigreactors.api.registry.Reactants;
import erogenousbeef.bigreactors.api.registry.ReactorInterior;
import erogenousbeef.bigreactors.api.registry.TurbineCoil;
import erogenousbeef.bigreactors.init.BrItems;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.items.ZGItems;
import zollerngalaxy.lib.helpers.ModHelperBase;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.recipes.InductionSmelterRecipes;

public class ExtremeReactorsCompat {
    public static final int fueltoniumReactantAmount = 2000;
    public static final int plutoniumReactantAmount = 4000;
    protected static final int FUEL = 0;
    protected static final int WASTE = 1;
    protected static final int fueltoniumColor = 65280;
    protected static final int plutoniumColor = 16766720;

    public static void init() {
        ZGHelper.Log("Initializing IMC with Extreme Reactors...");
        ExtremeReactorsCompat.registerTurbineBlock("blockCobalt", 2.5f, 1.0f, 2.4f);
        ExtremeReactorsCompat.registerTurbineBlock("blockEvenium", 2.6f, 1.02f, 2.5f);
        ExtremeReactorsCompat.registerTurbineBlock("blockVirinium", 2.7f, 1.04f, 2.6f);
        ExtremeReactorsCompat.registerTurbineBlock("blockSuperChargedCoal", 2.9f, 1.06f, 2.7f);
        ExtremeReactorsCompat.registerTurbineBlock("blockPlutonium", 3.2f, 1.06f, 3.4f);
        ExtremeReactorsCompat.registerTurbineBlock("blockZollernium", 3.5f, 1.07f, 3.5f);
        ExtremeReactorsCompat.registerTurbineBlock("blockChargium", 4.0f, 1.09f, 3.8f);
        ExtremeReactorsCompat.registerReactorFluid("whitelava", 0.82f, 2.9f, 6.05f, 4.5f);
        ExtremeReactorsCompat.registerReactorFluid("fueltonium", 0.92f, 3.95f, 6.5f, 5.6f);
        ExtremeReactorsCompat.registerReactorFluid("chargium", 1.92f, 5.0f, 6.5f, 6.7f);
        ExtremeReactorsCompat.registerReactorSolid("ingotFueltonium", "fueltonium", 2000, 0, 65280);
        ExtremeReactorsCompat.registerReactorSolid("ingotPlutonium", "plutonium", 4000, 0, 16766720);
        if (ModHelperBase.useThermalFoundation && ModHelperBase.useExtremeReactors && ConfigManagerZG.enableExtremeReactorsCompat) {
            InductionSmelterRecipes.addRecipe(20000, new ItemStack((Item)BrItems.ingotCyanite, 9), new ItemStack(ZGItems.dustEnrichment, 2), new ItemStack((Item)BrItems.ingotBlutonium, 2));
        }
        ZGHelper.Log("Extreme Reactors IMC: Done!");
    }

    private static void registerTurbineBlock(String oreDictName, float efficiency, float bonus, float extractionRate) {
        TurbineCoil.registerBlock((String)oreDictName, (float)efficiency, (float)bonus, (float)extractionRate);
        ZGHelper.Log("Extreme Reactors: Loaded '" + oreDictName + "' as a Turbine Coil.");
    }

    private static void registerReactorFluid(String fluidName, float absorption, float heatEfficiency, float moderation, float heatConductivity) {
        ReactorInterior.registerFluid((String)fluidName, (float)absorption, (float)heatEfficiency, (float)moderation, (float)heatConductivity);
        ZGHelper.Log("Extreme Reactors: Loaded '" + fluidName + "' as a Reactor Fluid.");
    }

    private static void registerReactorSolid(String oreDictName, String reactantName, int qty, int type, int clr) {
        Reactants.registerReactant((String)reactantName, (int)type, (int)clr);
        ZGHelper.Log("Extreme Reactors: Registered '" + reactantName + "' (" + oreDictName + ") as a Reactant.");
        Reactants.registerSolid((String)oreDictName, (String)reactantName, (int)qty);
        ZGHelper.Log("Extreme Reactors: Loaded '" + reactantName + "' (" + oreDictName + ") as a Reactor solid.");
    }
}

