/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.celestial.teleporttypes;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.entities.EntityLander;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.util.BiomeUtils;

public class TeleportTypeBaseZG
implements ITeleportType {
    protected double playerSpawnY = ZGHelper.rngDbl(400.0, 900.0);

    public boolean useParachute() {
        return true;
    }

    public Vector3 getPlayerSpawnLocation(WorldServer world, EntityPlayerMP player) {
        if (player != null) {
            double z;
            GCPlayerStats stats = GCPlayerStats.get((Entity)player);
            double x = stats.getCoordsTeleportedFromX();
            Biome biome = world.func_180494_b(new BlockPos(x, 0.0, z = stats.getCoordsTeleportedFromZ()));
            if (BiomeUtils.isOceanBiome(biome)) {
                return null;
            }
            int limit = ConfigManagerCore.otherPlanetWorldBorders - 2;
            if (limit > 20) {
                if (x > (double)limit) {
                    z *= (double)limit / x;
                    x = limit;
                } else if (x < (double)(-limit)) {
                    z *= (double)(-limit) / x;
                    x = -limit;
                }
                if (z > (double)limit) {
                    x *= (double)limit / z;
                    z = limit;
                } else if (z < (double)(-limit)) {
                    x *= (double)(-limit) / z;
                    z = -limit;
                }
            }
            return new Vector3(x, this.playerSpawnY, z);
        }
        return null;
    }

    public Vector3 getEntitySpawnLocation(WorldServer world, Entity entity) {
        return new Vector3(entity.field_70165_t, this.playerSpawnY, entity.field_70161_v);
    }

    public Vector3 getParaChestSpawnLocation(WorldServer world, EntityPlayerMP player, Random rand) {
        return null;
    }

    public void onSpaceDimensionChanged(World newWorld, EntityPlayerMP player, boolean ridingAutoRocket) {
        GCPlayerStats stats = GCPlayerStats.get((Entity)player);
        if (!ridingAutoRocket && !ConfigManagerCore.disableLander && stats.getTeleportCooldown() <= 0) {
            if (player.field_71075_bZ.field_75100_b) {
                player.field_71075_bZ.field_75100_b = false;
            }
            EntityLander lander = new EntityLander(player);
            lander.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            if (!newWorld.field_72995_K) {
                boolean previous = CompatibilityManager.forceLoadChunks((WorldServer)((WorldServer)newWorld));
                lander.field_98038_p = true;
                newWorld.func_72838_d((Entity)lander);
                lander.func_70029_a(newWorld);
                newWorld.func_72866_a((Entity)lander, true);
                player.func_184220_m((Entity)lander);
                CompatibilityManager.forceLoadChunksEnd((WorldServer)((WorldServer)newWorld), (boolean)previous);
                GCLog.debug((String)("Entering lander at : " + player.field_70165_t + "," + player.field_70161_v + " lander spawn at: " + lander.field_70165_t + "," + lander.field_70161_v));
            }
            stats.setTeleportCooldown(10);
        }
    }

    public void setupAdventureSpawn(EntityPlayerMP player) {
    }
}

