/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.celestial.spacestations;

import java.util.HashMap;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.dimension.TeleportTypeOrbit;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldProvider;
import zollerngalaxy.celestial.ZGPlanets;
import zollerngalaxy.celestial.spacestations.ZGSpaceStation;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.dimensions.worldproviders.orbit.WorldProviderOrbitAltum;
import zollerngalaxy.core.dimensions.worldproviders.orbit.WorldProviderOrbitAtheon;
import zollerngalaxy.core.dimensions.worldproviders.orbit.WorldProviderOrbitCaligro;
import zollerngalaxy.core.dimensions.worldproviders.orbit.WorldProviderOrbitCandora;
import zollerngalaxy.core.dimensions.worldproviders.orbit.WorldProviderOrbitCentotl;
import zollerngalaxy.core.dimensions.worldproviders.orbit.WorldProviderOrbitEden;
import zollerngalaxy.core.dimensions.worldproviders.orbit.WorldProviderOrbitExodus;
import zollerngalaxy.core.dimensions.worldproviders.orbit.WorldProviderOrbitKriffon;
import zollerngalaxy.core.dimensions.worldproviders.orbit.WorldProviderOrbitKronos;
import zollerngalaxy.core.dimensions.worldproviders.orbit.WorldProviderOrbitMaveth;
import zollerngalaxy.core.dimensions.worldproviders.orbit.WorldProviderOrbitMetztli;
import zollerngalaxy.core.dimensions.worldproviders.orbit.WorldProviderOrbitOasis;
import zollerngalaxy.core.dimensions.worldproviders.orbit.WorldProviderOrbitPerdita;
import zollerngalaxy.core.dimensions.worldproviders.orbit.WorldProviderOrbitPurgot;
import zollerngalaxy.core.dimensions.worldproviders.orbit.WorldProviderOrbitTlaloc;
import zollerngalaxy.core.dimensions.worldproviders.orbit.WorldProviderOrbitToci;
import zollerngalaxy.core.dimensions.worldproviders.orbit.WorldProviderOrbitVortex;
import zollerngalaxy.core.dimensions.worldproviders.orbit.WorldProviderOrbitXantheon;
import zollerngalaxy.core.dimensions.worldproviders.orbit.WorldProviderOrbitXathius;
import zollerngalaxy.core.dimensions.worldproviders.orbit.WorldProviderOrbitZollus;
import zollerngalaxy.items.ZGItems;
import zollerngalaxy.lib.helpers.ZGHelper;
import zollerngalaxy.lib.helpers.ZGRecipeHelper;

public class ZGSpaceStations {
    private static int totalSpaceStations = 0;
    public static ZGSpaceStation ZOLLUS_SPACE_STATION;
    public static ZGSpaceStation KRIFFON_SPACE_STATION;
    public static ZGSpaceStation PURGOT_SPACE_STATION;
    public static ZGSpaceStation EDEN_SPACE_STATION;
    public static ZGSpaceStation XATHIUS_SPACE_STATION;
    public static ZGSpaceStation OASIS_SPACE_STATION;
    public static ZGSpaceStation CANDORA_SPACE_STATION;
    public static ZGSpaceStation XANTHEON_SPACE_STATION;
    public static ZGSpaceStation ATHEON_SPACE_STATION;
    public static ZGSpaceStation PERDITA_SPACE_STATION;
    public static ZGSpaceStation ALTUM_SPACE_STATION;
    public static ZGSpaceStation CALIGRO_SPACE_STATION;
    public static ZGSpaceStation EXODUS_SPACE_STATION;
    public static ZGSpaceStation VORTEX_SPACE_STATION;
    public static ZGSpaceStation METZTLI_SPACE_STATION;
    public static ZGSpaceStation CENTOTL_SPACE_STATION;
    public static ZGSpaceStation TOCI_SPACE_STATION;
    public static ZGSpaceStation TLALOC_SPACE_STATION;
    public static ZGSpaceStation KRONOS_SPACE_STATION;
    public static ZGSpaceStation MAVETH_SPACE_STATION;

    public static void init() {
        ZGSpaceStations.initSpaceStations();
        ZGSpaceStations.registerSpaceStations();
        ZGSpaceStations.registerSpaceStationRecipes();
        ZGHelper.Log("Loaded a total of " + totalSpaceStations + " new space stations.");
    }

    private static void initSpaceStations() {
        ZOLLUS_SPACE_STATION = new ZGSpaceStation("zollus", ZGPlanets.planetZollus);
        ZOLLUS_SPACE_STATION.setDimensionInfo(ConfigManagerZG.spaceStationZollusId, ConfigManagerZG.spaceStationZollusStaticId, WorldProviderOrbitZollus.class);
        ++totalSpaceStations;
        EDEN_SPACE_STATION = new ZGSpaceStation("eden", ZGPlanets.planetEden);
        EDEN_SPACE_STATION.setDimensionInfo(ConfigManagerZG.spaceStationEdenId, ConfigManagerZG.spaceStationEdenStaticId, WorldProviderOrbitEden.class);
        ++totalSpaceStations;
        KRIFFON_SPACE_STATION = new ZGSpaceStation("kriffon", ZGPlanets.planetKriffon);
        KRIFFON_SPACE_STATION.setDimensionInfo(ConfigManagerZG.spaceStationKriffonId, ConfigManagerZG.spaceStationKriffonStaticId, WorldProviderOrbitKriffon.class);
        ++totalSpaceStations;
        PURGOT_SPACE_STATION = new ZGSpaceStation("purgot", ZGPlanets.planetPurgot);
        PURGOT_SPACE_STATION.setDimensionInfo(ConfigManagerZG.spaceStationPurgotId, ConfigManagerZG.spaceStationPurgotStaticId, WorldProviderOrbitPurgot.class);
        ++totalSpaceStations;
        XATHIUS_SPACE_STATION = new ZGSpaceStation("xathius", ZGPlanets.planetXathius);
        XATHIUS_SPACE_STATION.setDimensionInfo(ConfigManagerZG.spaceStationXathiusId, ConfigManagerZG.spaceStationXathiusStaticId, WorldProviderOrbitXathius.class);
        ++totalSpaceStations;
        OASIS_SPACE_STATION = new ZGSpaceStation("oasis", ZGPlanets.planetOasis);
        OASIS_SPACE_STATION.setDimensionInfo(ConfigManagerZG.spaceStationOasisId, ConfigManagerZG.spaceStationOasisStaticId, WorldProviderOrbitOasis.class);
        ++totalSpaceStations;
        XANTHEON_SPACE_STATION = new ZGSpaceStation("xantheon", ZGPlanets.planetXantheon);
        XANTHEON_SPACE_STATION.setDimensionInfo(ConfigManagerZG.spaceStationXantheonId, ConfigManagerZG.spaceStationXantheonStaticId, WorldProviderOrbitXantheon.class);
        ++totalSpaceStations;
        CANDORA_SPACE_STATION = new ZGSpaceStation("candora", ZGPlanets.planetCandora);
        CANDORA_SPACE_STATION.setDimensionInfo(ConfigManagerZG.spaceStationCandoraId, ConfigManagerZG.spaceStationCandoraStaticId, WorldProviderOrbitCandora.class);
        ++totalSpaceStations;
        ATHEON_SPACE_STATION = new ZGSpaceStation("atheon", ZGPlanets.planetAtheon);
        ATHEON_SPACE_STATION.setDimensionInfo(ConfigManagerZG.spaceStationAtheonId, ConfigManagerZG.spaceStationAtheonStaticId, WorldProviderOrbitAtheon.class);
        ++totalSpaceStations;
        PERDITA_SPACE_STATION = new ZGSpaceStation("perdita", ZGPlanets.planetPerdita);
        PERDITA_SPACE_STATION.setDimensionInfo(ConfigManagerZG.spaceStationPerditaId, ConfigManagerZG.spaceStationPerditaStaticId, WorldProviderOrbitPerdita.class);
        ++totalSpaceStations;
        ALTUM_SPACE_STATION = new ZGSpaceStation("altum", ZGPlanets.planetAltum);
        ALTUM_SPACE_STATION.setDimensionInfo(ConfigManagerZG.spaceStationAltumId, ConfigManagerZG.spaceStationAltumStaticId, WorldProviderOrbitAltum.class);
        ++totalSpaceStations;
        CALIGRO_SPACE_STATION = new ZGSpaceStation("caligro", ZGPlanets.planetCaligro);
        CALIGRO_SPACE_STATION.setDimensionInfo(ConfigManagerZG.spaceStationCaligroId, ConfigManagerZG.spaceStationCaligroStaticId, WorldProviderOrbitCaligro.class);
        ++totalSpaceStations;
        EXODUS_SPACE_STATION = new ZGSpaceStation("exodus", ZGPlanets.planetExodus);
        EXODUS_SPACE_STATION.setDimensionInfo(ConfigManagerZG.spaceStationExodusId, ConfigManagerZG.spaceStationExodusStaticId, WorldProviderOrbitExodus.class);
        ++totalSpaceStations;
        VORTEX_SPACE_STATION = new ZGSpaceStation("vortex", ZGPlanets.planetVortex);
        VORTEX_SPACE_STATION.setDimensionInfo(ConfigManagerZG.spaceStationVortexId, ConfigManagerZG.spaceStationVortexStaticId, WorldProviderOrbitVortex.class);
        ++totalSpaceStations;
        METZTLI_SPACE_STATION = new ZGSpaceStation("metztli", ZGPlanets.planetMetztli);
        METZTLI_SPACE_STATION.setDimensionInfo(ConfigManagerZG.spaceStationMetztliId, ConfigManagerZG.spaceStationMetztliStaticId, WorldProviderOrbitMetztli.class);
        ++totalSpaceStations;
        CENTOTL_SPACE_STATION = new ZGSpaceStation("centotl", ZGPlanets.planetCentotl);
        CENTOTL_SPACE_STATION.setDimensionInfo(ConfigManagerZG.spaceStationCentotlId, ConfigManagerZG.spaceStationCentotlStaticId, WorldProviderOrbitCentotl.class);
        ++totalSpaceStations;
        TOCI_SPACE_STATION = new ZGSpaceStation("toci", ZGPlanets.planetToci);
        TOCI_SPACE_STATION.setDimensionInfo(ConfigManagerZG.spaceStationTociId, ConfigManagerZG.spaceStationTociStaticId, WorldProviderOrbitToci.class);
        ++totalSpaceStations;
        TLALOC_SPACE_STATION = new ZGSpaceStation("tlaloc", ZGPlanets.planetTlaloc);
        TLALOC_SPACE_STATION.setDimensionInfo(ConfigManagerZG.spaceStationTlalocId, ConfigManagerZG.spaceStationTlalocStaticId, WorldProviderOrbitTlaloc.class);
        ++totalSpaceStations;
        KRONOS_SPACE_STATION = new ZGSpaceStation("kronos", ZGPlanets.planetKronos);
        KRONOS_SPACE_STATION.setDimensionInfo(ConfigManagerZG.spaceStationKronosId, ConfigManagerZG.spaceStationKronosStaticId, WorldProviderOrbitKronos.class);
        ++totalSpaceStations;
        MAVETH_SPACE_STATION = new ZGSpaceStation("maveth", ZGPlanets.planetMaveth);
        MAVETH_SPACE_STATION.setDimensionInfo(ConfigManagerZG.spaceStationMavethId, ConfigManagerZG.spaceStationMavethStaticId, WorldProviderOrbitMaveth.class);
        ++totalSpaceStations;
    }

    private static void registerSpaceStations() {
        ZGSpaceStations.registerSpaceStation(ZOLLUS_SPACE_STATION, "Zollus Space Station", "_zollus_orbit", WorldProviderOrbitZollus.class, ConfigManagerZG.spaceStationZollusId, ConfigManagerZG.spaceStationZollusStaticId);
        ZGSpaceStations.registerSpaceStation(KRIFFON_SPACE_STATION, "Kriffon Space Station", "_kriffon_orbit", WorldProviderOrbitKriffon.class, ConfigManagerZG.spaceStationKriffonId, ConfigManagerZG.spaceStationKriffonStaticId);
        ZGSpaceStations.registerSpaceStation(PURGOT_SPACE_STATION, "Purgot Space Station", "_purgot_orbit", WorldProviderOrbitPurgot.class, ConfigManagerZG.spaceStationPurgotId, ConfigManagerZG.spaceStationPurgotStaticId);
        ZGSpaceStations.registerSpaceStation(EDEN_SPACE_STATION, "Eden Space Station", "_eden_orbit", WorldProviderOrbitEden.class, ConfigManagerZG.spaceStationEdenId, ConfigManagerZG.spaceStationEdenStaticId);
        ZGSpaceStations.registerSpaceStation(XATHIUS_SPACE_STATION, "Xathius Space Station", "_xathius_orbit", WorldProviderOrbitXathius.class, ConfigManagerZG.spaceStationXathiusId, ConfigManagerZG.spaceStationXathiusStaticId);
        ZGSpaceStations.registerSpaceStation(OASIS_SPACE_STATION, "Oasis Space Station", "_oasis_orbit", WorldProviderOrbitOasis.class, ConfigManagerZG.spaceStationOasisId, ConfigManagerZG.spaceStationOasisStaticId);
        ZGSpaceStations.registerSpaceStation(XANTHEON_SPACE_STATION, "Xantheon Space Station", "_xantheon_orbit", WorldProviderOrbitXantheon.class, ConfigManagerZG.spaceStationXantheonId, ConfigManagerZG.spaceStationXantheonStaticId);
        ZGSpaceStations.registerSpaceStation(CANDORA_SPACE_STATION, "Candora Space Station", "_candora_orbit", WorldProviderOrbitCandora.class, ConfigManagerZG.spaceStationCandoraId, ConfigManagerZG.spaceStationCandoraStaticId);
        ZGSpaceStations.registerSpaceStation(ATHEON_SPACE_STATION, "Atheon Space Station", "_atheon_orbit", WorldProviderOrbitAtheon.class, ConfigManagerZG.spaceStationAtheonId, ConfigManagerZG.spaceStationAtheonStaticId);
        ZGSpaceStations.registerSpaceStation(PERDITA_SPACE_STATION, "Perdita Space Station", "_perdita_orbit", WorldProviderOrbitPerdita.class, ConfigManagerZG.spaceStationPerditaId, ConfigManagerZG.spaceStationPerditaStaticId);
        ZGSpaceStations.registerSpaceStation(ALTUM_SPACE_STATION, "Altum Space Station", "_altum_orbit", WorldProviderOrbitAltum.class, ConfigManagerZG.spaceStationAltumId, ConfigManagerZG.spaceStationAltumStaticId);
        ZGSpaceStations.registerSpaceStation(CALIGRO_SPACE_STATION, "Caligro Space Station", "_caligro_orbit", WorldProviderOrbitCaligro.class, ConfigManagerZG.spaceStationCaligroId, ConfigManagerZG.spaceStationCaligroStaticId);
        ZGSpaceStations.registerSpaceStation(EXODUS_SPACE_STATION, "Exodus Space Station", "_exodus_orbit", WorldProviderOrbitExodus.class, ConfigManagerZG.spaceStationExodusId, ConfigManagerZG.spaceStationExodusStaticId);
        ZGSpaceStations.registerSpaceStation(VORTEX_SPACE_STATION, "Vortex Space Station", "_vortex_orbit", WorldProviderOrbitVortex.class, ConfigManagerZG.spaceStationVortexId, ConfigManagerZG.spaceStationVortexStaticId);
        ZGSpaceStations.registerSpaceStation(METZTLI_SPACE_STATION, "Metztli Space Station", "_metztli_orbit", WorldProviderOrbitMetztli.class, ConfigManagerZG.spaceStationMetztliId, ConfigManagerZG.spaceStationMetztliStaticId);
        ZGSpaceStations.registerSpaceStation(CENTOTL_SPACE_STATION, "Centotl Space Station", "_centotl_orbit", WorldProviderOrbitCentotl.class, ConfigManagerZG.spaceStationCentotlId, ConfigManagerZG.spaceStationCentotlStaticId);
        ZGSpaceStations.registerSpaceStation(TOCI_SPACE_STATION, "Toci Space Station", "_toci_orbit", WorldProviderOrbitToci.class, ConfigManagerZG.spaceStationTociId, ConfigManagerZG.spaceStationTociStaticId);
        ZGSpaceStations.registerSpaceStation(TLALOC_SPACE_STATION, "Tlaloc Space Station", "_tlaloc_orbit", WorldProviderOrbitTlaloc.class, ConfigManagerZG.spaceStationTlalocId, ConfigManagerZG.spaceStationTlalocStaticId);
        ZGSpaceStations.registerSpaceStation(KRONOS_SPACE_STATION, "Kronos Space Station", "_kronos_orbit", WorldProviderOrbitKronos.class, ConfigManagerZG.spaceStationKronosId, ConfigManagerZG.spaceStationKronosStaticId);
        ZGSpaceStations.registerSpaceStation(MAVETH_SPACE_STATION, "Maveth Space Station", "_maveth_orbit", WorldProviderOrbitMaveth.class, ConfigManagerZG.spaceStationMavethId, ConfigManagerZG.spaceStationMavethStaticId);
    }

    public static void registerSpaceStationRecipes() {
        HashMap<Object, Integer> inputMap = new HashMap<Object, Integer>();
        inputMap.put("ingotTin", 32);
        inputMap.put("waferAdvanced", 1);
        inputMap.put(new ItemStack(ZGItems.heartium, 1), 24);
        inputMap.put(Items.field_151042_j, 24);
        ZGRecipeHelper.addSpaceStationRecipe(ConfigManagerZG.spaceStationZollusId, ConfigManagerZG.planetZollusDimensionId, inputMap);
        inputMap.clear();
        inputMap = new HashMap();
        inputMap.put("ingotTin", 32);
        inputMap.put("waferAdvanced", 1);
        inputMap.put(new ItemStack(ZGItems.ingotCobalt, 1), 24);
        inputMap.put(Items.field_151042_j, 24);
        ZGRecipeHelper.addSpaceStationRecipe(ConfigManagerZG.spaceStationKriffonId, ConfigManagerZG.planetKriffonDimensionId, inputMap);
        inputMap.clear();
        inputMap = new HashMap();
        inputMap.put("ingotTin", 32);
        inputMap.put("waferAdvanced", 1);
        inputMap.put(new ItemStack(ZGItems.ingotEvenium, 1), 24);
        inputMap.put(Items.field_151042_j, 24);
        ZGRecipeHelper.addSpaceStationRecipe(ConfigManagerZG.spaceStationPurgotId, ConfigManagerZG.planetPurgotDimensionId, inputMap);
        inputMap.clear();
        inputMap = new HashMap();
        inputMap.put("ingotTin", 32);
        inputMap.put("waferAdvanced", 1);
        inputMap.put(new ItemStack(ZGItems.ingotVirinium, 1), 24);
        inputMap.put(Items.field_151042_j, 24);
        ZGRecipeHelper.addSpaceStationRecipe(ConfigManagerZG.spaceStationEdenId, ConfigManagerZG.planetEdenDimensionId, inputMap);
        inputMap.clear();
        inputMap = new HashMap();
        inputMap.put("ingotLead", 32);
        inputMap.put("waferAdvanced", 1);
        inputMap.put(new ItemStack(ZGItems.prometheanCrystal, 1), 24);
        inputMap.put(Items.field_151043_k, 24);
        ZGRecipeHelper.addSpaceStationRecipe(ConfigManagerZG.spaceStationXathiusId, ConfigManagerZG.planetXathiusDimensionId, inputMap);
        inputMap.clear();
        inputMap = new HashMap();
        inputMap.put("ingotLead", 32);
        inputMap.put("waferAdvanced", 1);
        inputMap.put(new ItemStack(ZGItems.superChargedCoal, 1), 24);
        inputMap.put(Items.field_151043_k, 24);
        ZGRecipeHelper.addSpaceStationRecipe(ConfigManagerZG.spaceStationOasisId, ConfigManagerZG.planetOasisDimensionId, inputMap);
        inputMap.clear();
        inputMap = new HashMap();
        inputMap.put("ingotLead", 32);
        inputMap.put("waferAdvanced", 1);
        inputMap.put(new ItemStack(ZGItems.plutoniumCrystal, 1), 24);
        inputMap.put(Items.field_151043_k, 24);
        ZGRecipeHelper.addSpaceStationRecipe(ConfigManagerZG.spaceStationXantheonId, ConfigManagerZG.planetXantheonDimensionId, inputMap);
        inputMap.clear();
        inputMap = new HashMap();
        inputMap.put("ingotLead", 32);
        inputMap.put("waferAdvanced", 1);
        inputMap.put(new ItemStack(ZGItems.iceCreamSandwich, 1), 24);
        inputMap.put(Items.field_151102_aT, 24);
        ZGRecipeHelper.addSpaceStationRecipe(ConfigManagerZG.spaceStationCandoraId, ConfigManagerZG.planetCandoraDimensionId, inputMap);
        inputMap.clear();
        inputMap = new HashMap();
        inputMap.put("ingotLead", 32);
        inputMap.put("waferAdvanced", 1);
        inputMap.put(new ItemStack(ZGItems.ingotZollernium, 1), 24);
        inputMap.put(ZGItems.ingotAmaranth, 24);
        ZGRecipeHelper.addSpaceStationRecipe(ConfigManagerZG.spaceStationAtheonId, ConfigManagerZG.planetAtheonDimensionId, inputMap);
        inputMap.clear();
        inputMap = new HashMap();
        inputMap.put("ingotZucrite", 32);
        inputMap.put("waferAdvanced", 1);
        inputMap.put(new ItemStack(ZGItems.perdGlowdust, 1), 24);
        inputMap.put(ZGItems.compressedEmerald, 24);
        ZGRecipeHelper.addSpaceStationRecipe(ConfigManagerZG.spaceStationPerditaId, ConfigManagerZG.planetPerditaDimensionId, inputMap);
        inputMap.clear();
        inputMap = new HashMap();
        inputMap.put("ingotRhodium", 32);
        inputMap.put("waferAdvanced", 1);
        inputMap.put(new ItemStack(ZGItems.ascendium, 1), 24);
        inputMap.put(ZGItems.compressedZucrite, 24);
        ZGRecipeHelper.addSpaceStationRecipe(ConfigManagerZG.spaceStationAltumId, ConfigManagerZG.planetAltumDimensionId, inputMap);
        inputMap.clear();
        inputMap = new HashMap();
        inputMap.put("ingotRhodium", 32);
        inputMap.put("waferAdvanced", 1);
        inputMap.put(new ItemStack(ZGItems.witherite, 1), 24);
        inputMap.put(ZGItems.compressedAscendantAmaranth, 24);
        ZGRecipeHelper.addSpaceStationRecipe(ConfigManagerZG.spaceStationCaligroId, ConfigManagerZG.planetCaligroDimensionId, inputMap);
        inputMap.clear();
        inputMap = new HashMap();
        inputMap.put("ingotAmaranth", 32);
        inputMap.put("waferAdvanced", 1);
        inputMap.put(new ItemStack(ZGItems.edenCrystal, 1), 24);
        inputMap.put(ZGItems.compressedGold, 24);
        ZGRecipeHelper.addSpaceStationRecipe(ConfigManagerZG.spaceStationExodusId, ConfigManagerZG.planetExodusDimensionId, inputMap);
        inputMap.clear();
        inputMap = new HashMap();
        inputMap.put("ingotChargium", 32);
        inputMap.put("waferAdvanced", 1);
        inputMap.put(new ItemStack(ZGItems.stormCrystal, 1), 24);
        inputMap.put(ZGItems.compressedSuperChargedCoal, 24);
        ZGRecipeHelper.addSpaceStationRecipe(ConfigManagerZG.spaceStationVortexId, ConfigManagerZG.planetVortexDimensionId, inputMap);
        inputMap.clear();
        inputMap = new HashMap();
        inputMap.put("ingotChargium", 32);
        inputMap.put("waferAdvanced", 1);
        inputMap.put(new ItemStack(ZGItems.compressedCobalt, 1), 24);
        inputMap.put(ZGItems.compressedDiamond, 24);
        ZGRecipeHelper.addSpaceStationRecipe(ConfigManagerZG.spaceStationMetztliId, ConfigManagerZG.planetMetztliDimensionId, inputMap);
        inputMap.clear();
        inputMap = new HashMap();
        inputMap.put("ingotZollernium", 32);
        inputMap.put("waferAdvanced", 1);
        inputMap.put(new ItemStack(ZGItems.compressedZucrite, 1), 24);
        inputMap.put(ZGItems.compressedAscendantAmaranth, 24);
        ZGRecipeHelper.addSpaceStationRecipe(ConfigManagerZG.spaceStationCentotlId, ConfigManagerZG.planetCentotlDimensionId, inputMap);
        inputMap.clear();
        inputMap = new HashMap();
        inputMap.put("gemSapphire", 32);
        inputMap.put("waferAdvanced", 1);
        inputMap.put(new ItemStack(Items.field_151128_bU, 8), 24);
        inputMap.put(ZGItems.purgCrystal, 24);
        ZGRecipeHelper.addSpaceStationRecipe(ConfigManagerZG.spaceStationTociId, ConfigManagerZG.planetTociDimensionId, inputMap);
        inputMap.clear();
        inputMap = new HashMap();
        inputMap.put("ingotRhodium", 32);
        inputMap.put("waferAdvanced", 1);
        inputMap.put(new ItemStack(ZGItems.compressedRhodium, 8), 24);
        inputMap.put(ZGItems.rokkite, 24);
        ZGRecipeHelper.addSpaceStationRecipe(ConfigManagerZG.spaceStationTlalocId, ConfigManagerZG.planetTlalocDimensionId, inputMap);
        inputMap.clear();
        inputMap = new HashMap();
        inputMap.put("gemZanium", 32);
        inputMap.put("waferAdvanced", 1);
        inputMap.put(new ItemStack(ZGItems.compressedZanium, 8), 24);
        inputMap.put(ZGItems.netheridium, 24);
        ZGRecipeHelper.addSpaceStationRecipe(ConfigManagerZG.spaceStationKronosId, ConfigManagerZG.planetKronosDimensionId, inputMap);
        inputMap.clear();
        inputMap = new HashMap();
        inputMap.put("ingotVibranium", 64);
        inputMap.put("waferAdvanced", 1);
        inputMap.put(new ItemStack(ZGItems.compressedZucrite, 8), 24);
        inputMap.put(ZGItems.rokkite, 24);
        ZGRecipeHelper.addSpaceStationRecipe(ConfigManagerZG.spaceStationKronosId, ConfigManagerZG.planetMavethDimensionId, inputMap);
        inputMap.clear();
    }

    private static void registerSpaceStation(ZGSpaceStation spaceStation, String stationName, String stationStringId, Class<? extends WorldProvider> providerClass, int stationId, int stationStaticId) {
        GalaxyRegistry.registerSatellite((Satellite)spaceStation);
        GalacticraftRegistry.registerTeleportType(providerClass, (ITeleportType)new TeleportTypeOrbit());
        GalacticraftRegistry.registerDimension((String)stationName, (String)stationStringId, (int)stationId, providerClass, (boolean)false);
        GalacticraftRegistry.registerDimension((String)stationName, (String)stationStringId, (int)stationStaticId, providerClass, (boolean)true);
    }
}

