/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.celestial.spacestations;

import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.core.world.gen.BiomeOrbit;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import zollerngalaxy.celestial.ZGPlanet;

public class ZGSpaceStation
extends Satellite {
    public ZGSpaceStation(String stationName, ZGPlanet parentBody) {
        super("spacestation." + stationName);
        this.setParentBody(parentBody);
        this.setTierRequired(parentBody.getTierRequirement());
        this.setupSpaceStation();
    }

    protected void setupSpaceStation() {
        this.setRelativeSize(0.2667f);
        this.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(9.0f, 9.0f));
        this.setRelativeOrbitTime(20.0f);
        this.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/space_station.png"));
        this.addChecklistKeys(new String[]{"thermal_padding", "equip_oxygen_suit", "equip_parachute"});
        this.setBiomeInfo(new Biome[]{BiomeOrbit.space});
    }

    public ZGSpaceStation setParentPlanet(ZGPlanet planet) {
        this.setParentBody(planet);
        return this;
    }
}

