/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.blocks.sirens;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.blocks.ZGBlockBase;
import zollerngalaxy.core.enums.EnumHarvestLevelZG;
import zollerngalaxy.core.enums.EnumHarvestToolZG;
import zollerngalaxy.creativetabs.ZGTabs;

public class SirenBlockBase
extends ZGBlockBase {
    protected SoundEvent sound = null;
    protected boolean isOn = false;

    public SirenBlockBase(String blockName, SoundEvent sirenSound, boolean stateIn) {
        super(blockName);
        this.setIsOn(stateIn);
        if (stateIn) {
            this.func_149715_a(1.0f);
        }
        this.setMaterial(Material.field_151573_f);
        this.setHarvestLevel(EnumHarvestToolZG.PICKAXE.getHarvestTool(), EnumHarvestLevelZG.IRON.getHarvestLevel());
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.setSound(SoundType.field_185852_e);
        this.setSirenBlockSound(sirenSound);
        this.func_149675_a(true);
    }

    public Block setSirenBlockSound(SoundEvent par1) {
        this.sound = par1;
        return this;
    }

    public SoundEvent getSirenBlockSound() {
        return this.sound;
    }

    public Block setIsOn(boolean stateIn) {
        this.isOn = stateIn;
        return this;
    }

    public boolean getIsOn() {
        return this.isOn;
    }

    public void playAlarm(World worldIn, BlockPos pos) {
        if (this.isOn && worldIn.func_175640_z(pos)) {
            float soundPitch = worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f;
            worldIn.func_184133_a(null, pos, this.getSirenBlockSound(), SoundCategory.AMBIENT, 1.5f, soundPitch);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        CreativeTabs blocksTab = ZGTabs.zgBlocksTab;
        if (this.isOn) {
            return null;
        }
        return blocksTab;
    }
}

