/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.blocks.fluids;

import micdoodle8.mods.galacticraft.core.wrappers.IFluidHandlerWrapper;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.blocks.fluids.IZGFluidModel;
import zollerngalaxy.lib.ZGMapper;

public class ZGFluidBase
extends BlockFluidClassic
implements IZGFluidModel {
    protected String name;
    public IFluidHandlerWrapper wrapper;
    public EnumFacing side;

    public ZGFluidBase(String fluidName, Fluid fluid, Material material) {
        super(fluid, material);
        this.setupFluid(fluidName);
    }

    public ZGFluidBase(String fluidName, Fluid fluid, Material material, MapColor mapColor) {
        super(fluid, material);
        this.setupFluid(fluidName);
    }

    protected void setupFluid(String fluidName) {
        this.name = fluidName;
        this.func_149663_c("fluid_" + fluidName);
        this.setRegistryName("fluid_" + fluidName);
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public boolean canDrain(World worldIn, BlockPos pos) {
        return true;
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, pos);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        Item item = Item.func_150898_a((Block)this);
        ZGMapper mapper = new ZGMapper("zollerngalaxy", "fluid", this.name);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)mapper);
    }
}

