/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.blocks.crystals;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.blocks.ZGBlockBase;
import zollerngalaxy.blocks.fluids.ZGFluidBase;
import zollerngalaxy.core.enums.EnumHarvestLevelZG;
import zollerngalaxy.core.enums.EnumHarvestToolZG;
import zollerngalaxy.lib.helpers.ZGHelper;

public class ZGCrystalBlock
extends ZGBlockBase {
    protected static final AxisAlignedBB CRYSTAL_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9575, 1.5, 0.9575);
    protected int minDropped;
    protected int maxDropped;
    protected Item droppedItem;
    private final ZGCrystalBlock instance;

    public ZGCrystalBlock(String blockName, float hardResist, Item droppedItemIn) {
        super(blockName, hardResist);
        this.minDropped = this.enableExtremeMode ? 4 : 2;
        this.maxDropped = this.enableExtremeMode ? 8 : 4;
        this.droppedItem = null;
        this.instance = this;
        this.droppedItem = droppedItemIn;
        this.init();
    }

    public ZGCrystalBlock(String blockName, Item droppedItemIn) {
        super(blockName);
        this.minDropped = this.enableExtremeMode ? 4 : 2;
        this.maxDropped = this.enableExtremeMode ? 8 : 4;
        this.droppedItem = null;
        this.func_149711_c(5.6f);
        this.func_149752_b(9.8f);
        this.instance = this;
        this.droppedItem = droppedItemIn;
        this.init();
    }

    private void init() {
        this.setShouldJSONIgnore(true);
        this.setSound(SoundType.field_185853_f);
        this.setMaterial(Material.field_151573_f);
        this.setHarvestLevel(EnumHarvestToolZG.OMNITOOL.getHarvestTool(), EnumHarvestLevelZG.OMNI.getHarvestLevel());
        this.func_149715_a(1.0f);
        this.field_149785_s = true;
    }

    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        Block block = world.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p())).func_177230_c();
        return block != Blocks.field_150350_a && block != this.instance && !(block instanceof ZGFluidBase);
    }

    public Item func_180660_a(IBlockState par1BlockState, Random rand, int fortune) {
        return this.droppedItem;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int j = ZGHelper.rngInt(this.getMinDropped(), this.getMaxDropped());
        for (int k = 0; k < j; ++k) {
            drops.add((Object)new ItemStack(this.droppedItem, 1, 0));
        }
    }

    public Block setMinMaxDropped(int minD, int maxD) {
        this.setMinDropped(minD);
        this.setMaxDropped(maxD);
        return this;
    }

    public Block setMaxDropped(int md) {
        this.maxDropped = md;
        return this;
    }

    public Block setMinDropped(int md) {
        this.minDropped = md;
        return this;
    }

    public int getMinDropped() {
        return this.minDropped;
    }

    public int getMaxDropped() {
        return this.maxDropped;
    }

    public int func_149745_a(Random rand) {
        int numDropped = 1;
        int extMod = this.enableExtremeMode ? 1 : 0;
        numDropped = ZGHelper.rngInt(1, 1 + extMod);
        return numDropped;
    }

    public int func_149679_a(int fortune, Random random) {
        if (fortune > 0 && Item.func_150898_a((Block)this) != this.func_180660_a((IBlockState)this.func_176194_O().func_177619_a().iterator().next(), random, fortune)) {
            int i = random.nextInt(fortune + 2) - 1;
            if (i < 0) {
                i = 0;
            }
            return this.func_149745_a(random) * (i + 1);
        }
        return this.func_149745_a(random);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CRYSTAL_AABB;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public boolean shouldJSONIgnore() {
        return true;
    }
}

