/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.blocks.crops;

import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import zollerngalaxy.blocks.IJSONBlock;
import zollerngalaxy.blocks.ISingleZGBlockRender;
import zollerngalaxy.core.ZollernGalaxyCore;
import zollerngalaxy.lib.helpers.json.JSONFactory;

public abstract class ZGBlockCropBase
extends BlockCrops
implements ISingleZGBlockRender,
IJSONBlock {
    protected ZollernGalaxyCore core = ZollernGalaxyCore.instance();
    protected static String name;
    protected boolean shouldJSONIgnore = false;
    private static final AxisAlignedBB[] CROP_AABB;

    public ZGBlockCropBase(String cropNameIn) {
        cropNameIn = cropNameIn + "_crop";
        name = cropNameIn;
        this.setBlockName((Block)this, cropNameIn);
        this.setShouldJSONIgnore(true);
        if (this.core.isInDevMode()) {
            for (int i = 0; i <= 3; ++i) {
                JSONFactory.registerCrop(cropNameIn.replace("_crop", "") + "_stage_" + i);
            }
            JSONFactory.registerCropBlockState(cropNameIn);
        }
    }

    protected Item func_149866_i() {
        return Items.field_151014_N;
    }

    protected Item func_149865_P() {
        return Items.field_151015_O;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CROP_AABB[(Integer)state.func_177229_b((IProperty)this.func_185524_e())];
    }

    public void setBlockName(Block block, String blockName) {
        block.func_149663_c(blockName);
    }

    @Override
    public boolean shouldJSONIgnore() {
        return true;
    }

    @Override
    public String getName() {
        return name.toLowerCase();
    }

    public Block setShouldJSONIgnore(boolean ignore) {
        this.shouldJSONIgnore = ignore;
        return this;
    }

    static {
        CROP_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.4375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5625, 1.0)};
    }
}

