/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import zollerngalaxy.blocks.ZGBlockLeaves;
import zollerngalaxy.lib.helpers.ZGHelper;

public class ZGFruitLeaves
extends ZGBlockLeaves {
    private Item droppedFood;

    public ZGFruitLeaves(String blockName, Block sapling, Item itemFood) {
        super(blockName, sapling);
        this.droppedFood = itemFood;
        this.droppedSapling = sapling;
    }

    @Override
    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176206_d(worldIn, pos, state);
        this.dropFruit(worldIn, pos);
        this.dropSapling(worldIn, pos);
    }

    @Override
    protected void dropFruit(World worldIn, BlockPos pos, IBlockState state, int chance) {
        super.dropFruit(worldIn, pos, state, chance);
        this.dropFruit(worldIn, pos);
        if (ZGHelper.getRNGChance(1, 2)) {
            this.dropSapling(worldIn, pos);
        }
    }

    protected void dropFruit(World worldIn, BlockPos pos) {
        if (!worldIn.field_72995_K && ZGHelper.getRNGChance(4, 8)) {
            int randInt = ZGHelper.rngInt(1, 2);
            for (int i = 0; i < randInt; ++i) {
                ZGHelper.dropItem(this.droppedFood, worldIn, pos);
            }
        }
    }

    protected void dropSapling(World worldIn, BlockPos pos) {
        if (ZGHelper.getRNGChance(1, 4)) {
            int randInt = ZGHelper.rngInt(1, 2);
            for (int i = 0; i < randInt; ++i) {
                ZGHelper.dropItem(Item.func_150898_a((Block)this.droppedSapling), worldIn, pos);
            }
        }
    }
}

