/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.blocks.ZGBlockDirt;
import zollerngalaxy.blocks.ZGBlockTallGrass;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.core.ZollernGalaxyCore;
import zollerngalaxy.core.enums.EnumBlockType;
import zollerngalaxy.lib.helpers.json.JSONFactory;

public class ZGBlockGrass
extends ZGBlockDirt
implements IGrowable {
    protected Block blockDirt = ZGBlocks.edenSoil;
    protected Block blockTallGrass = ZGBlocks.edenTallGrass;

    public ZGBlockGrass(String blockName, float hardResist) {
        super(blockName, hardResist);
        this.setMaterial(Material.field_151577_b);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(true);
        this.setShouldJSONIgnore(true);
        this.setBlockType(EnumBlockType.GRASS);
        if (ZollernGalaxyCore.instance().isInDevMode()) {
            JSONFactory.registerGrassBlock(blockName, this.getDirtBlock().func_149739_a().substring(5));
        }
    }

    public ZGBlockGrass(String blockName) {
        this(blockName, 1.4f);
    }

    public Block setDirtBlock(Block block) {
        this.blockDirt = block;
        return this;
    }

    public Block setTallGrassBlock(Block block) {
        this.blockTallGrass = block;
        return this;
    }

    public Block setDirtBlocks(Block dirtBlock, Block tallGrassBlock) {
        this.setDirtBlock(dirtBlock);
        this.setTallGrassBlock(tallGrassBlock);
        return this;
    }

    public Block getDirtBlock() {
        return this.blockDirt;
    }

    public Block getTallGrassBlock() {
        return this.blockTallGrass;
    }

    @Override
    public boolean shouldJSONIgnore() {
        return true;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        BlockPos blockpos = pos.func_177984_a();
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos blockpos1 = blockpos;
            int j = 0;
            if (this.getTallGrassBlock() == null) continue;
            while (true) {
                if (j >= i / 16) {
                    IBlockState iblockstate1;
                    if (!worldIn.func_175623_d(blockpos1)) continue block0;
                    if (rand.nextInt(8) == 0) {
                        worldIn.func_180494_b(blockpos1).plantFlower(worldIn, rand, blockpos1);
                        continue block0;
                    }
                    ZGBlockTallGrass tallGrass = (ZGBlockTallGrass)this.getTallGrassBlock();
                    if (!tallGrass.canBlockStay(worldIn, blockpos1, iblockstate1 = tallGrass.func_176223_P())) continue block0;
                    worldIn.func_180501_a(blockpos1, iblockstate1, 3);
                    continue block0;
                }
                if (worldIn.func_180495_p((blockpos1 = blockpos1.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).func_177977_b()).func_177230_c() != this || worldIn.func_180495_p(blockpos1).func_185915_l()) continue block0;
                ++j;
            }
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            if (!worldIn.func_175697_a(pos, 3)) {
                return;
            }
            if (worldIn.func_175671_l(pos.func_177984_a()) < 4 && worldIn.func_180495_p(pos.func_177984_a()).getLightOpacity((IBlockAccess)worldIn, pos.func_177984_a()) > 2) {
                worldIn.func_175656_a(pos, this.getDirtBlock().func_176223_P());
            } else if (worldIn.func_175671_l(pos.func_177984_a()) >= 9) {
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                    if (blockpos.func_177956_o() >= 0 && blockpos.func_177956_o() < 256 && !worldIn.func_175667_e(blockpos)) {
                        return;
                    }
                    IBlockState iblockstate = worldIn.func_180495_p(blockpos.func_177984_a());
                    IBlockState iblockstate1 = worldIn.func_180495_p(blockpos);
                    if (iblockstate1.func_177230_c() != this.getDirtBlock() || worldIn.func_175671_l(blockpos.func_177984_a()) < 4 || iblockstate.getLightOpacity((IBlockAccess)worldIn, pos.func_177984_a()) > 2) continue;
                    worldIn.func_175656_a(blockpos, this.func_176223_P());
                }
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this.getDirtBlock());
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }
}

