/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.xantheon;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.entities.EntityAlienVillager;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.biomes.decorators.BiomeDecoratorXantheon;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.blocks.fluids.ZGFluids;
import zollerngalaxy.celestial.ZGPlanets;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;
import zollerngalaxy.mobs.entities.EntityGrayAlien;
import zollerngalaxy.mobs.entities.robots.EntityVexBot;
import zollerngalaxy.mobs.entities.robots.sentinels.EntitySentinelDrone;

public class BiomeXantheonBase
extends BiomeSpace {
    protected static final IBlockState STONE = ZGBlocks.xantheonStone.func_176223_P();
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    protected static final IBlockState GRAVEL = ZGBlocks.xantheonConstructBlock.func_176223_P();
    protected static final IBlockState DIRT = ZGBlocks.xantheonChrome.func_176223_P();
    protected static final IBlockState ICE = Blocks.field_150403_cj.func_176223_P();
    protected static final IBlockState RADIOLARIA = ZGFluids.blockWhiteLavaFluid.func_176223_P();
    public static int grassFoilageColorMultiplier = 0;
    public BiomeDecoratorXantheon biomeDecor = this.getBiomeDecorator();
    protected static final int SEA_LEVEL = 63;
    protected static final int SEA_FLOOR_LEVEL = 42;

    public BiomeXantheonBase(String singleName, Biome.BiomeProperties props) {
        super("xantheon", props);
        props.func_185396_a();
        this.setBiomeType(EnumBiomeTypeZG.TECHY);
        this.setTempCategory(Biome.TempCategory.COLD);
        this.setTemp(-26.5f);
        this.field_76766_R = false;
        this.biomeDecor.field_76802_A = -999;
        this.biomeDecor.field_76832_z = -999;
        this.biomeDecor.field_76803_B = -999;
        this.biomeDecor.field_76798_D = -999;
        this.clearAllNonMonsterSpawning();
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityVexBot.class, 100, 1, 2));
        if (ConfigManagerZG.enableSentinels) {
            this.field_76761_J.add(new Biome.SpawnListEntry(EntitySentinelDrone.class, 10, 1, 2));
        }
        if (ConfigManagerZG.enableAlienVillagerSpawn) {
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityAlienVillager.class, this.villagerSpawnRate, this.villagerMinSpawnRate, this.villagerMaxSpawnRate));
        }
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityGrayAlien.class, 15, 1, 1));
        this.field_76752_A = ZGBlocks.xantheonRock.func_176223_P();
        this.field_76753_B = ZGBlocks.xantheonChrome.func_176223_P();
        this.stoneBlock = ZGBlocks.xantheonStone;
        this.setPlanetForBiome(ZGPlanets.planetXantheon);
    }

    public final void generateXantheonTerrain(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int i = worldIn.func_181545_F();
        float biomeHeight = this.getBiomeHeight();
        IBlockState topState = this.field_76752_A;
        IBlockState fillState = this.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int l = x & 0xF;
        int i1 = z & 0xF;
        for (int j1 = 255; j1 >= 0; --j1) {
            if (j1 == 0) {
                chunkPrimerIn.func_177855_a(i1, j1, l, BEDROCK);
                continue;
            }
            if (j1 >= 128) {
                chunkPrimerIn.func_177855_a(i1, j1, l, AIR);
                continue;
            }
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
            if (this.getBiomeType() == EnumBiomeTypeZG.OCEAN) {
                if (j1 < 63 && j1 > 42) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, RADIOLARIA);
                    continue;
                }
                if (j1 < 42) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, STONE);
                    continue;
                }
                if (j1 == 42) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, DIRT);
                    continue;
                }
                if (j1 < 63) continue;
                chunkPrimerIn.func_177855_a(i1, j1, l, AIR);
                continue;
            }
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2.func_177230_c() != ZGBlocks.xantheonStone) continue;
            if (j == -1) {
                if (k <= 0) {
                    topState = AIR;
                    fillState = STONE;
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    topState = this.field_76752_A;
                    fillState = this.field_76753_B;
                }
                if (j1 < i && (topState == null || topState.func_185904_a() == Material.field_151579_a)) {
                    topState = ICE;
                }
                j = k;
                if (j1 >= i - 1) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, topState);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    topState = AIR;
                    fillState = STONE;
                    chunkPrimerIn.func_177855_a(i1, j1, l, GRAVEL);
                    continue;
                }
                chunkPrimerIn.func_177855_a(i1, j1, l, fillState);
                continue;
            }
            if (j <= 0) continue;
            --j;
            chunkPrimerIn.func_177855_a(i1, j1, l, fillState);
        }
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        this.generateXantheonTerrain(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public float func_76741_f() {
        return 0.1f;
    }

    public BiomeDecorator func_76729_a() {
        return new BiomeDecoratorXantheon();
    }

    protected BiomeDecoratorXantheon getBiomeDecorator() {
        return (BiomeDecoratorXantheon)this.field_76760_I;
    }

    public int getModdedBiomeFoliageColor(int original) {
        return grassFoliageColor;
    }

    public int getModdedBiomeGrassColor(int original) {
        return grassFoliageColor;
    }
}

