/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.vortex;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.entities.EntityAlienVillager;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedEnderman;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedWitch;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.biomes.decorators.BiomeDecoratorVortex;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.blocks.fluids.ZGFluids;
import zollerngalaxy.celestial.ZGPlanets;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;
import zollerngalaxy.mobs.entities.EntityMegaCreeper;

public class BiomeVortexBase
extends BiomeSpace {
    protected static final IBlockState STONE = ZGBlocks.vortexStone.func_176223_P();
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    protected static final IBlockState VOLTROCK = ZGBlocks.vortexVoltRock.func_176223_P();
    protected static final IBlockState COBBLESTONE = ZGBlocks.vortexCobblestone.func_176223_P();
    protected static final IBlockState WATER = Blocks.field_150355_j.func_176223_P();
    protected static final int SEA_LEVEL = 53;
    protected static final int SEA_FLOOR_LEVEL = 32;

    public BiomeVortexBase(String singleName, Biome.BiomeProperties props) {
        super(singleName, props);
        this.init();
    }

    public BiomeVortexBase(String singleName) {
        this(singleName, new Biome.BiomeProperties(singleName));
    }

    private void init() {
        this.setTempCategory(Biome.TempCategory.WARM);
        this.field_76760_I.field_76802_A = -999;
        this.field_76760_I.field_76832_z = -999;
        this.field_76760_I.field_76803_B = -999;
        this.field_76760_I.field_76798_D = -999;
        this.clearAllSpawning();
        if (ConfigManagerZG.enableAlienVillagerSpawn) {
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityAlienVillager.class, this.villagerSpawnRate, this.villagerMinSpawnRate, this.villagerMaxSpawnRate));
        }
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 80, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 80, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 80, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 80, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityMegaCreeper.class, 80, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 80, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedWitch.class, 80, 1, 4));
        this.setPlanetForBiome(ZGPlanets.planetVortex);
    }

    public final void generateVortexTerrain(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int i = worldIn.func_181545_F();
        float biomeHeight = this.getBiomeHeight();
        IBlockState topState = this.field_76752_A;
        IBlockState fillState = this.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int l = x & 0xF;
        int i1 = z & 0xF;
        for (int j1 = 255; j1 >= 0; --j1) {
            if (j1 == 0) {
                chunkPrimerIn.func_177855_a(i1, j1, l, BEDROCK);
                continue;
            }
            if (j1 >= 128) {
                chunkPrimerIn.func_177855_a(i1, j1, l, AIR);
                continue;
            }
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
            if (this.getBiomeType() == EnumBiomeTypeZG.OCEAN) {
                if (j1 < 53 && j1 > 32) {
                    IBlockState FLUID_BLOCK = ZGFluids.blockChargiumFluid.func_176223_P();
                    chunkPrimerIn.func_177855_a(i1, j1, l, FLUID_BLOCK);
                    continue;
                }
                if (j1 < 32) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, STONE);
                    continue;
                }
                if (j1 == 32) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, COBBLESTONE);
                    continue;
                }
                if (j1 < 53) continue;
                chunkPrimerIn.func_177855_a(i1, j1, l, AIR);
                continue;
            }
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2.func_177230_c() != ZGBlocks.vortexStone) continue;
            if (j == -1) {
                if (k <= 0) {
                    topState = AIR;
                    fillState = STONE;
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    topState = this.field_76752_A;
                    fillState = this.field_76753_B;
                }
                j = k;
                if (j1 >= i - 1) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, topState);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    topState = AIR;
                    fillState = STONE;
                    chunkPrimerIn.func_177855_a(i1, j1, l, VOLTROCK);
                    continue;
                }
                chunkPrimerIn.func_177855_a(i1, j1, l, fillState);
                continue;
            }
            if (j <= 0) continue;
            --j;
            chunkPrimerIn.func_177855_a(i1, j1, l, fillState);
        }
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        this.generateVortexTerrain(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public float func_76741_f() {
        return 0.001f;
    }

    public BiomeDecorator func_76729_a() {
        return new BiomeDecoratorVortex();
    }

    protected BiomeDecoratorVortex getBiomeDecorator() {
        return (BiomeDecoratorVortex)this.field_76760_I;
    }

    public int getModdedBiomeFoliageColor(int original) {
        return grassFoliageColor;
    }

    public int getModdedBiomeGrassColor(int original) {
        return grassFoliageColor;
    }
}

