/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.providers;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.biomes.genlayers.astros.GenLayerAstros;
import zollerngalaxy.celestial.ZGPlanets;

public class BiomeProviderAstros
extends BiomeProvider {
    private GenLayer unzoomedBiomes;
    private GenLayer zoomedBiomes;
    private BiomeCache biomeCache;
    private List<Biome> biomesToSpawnIn;
    private CelestialBody body = ZGPlanets.moonAstros;

    protected BiomeProviderAstros() {
        this.biomeCache = new BiomeCache((BiomeProvider)this);
        this.biomesToSpawnIn = new ArrayList<Biome>();
    }

    public BiomeProviderAstros(long seed, WorldType type) {
        this();
        GenLayer[] genLayers = GenLayerAstros.createWorld(seed);
        this.unzoomedBiomes = genLayers[0];
        this.zoomedBiomes = genLayers[1];
    }

    public BiomeProviderAstros(World world) {
        this(world.func_72905_C(), world.func_72912_H().func_76067_t());
    }

    public List<Biome> func_76932_a() {
        return this.biomesToSpawnIn;
    }

    public Biome func_180300_a(BlockPos pos, Biome defaultBiome) {
        BiomeAdaptive.setBodyMultiBiome((CelestialBody)this.body);
        return this.biomeCache.func_180284_a(pos.func_177958_n(), pos.func_177952_p(), (Biome)BiomeAdaptive.biomeDefault);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76939_a(float par1, int par2) {
        return par1;
    }

    public Biome[] func_76937_a(Biome[] biomes, int x, int z, int length, int width) {
        IntCache.func_76446_a();
        BiomeAdaptive.setBodyMultiBiome((CelestialBody)this.body);
        if (biomes == null || biomes.length < length * width) {
            biomes = new Biome[length * width];
        }
        int[] intArray = this.unzoomedBiomes.func_75904_a(x, z, length, width);
        for (int i = 0; i < length * width; ++i) {
            biomes[i] = intArray[i] >= 0 ? Biome.func_150568_d((int)intArray[i]) : BiomeAdaptive.biomeDefault;
        }
        return biomes;
    }

    public Biome[] func_76933_b(@Nullable Biome[] oldBiomeList, int x, int z, int width, int depth) {
        return this.func_76931_a(oldBiomeList, x, z, width, depth, true);
    }

    public Biome[] func_76931_a(@Nullable Biome[] listToReuse, int x, int z, int width, int length, boolean cacheFlag) {
        IntCache.func_76446_a();
        BiomeAdaptive.setBodyMultiBiome((CelestialBody)this.body);
        if (listToReuse == null || listToReuse.length < length * width) {
            listToReuse = new Biome[width * length];
        }
        if (cacheFlag && width == 16 && length == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
            Biome[] cached = this.biomeCache.func_76839_e(x, z);
            System.arraycopy(cached, 0, listToReuse, 0, width * length);
            return listToReuse;
        }
        int[] zoomed = this.zoomedBiomes.func_75904_a(x, z, width, length);
        for (int i = 0; i < width * length; ++i) {
            listToReuse[i] = zoomed[i] >= 0 ? Biome.func_150568_d((int)zoomed[i]) : BiomeAdaptive.biomeDefault;
        }
        return listToReuse;
    }

    public boolean func_76940_a(int x, int z, int range, List<Biome> viables) {
        int i = x - range >> 2;
        int j = z - range >> 2;
        int k = x + range >> 2;
        int l = z + range >> 2;
        int diffX = k - i + 1;
        int diffZ = l - j + 1;
        int[] unzoomed = this.unzoomedBiomes.func_75904_a(i, j, diffX, diffZ);
        for (int a = 0; a < diffX * diffZ; ++a) {
            Biome biome = Biome.func_150568_d((int)unzoomed[a]);
            if (viables.contains(biome)) continue;
            return false;
        }
        return true;
    }

    public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
        int i = x - range >> 2;
        int j = z - range >> 2;
        int k = x + range >> 2;
        int l = z + range >> 2;
        int diffX = k - i + 1;
        int diffZ = l - j + 1;
        int[] unzoomed = this.unzoomedBiomes.func_75904_a(i, j, diffX, diffZ);
        BlockPos blockPos = null;
        int count = 0;
        for (int a = 0; a < unzoomed.length; ++a) {
            int x0 = i + a % diffX << 2;
            int z0 = j + a / diffX << 2;
            Biome biome = Biome.func_150568_d((int)unzoomed[a]);
            if (!biomes.contains(biome) || blockPos != null && random.nextInt(count + 1) != 0) continue;
            blockPos = new BlockPos(x0, 0, z0);
            ++count;
        }
        return blockPos;
    }

    public void func_76938_b() {
        this.biomeCache.func_76838_a();
    }
}

