/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.oasis;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenFossils;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.biomes.oasis.BiomeOasisBase;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;

public class BiomeOasisMudSwamp
extends BiomeOasisBase {
    protected static final IBlockState WATER_LILY = Blocks.field_150392_bi.func_176223_P();

    public BiomeOasisMudSwamp(Biome.BiomeProperties props) {
        super("oasis_mudswamp", props);
        props.func_185398_c(1.4f);
        props.func_185400_d(1.5f);
        props.func_185410_a(5.0f);
        this.setTempCategory(Biome.TempCategory.MEDIUM);
        this.setTemp(6.0f);
        this.setBiomeHeight(35);
        this.setBiomeType(EnumBiomeTypeZG.SWAMP);
        this.field_76766_R = false;
        this.biomeDecor.generateTrees = false;
        this.biomeDecor.waterLakesPerChunk = 6;
        this.biomeDecor.field_76833_y = 8;
        grassFoliageColor = 10472587;
        this.field_76759_H = 10204;
        this.field_76752_A = ZGBlocks.mudClayBlock.func_176223_P();
        this.field_76753_B = ZGBlocks.mudClayBlock.func_176223_P();
        this.stoneBlock = ZGBlocks.oasisStone;
    }

    @Override
    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        double d0 = field_180281_af.func_151601_a((double)x * 0.25, (double)z * 0.25);
        if (d0 > 0.0) {
            int i = x & 0xF;
            int j = z & 0xF;
            for (int k = 128; k >= 0; --k) {
                if (chunkPrimerIn.func_177856_a(j, k, i).func_185904_a() == Material.field_151579_a) continue;
                if (k > this.getBiomeHeight() - 3 || chunkPrimerIn.func_177856_a(j, k, i).func_177230_c() == Blocks.field_150355_j) break;
                chunkPrimerIn.func_177855_a(j, k, i, field_185372_h);
                if (!(d0 <= 0.24)) break;
                chunkPrimerIn.func_177855_a(j, k + 1, i, WATER_LILY);
                break;
            }
        }
        this.generateOasisTerrain(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        super.func_180624_a(worldIn, rand, pos);
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (ChunkPos)new ChunkPos(pos), (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FOSSIL) && rand.nextInt(64) == 0) {
            new WorldGenFossils().func_180709_b(worldIn, rand, pos);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float p_76731_1_) {
        return 5009374;
    }
}

