/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.oasis;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.biomes.decorators.BiomeDecoratorOasis;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.celestial.ZGPlanets;
import zollerngalaxy.compat.ThermalFoundationCompat;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.lib.helpers.ModHelperBase;
import zollerngalaxy.mobs.entities.robots.sentinels.EntitySentinelDrone;
import zollerngalaxy.mobs.entities.villagers.EntityOasisVillager;
import zollerngalaxy.util.BiomeUtils;

public abstract class BiomeOasisBase
extends BiomeSpace {
    protected static final IBlockState STONE = ZGBlocks.oasisStone.func_176223_P();
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    protected static final IBlockState GRAVEL = ZGBlocks.oasisGravel.func_176223_P();
    protected static final IBlockState DIRT = ZGBlocks.oasisDirt.func_176223_P();
    protected static final IBlockState ICE = Blocks.field_150432_aD.func_176223_P();
    protected static final IBlockState WATER = Blocks.field_150355_j.func_176223_P();
    protected static final int SEA_LEVEL = 68;
    protected static final int SEA_FLOOR_LEVEL = 47;
    protected boolean shouldUseRedstone = ModHelperBase.useThermalFoundation && ConfigManagerZG.shouldOasisUseLiquidRedstone;
    public BiomeDecoratorOasis biomeDecor = this.getBiomeDecorator();

    public BiomeOasisBase(String singleName, Biome.BiomeProperties props) {
        super(singleName, props);
        this.setTempCategory(Biome.TempCategory.MEDIUM);
        if (ConfigManagerZG.enableSentinels) {
            this.field_76761_J.add(new Biome.SpawnListEntry(EntitySentinelDrone.class, 10, 1, 2));
        }
        if (ConfigManagerZG.enableAlienVillagerSpawn) {
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityOasisVillager.class, this.villagerSpawnRate, this.villagerMinSpawnRate, this.villagerMaxSpawnRate));
        }
        this.setStoneBlock(ZGBlocks.oasisStone);
        this.setPlanetForBiome(ZGPlanets.planetOasis);
    }

    public BiomeDecorator func_76729_a() {
        return new BiomeDecoratorOasis();
    }

    protected BiomeDecoratorOasis getBiomeDecorator() {
        return (BiomeDecoratorOasis)this.field_76760_I;
    }

    public final void generateOasisTerrain(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int i = worldIn.func_181545_F();
        float biomeHeight = this.getBiomeHeight();
        IBlockState topState = this.field_76752_A;
        IBlockState fillState = this.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 2.5 + 3.0 + rand.nextDouble() * 0.25);
        int l = x & 0xF;
        int i1 = z & 0xF;
        int seaLevelMod = 0;
        for (int j1 = 255; j1 >= 0; --j1) {
            if (j1 == 0) {
                chunkPrimerIn.func_177855_a(i1, j1, l, BEDROCK);
                continue;
            }
            if (j1 >= 128) {
                chunkPrimerIn.func_177855_a(i1, j1, l, AIR);
                continue;
            }
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
            IBlockState blockToUse = ThermalFoundationCompat.getOasisWaterState();
            if (BiomeUtils.isOceanBiome((Biome)this)) {
                if (j1 < 68 && j1 > 47) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, blockToUse);
                } else if (j1 >= 68 + seaLevelMod) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, AIR);
                }
            }
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
            } else if (iblockstate2.func_177230_c() == STONE.func_177230_c()) {
                if (j == -1) {
                    if (k <= 0) {
                        topState = AIR;
                        fillState = STONE;
                    } else if (j1 >= i - 4 && j1 <= i + 1) {
                        topState = this.field_76752_A;
                        fillState = this.field_76753_B;
                    }
                    if (j1 < i && (topState == null || topState.func_185904_a() == Material.field_151579_a)) {
                        topState = this.getIsColdBiome() ? ICE : WATER;
                    }
                    j = k;
                    if (j1 >= i - 1) {
                        chunkPrimerIn.func_177855_a(i1, j1, l, topState);
                    } else if (j1 < i - 7 - k) {
                        topState = AIR;
                        fillState = STONE;
                        chunkPrimerIn.func_177855_a(i1, j1, l, GRAVEL);
                    } else {
                        chunkPrimerIn.func_177855_a(i1, j1, l, fillState);
                    }
                } else if (j > 0) {
                    --j;
                    chunkPrimerIn.func_177855_a(i1, j1, l, fillState);
                }
            }
            if (!BiomeUtils.isOceanBiome((Biome)this) || j1 < 68 + seaLevelMod || chunkPrimerIn.func_177856_a(i1, j1, l).func_177230_c() == WATER) continue;
            chunkPrimerIn.func_177855_a(i1, j1, l, AIR);
            if (j1 < 68 - rand.nextInt(21) && j1 > 47) {
                chunkPrimerIn.func_177855_a(i1, j1, l, blockToUse);
            } else if (j1 > 68) {
                chunkPrimerIn.func_177855_a(i1, j1, l, AIR);
            }
            if (j1 != 68) continue;
            chunkPrimerIn.func_177855_a(i1, j1, l, blockToUse);
        }
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        this.generateOasisTerrain(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public int getModdedBiomeFoliageColor(int original) {
        return grassFoliageColor;
    }

    public int getModdedBiomeGrassColor(int original) {
        return grassFoliageColor;
    }
}

