/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.metztli;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedWitch;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenFossils;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import zollerngalaxy.biomes.metztli.BiomeHarranBase;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;

public class BiomeHarranSwamp
extends BiomeHarranBase {
    protected static final IBlockState WATER_LILY = Blocks.field_150392_bi.func_176223_P();

    public BiomeHarranSwamp(Biome.BiomeProperties props) {
        super("harran_swamp", props);
        props.func_185398_c(0.5f);
        props.func_185400_d(0.2f);
        props.func_185410_a(6.5f);
        this.setTemp(46.0f);
        this.setBiomeHeight(45);
        this.setBiomeType(EnumBiomeTypeZG.SWAMP);
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityWitch.class, 25, 1, 1));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedWitch.class, 25, 1, 1));
        this.biomeDecor.field_76808_K = true;
        this.biomeDecor.generateLakes = true;
        this.biomeDecor.generateVines = true;
        this.biomeDecor.generateMushroomTrees = true;
        this.biomeDecor.field_76832_z = 4;
        this.biomeDecor.waterLakesPerChunk = 24;
        this.biomeDecor.field_76833_y = 16;
        this.biomeDecor.field_76804_C = 4;
        this.biomeDecor.tallGrassPerChunk = 4;
        this.biomeDecor.field_76798_D = 15;
        this.field_76766_R = false;
        grassFoliageColor = 43520;
        this.field_76759_H = 17442;
        this.field_76752_A = Blocks.field_150349_c.func_176223_P();
        this.field_76753_B = Blocks.field_150346_d.func_176223_P();
        this.stoneBlock = Blocks.field_150348_b;
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        return field_76763_Q;
    }

    @Override
    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        double d0 = field_180281_af.func_151601_a((double)x * 0.25, (double)z * 0.25);
        if (d0 > 0.0) {
            int i = x & 0xF;
            int j = z & 0xF;
            for (int k = 255; k >= 0; --k) {
                if (chunkPrimerIn.func_177856_a(j, k, i).func_185904_a() == Material.field_151579_a) continue;
                if (k > this.getBiomeHeight() - 3 || chunkPrimerIn.func_177856_a(j, k, i).func_177230_c() == Blocks.field_150355_j) break;
                chunkPrimerIn.func_177855_a(j, k, i, field_185372_h);
                if (!(d0 <= 0.24)) break;
                chunkPrimerIn.func_177855_a(j, k + 1, i, Blocks.field_150392_bi.func_176223_P());
                break;
            }
        }
        this.generateMetztliTerrain(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        super.func_180624_a(worldIn, rand, pos);
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (ChunkPos)new ChunkPos(pos), (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FOSSIL) && rand.nextInt(64) == 0) {
            new WorldGenFossils().func_180709_b(worldIn, rand, pos);
        }
    }
}

