/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.metztli;

import java.util.Random;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenMelon;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenVines;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.biomes.metztli.BiomeHarranBase;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;

public class BiomeHarranMarsh
extends BiomeHarranBase {
    private static final IBlockState JUNGLE_LOG = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
    private static final IBlockState JUNGLE_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    private static final IBlockState OAK_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));

    public BiomeHarranMarsh(Biome.BiomeProperties props) {
        super("harran_marsh", props);
        this.setupBiome(props);
    }

    public BiomeHarranMarsh(String singleName, Biome.BiomeProperties props) {
        super(singleName, props);
        this.setupBiome(props);
    }

    private void setupBiome(Biome.BiomeProperties props) {
        this.setTempCategory(Biome.TempCategory.WARM);
        props.func_185398_c(0.5f);
        props.func_185400_d(0.2f);
        props.func_185410_a(8.0f);
        props.func_185395_b(0.9f);
        this.setTemp(65.0f);
        this.setBiomeHeight(65);
        this.setBiomeType(EnumBiomeTypeZG.MARSH);
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityStray.class, 80, 4, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityParrot.class, 40, 1, 2));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityOcelot.class, 40, 1, 2));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityChicken.class, 10, 4, 4));
        this.field_76766_R = false;
        this.biomeDecor.field_76808_K = true;
        this.biomeDecor.generateCacti = false;
        this.biomeDecor.generateDeadBushes = true;
        this.biomeDecor.generateTrees = false;
        this.biomeDecor.generateJungleTrees = true;
        this.biomeDecor.generateMushroomTrees = false;
        this.biomeDecor.generateTallGrass = true;
        this.biomeDecor.generateWaterLilies = true;
        this.biomeDecor.generateLakes = true;
        this.biomeDecor.waterLakesPerChunk = 24;
        this.biomeDecor.lavaLakesPerChunk = 0;
        this.biomeDecor.jungleTreesPerChunk = 55;
        this.biomeDecor.tallGrassPerChunk = 15;
        this.biomeDecor.fernsPerChunk = 15;
        grassFoliageColor = 65280;
        this.field_76759_H = 35676;
        this.field_76752_A = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL);
        this.field_76753_B = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT);
        this.stoneBlock = Blocks.field_150348_b;
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        return rand.nextInt(2) == 0 ? new WorldGenMegaJungle(false, 10, 20, JUNGLE_LOG, JUNGLE_LEAF) : new WorldGenTrees(false, 4 + rand.nextInt(7), JUNGLE_LOG, JUNGLE_LEAF, true);
    }

    public WorldGenerator func_76730_b(Random rand) {
        return rand.nextInt(2) == 0 ? new WorldGenTallGrass(BlockTallGrass.EnumType.FERN) : new WorldGenTallGrass(BlockTallGrass.EnumType.GRASS);
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        int k;
        super.func_180624_a(worldIn, rand, pos);
        int i = rand.nextInt(16) + 8;
        int j = rand.nextInt(16) + 8;
        int height = worldIn.func_175645_m(pos.func_177982_a(i, 0, j)).func_177956_o() * 2;
        if (height < 1) {
            height = 1;
        }
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (ChunkPos)new ChunkPos(pos), (BlockPos)pos.func_177982_a(i, k = rand.nextInt(height), j), (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.PUMPKIN)) {
            new WorldGenMelon().func_180709_b(worldIn, rand, pos.func_177982_a(i, k, j));
        }
        WorldGenVines worldgenvines = new WorldGenVines();
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (ChunkPos)new ChunkPos(pos), (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.GRASS)) {
            for (int j1 = 0; j1 < 50; ++j1) {
                k = rand.nextInt(16) + 8;
                int l = 128;
                int i1 = rand.nextInt(16) + 8;
                worldgenvines.func_180709_b(worldIn, rand, pos.func_177982_a(k, 128, i1));
            }
        }
    }

    @Override
    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        double d0 = field_180281_af.func_151601_a((double)x * 0.25, (double)z * 0.25);
        if (d0 > 0.0) {
            int i = x & 0xF;
            int j = z & 0xF;
            for (int k = 128; k >= 0; --k) {
                if (chunkPrimerIn.func_177856_a(j, k, i).func_185904_a() == Material.field_151579_a) continue;
                if (k > this.getBiomeHeight() - 3 || chunkPrimerIn.func_177856_a(j, k, i).func_177230_c() == Blocks.field_150355_j) break;
                chunkPrimerIn.func_177855_a(j, k, i, Blocks.field_150355_j.func_176223_P());
                if (!(d0 <= 0.24)) break;
                chunkPrimerIn.func_177855_a(j, k + 1, i, Blocks.field_150392_bi.func_176223_P());
                break;
            }
        }
        this.generateMetztliTerrain(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float p_76731_1_) {
        return 13384267;
    }
}

