/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.metztli;

import java.util.Random;
import net.minecraft.block.BlockSand;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenDesertWells;
import net.minecraft.world.gen.feature.WorldGenFossils;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zollerngalaxy.biomes.metztli.BiomeHarranBase;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;
import zollerngalaxy.mobs.entities.EntityMummy;
import zollerngalaxy.mobs.entities.EntityScorpion;

public class BiomeHarranDunes
extends BiomeHarranBase {
    private final Type type;
    private final IBlockState SAND_NORMAL = Blocks.field_150354_m.func_176223_P();
    private final IBlockState SAND_RED = Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND);
    private final IBlockState SANDSTONE = Blocks.field_150322_A.func_176223_P();
    private final IBlockState HARDENED_CLAY = Blocks.field_150405_ch.func_176223_P();

    public BiomeHarranDunes(Type typeIn, Biome.BiomeProperties props) {
        super(typeIn == Type.NORMAL ? "harran_dunes" : "harran_red_desert", props);
        this.setupBiome(props);
        this.type = typeIn;
    }

    public BiomeHarranDunes(Type typeIn, String singleName, Biome.BiomeProperties props) {
        super(singleName, props);
        this.setupBiome(props);
        this.type = typeIn;
    }

    private void setupBiome(Biome.BiomeProperties props) {
        this.setTempCategory(Biome.TempCategory.WARM);
        props.func_185398_c(1.4f);
        props.func_185400_d(1.5f);
        props.func_185410_a(9.0f);
        this.setTemp(this.type == Type.NORMAL ? 80.0f : 95.0f);
        this.setBiomeHeight(this.type == Type.NORMAL ? 82 : 96);
        this.setBiomeType(EnumBiomeTypeZG.DESERT);
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityRabbit.class, 4, 2, 3));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityStray.class, 80, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityMummy.class, 100, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityScorpion.class, 100, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityZombieVillager.class, 1, 1, 1));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityHusk.class, 80, 4, 4));
        this.field_76766_R = false;
        this.biomeDecor.field_76808_K = true;
        this.biomeDecor.generateCacti = true;
        this.biomeDecor.generateDeadBushes = true;
        this.biomeDecor.generateTrees = false;
        this.biomeDecor.generateMushroomTrees = false;
        this.biomeDecor.generateTallGrass = false;
        this.biomeDecor.generateFerns = false;
        this.biomeDecor.generateWaterLilies = false;
        this.biomeDecor.waterLakesPerChunk = 1;
        this.biomeDecor.lavaLakesPerChunk = this.type == Type.NORMAL ? 6 : 14;
        this.biomeDecor.deadBushesPerChunk = this.type == Type.NORMAL ? 8 : 16;
        this.biomeDecor.field_76799_E = 50;
        this.biomeDecor.field_76800_F = 10;
        grassFoliageColor = 3431043;
        this.field_76759_H = 139;
        this.field_76752_A = this.type == Type.NORMAL ? this.SAND_NORMAL : this.SAND_RED;
        this.field_76753_B = this.type == Type.NORMAL ? this.SANDSTONE : this.HARDENED_CLAY;
        this.stoneBlock = Blocks.field_150348_b;
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        super.func_180624_a(worldIn, rand, pos);
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (ChunkPos)new ChunkPos(pos), (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.DESERT_WELL) && rand.nextInt(1000) == 0) {
            int i = rand.nextInt(16) + 8;
            int j = rand.nextInt(16) + 8;
            BlockPos blockpos = worldIn.func_175645_m(pos.func_177982_a(i, 0, j)).func_177984_a();
            new WorldGenDesertWells().func_180709_b(worldIn, rand, blockpos);
        }
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (ChunkPos)new ChunkPos(pos), (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FOSSIL) && rand.nextInt(64) == 0) {
            new WorldGenFossils().func_180709_b(worldIn, rand, pos);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float p_76731_1_) {
        return 13384267;
    }

    public static enum Type {
        NORMAL,
        RED;

    }
}

