/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.metztli;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedEnderman;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedWitch;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.biomes.decorators.BiomeDecoratorMetztli;
import zollerngalaxy.celestial.ZGPlanets;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;
import zollerngalaxy.mobs.entities.EntityMegaCreeper;
import zollerngalaxy.mobs.entities.EntityShadowSkeleton;
import zollerngalaxy.mobs.entities.robots.sentinels.EntitySentinelDrone;
import zollerngalaxy.mobs.entities.villagers.EntityHarranVillager;
import zollerngalaxy.mobs.entities.zombiemutations.EntityGhoul;
import zollerngalaxy.mobs.entities.zombiemutations.EntityOverlord;
import zollerngalaxy.mobs.entities.zombiemutations.EntitySeeker;
import zollerngalaxy.mobs.entities.zombiemutations.EntityVolatile;

public abstract class BiomeHarranBase
extends BiomeSpace {
    protected static final IBlockState STONE = Blocks.field_150348_b.func_176223_P();
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    protected static final IBlockState GRAVEL = Blocks.field_150351_n.func_176223_P();
    protected static final IBlockState GRASS = Blocks.field_150349_c.func_176223_P();
    protected static final IBlockState DIRT = Blocks.field_150346_d.func_176223_P();
    protected static final IBlockState ICE = Blocks.field_150432_aD.func_176223_P();
    protected static final IBlockState WATER = Blocks.field_150355_j.func_176223_P();
    protected static final PropertyBool SNOWY = PropertyBool.func_177716_a((String)"snowy");
    protected static final IBlockState SNOWY_GRASS = GRASS.func_177226_a((IProperty)SNOWY, (Comparable)Boolean.valueOf(true));
    protected static final int SEA_LEVEL = 63;
    protected static final int SEA_FLOOR_LEVEL = 42;
    public BiomeDecoratorMetztli biomeDecor = this.getBiomeDecorator();

    public BiomeHarranBase(String singleName, Biome.BiomeProperties props) {
        super(singleName, props);
        this.setTempCategory(Biome.TempCategory.OCEAN);
        this.setTemp(62.45f);
        this.biomeDecor.field_76802_A = 4;
        this.biomeDecor.field_76803_B = 2;
        this.biomeDecor.field_76832_z = 1;
        this.clearAllSpawning();
        if (ConfigManagerZG.enableSentinels) {
            this.field_76761_J.add(new Biome.SpawnListEntry(EntitySentinelDrone.class, 10, 1, 2));
        }
        if (ConfigManagerZG.enableAlienVillagerSpawn) {
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityHarranVillager.class, this.villagerSpawnRate, this.villagerMinSpawnRate, this.villagerMaxSpawnRate));
        }
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 100, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 100, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 5, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 5, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 5, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEvolvedWitch.class, 5, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityZombie.class, 100, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityGhoul.class, 100, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityOverlord.class, 100, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntitySeeker.class, 100, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityVolatile.class, 100, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntitySpider.class, 100, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntitySkeleton.class, 5, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityShadowSkeleton.class, 5, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityCreeper.class, 5, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityMegaCreeper.class, 5, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEnderman.class, 5, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityWitch.class, 5, 1, 1));
        this.setStoneBlock(Blocks.field_150348_b);
        this.setPlanetForBiome(ZGPlanets.planetMetztli);
    }

    public BiomeDecorator func_76729_a() {
        return new BiomeDecoratorMetztli();
    }

    protected BiomeDecoratorMetztli getBiomeDecorator() {
        return (BiomeDecoratorMetztli)this.field_76760_I;
    }

    public final void generateMetztliTerrain(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int i = worldIn.func_181545_F();
        float biomeHeight = this.getBiomeHeight();
        IBlockState topState = this.field_76752_A;
        IBlockState fillState = this.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int l = x & 0xF;
        int i1 = z & 0xF;
        for (int j1 = 255; j1 >= 0; --j1) {
            if (j1 == 0) {
                chunkPrimerIn.func_177855_a(i1, j1, l, BEDROCK);
                continue;
            }
            if (j1 >= 128) {
                chunkPrimerIn.func_177855_a(i1, j1, l, AIR);
                continue;
            }
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
            if (this.getBiomeType() == EnumBiomeTypeZG.OCEAN) {
                if (j1 < 63 && j1 > 42) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, WATER);
                    continue;
                }
                if (j1 < 42) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, STONE);
                    continue;
                }
                if (j1 == 42) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, DIRT);
                    continue;
                }
                if (j1 < 63) continue;
                chunkPrimerIn.func_177855_a(i1, j1, l, AIR);
                continue;
            }
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2.func_177230_c() != Blocks.field_150348_b) continue;
            if (j == -1) {
                if (k <= 0) {
                    topState = AIR;
                    fillState = STONE;
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    topState = this.field_76752_A;
                    fillState = this.field_76753_B;
                }
                if (j1 < i && (topState == null || topState.func_185904_a() == Material.field_151579_a)) {
                    topState = this.getIsColdBiome() ? ICE : WATER;
                }
                j = k;
                if (j1 >= i - 1) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, topState);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    topState = AIR;
                    fillState = STONE;
                    chunkPrimerIn.func_177855_a(i1, j1, l, GRAVEL);
                    continue;
                }
                chunkPrimerIn.func_177855_a(i1, j1, l, fillState);
                continue;
            }
            if (j <= 0) continue;
            --j;
            chunkPrimerIn.func_177855_a(i1, j1, l, fillState);
        }
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        this.generateMetztliTerrain(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public int getModdedBiomeFoliageColor(int original) {
        return grassFoliageColor;
    }

    public int getModdedBiomeGrassColor(int original) {
        return grassFoliageColor;
    }
}

