/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.kronos;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;
import zollerngalaxy.biomes.kronos.BiomeKronosBase;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;

public class BiomeKronosBlackMountain
extends BiomeKronosBase {
    public BiomeKronosBlackMountain(Biome.BiomeProperties props) {
        super("kronos_black_mountain", props);
        props.func_185396_a();
        this.setBiomeHeight(124);
        this.setTempCategory(Biome.TempCategory.WARM);
        this.setTemp(89.0f);
        this.setBiomeType(EnumBiomeTypeZG.NETHER);
        this.setBlocks(Blocks.field_150343_Z);
        this.field_76766_R = false;
        this.stoneBlock = field_185365_a.func_177230_c();
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        super.func_180624_a(worldIn, rand, pos);
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Pre(worldIn, rand, pos));
        AzuriteGenerator azurites = new AzuriteGenerator();
        if (TerrainGen.generateOre((World)worldIn, (Random)rand, (WorldGenerator)azurites, (BlockPos)pos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
            azurites.func_180709_b(worldIn, rand, pos);
        }
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Post(worldIn, rand, pos));
    }

    private static class AzuriteGenerator
    extends WorldGenerator {
        private AzuriteGenerator() {
        }

        public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
            int count = 4 + rand.nextInt(6);
            for (int i = 0; i < count; ++i) {
                int offset = ForgeModContainer.fixVanillaCascading ? 8 : 0;
                BlockPos blockpos = pos.func_177982_a(rand.nextInt(16) + offset, rand.nextInt(28) + 4, rand.nextInt(16) + offset);
                IBlockState state = worldIn.func_180495_p(blockpos);
                if (!state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)worldIn, blockpos, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150343_Z))) continue;
                worldIn.func_180501_a(blockpos, ZGBlocks.azuriteOre.func_176223_P(), 18);
            }
            return true;
        }
    }
}

