/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.genlayers.toci;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.BiomeManager;
import zollerngalaxy.biomes.ZGBiomes;
import zollerngalaxy.biomes.genlayers.toci.GenLayerToci;
import zollerngalaxy.util.CachedEnumZG;

public class GenLayerTociBiomes
extends GenLayerToci {
    private List<BiomeManager.BiomeEntry>[] biomes = new ArrayList[CachedEnumZG.valuesBiomeCached().length];
    private ArrayList<BiomeManager.BiomeEntry>[] biomesList = this.setupBiomes();

    public GenLayerTociBiomes(long seed) {
        super(seed);
        for (BiomeManager.BiomeType type : CachedEnumZG.valuesBiomeCached()) {
            ImmutableList<BiomeManager.BiomeEntry> biomesToAdd = this.getBiomes(type);
            int idx = type.ordinal();
            if (this.biomes[idx] == null) {
                this.biomes[idx] = new ArrayList<BiomeManager.BiomeEntry>();
            }
            if (biomesToAdd == null) continue;
            this.biomes[idx].addAll((Collection<BiomeManager.BiomeEntry>)biomesToAdd);
        }
    }

    private ArrayList<BiomeManager.BiomeEntry>[] setupBiomes() {
        ArrayList[] currentBiomes = new ArrayList[CachedEnumZG.valuesBiomeCached().length];
        ArrayList<BiomeManager.BiomeEntry> list = new ArrayList<BiomeManager.BiomeEntry>();
        list.add(new BiomeManager.BiomeEntry(ZGBiomes.TOCI_BASE, 100));
        list.add(new BiomeManager.BiomeEntry(ZGBiomes.TOCI_DESERT, 90));
        list.add(new BiomeManager.BiomeEntry(ZGBiomes.TOCI_STAR_DESERT, 80));
        list.add(new BiomeManager.BiomeEntry(ZGBiomes.TOCI_VALLEY, 70));
        list.add(new BiomeManager.BiomeEntry(ZGBiomes.TOCI_MOUNTAINS, 60));
        currentBiomes[BiomeManager.BiomeType.WARM.ordinal()] = new ArrayList(list);
        return currentBiomes;
    }

    private ImmutableList<BiomeManager.BiomeEntry> getBiomes(BiomeManager.BiomeType type) {
        int idx = type.ordinal();
        ArrayList<BiomeManager.BiomeEntry> list = idx >= this.biomesList.length ? null : this.biomesList[idx];
        return list != null ? ImmutableList.copyOf(list) : null;
    }

    public int[] func_75904_a(int areaX, int areaY, int areaWidth, int areaHeight) {
        int[] dest = IntCache.func_76445_a((int)(areaWidth * areaHeight));
        for (int dz = 0; dz < areaHeight; ++dz) {
            for (int dx = 0; dx < areaWidth; ++dx) {
                this.func_75903_a(dx + areaX, dz + areaY);
                dest[dx + dz * areaWidth] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM).biome);
            }
        }
        return dest;
    }

    protected BiomeManager.BiomeEntry getWeightedBiomeEntry(BiomeManager.BiomeType type) {
        List<BiomeManager.BiomeEntry> biomeList = this.biomes[type.ordinal()];
        int totalWeight = WeightedRandom.func_76272_a(biomeList);
        int weight = BiomeManager.isTypeListModded((BiomeManager.BiomeType)type) ? this.func_75902_a(totalWeight) : this.func_75902_a(totalWeight / 10) * 10;
        return (BiomeManager.BiomeEntry)WeightedRandom.func_180166_a(biomeList, (int)weight);
    }
}

