/*
 * Decompiled with CFR 0.152.
 */
package zollerngalaxy.biomes.decorators;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenWaterlily;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import zollerngalaxy.biomes.BiomeSpace;
import zollerngalaxy.biomes.ZGBiomes;
import zollerngalaxy.biomes.decorators.BiomeDecoratorZG;
import zollerngalaxy.blocks.ZGBlockTallGrass;
import zollerngalaxy.blocks.ZGBlocks;
import zollerngalaxy.config.ConfigManagerZG;
import zollerngalaxy.core.enums.EnumBiomeTypeZG;
import zollerngalaxy.core.enums.EnumOreGenZG;
import zollerngalaxy.lib.helpers.ZGDecorateHelper;
import zollerngalaxy.worldgen.WorldGenLakesZG;
import zollerngalaxy.worldgen.WorldGenMinableZG;
import zollerngalaxy.worldgen.WorldGenOutpost;
import zollerngalaxy.worldgen.WorldGenTallGrassZG;

public class BiomeDecoratorXathius
extends BiomeDecoratorZG {
    public static final Block SURFACE_ROCK = ZGBlocks.xathRock;
    public static final Block STONE = ZGBlocks.xathStone;
    private WorldGenerator dirtGen = new WorldGenMinableZG(ZGBlocks.xathDirt, STONE, EnumOreGenZG.DIRT);
    private WorldGenerator gravelGen = new WorldGenMinableZG(ZGBlocks.xathGravel, STONE, EnumOreGenZG.GRAVEL);
    private WorldGenerator prometheanGen = new WorldGenMinableZG(ZGBlocks.xathPrometheanOre, STONE, EnumOreGenZG.PROMETHEAN);
    private WorldGenerator emeraldGen = new WorldGenMinableZG(ZGBlocks.xathEmeraldOre, STONE, EnumOreGenZG.EMERALD);
    private WorldGenerator diamondGen = new WorldGenMinableZG(ZGBlocks.xathDiamondOre, STONE, EnumOreGenZG.DIAMOND);
    private WorldGenerator redstoneGen = new WorldGenMinableZG(ZGBlocks.xathRedstoneOre, STONE, EnumOreGenZG.REDSTONE);
    private WorldGenerator ironGen = new WorldGenMinableZG(ZGBlocks.xathIronOre, STONE, EnumOreGenZG.IRON);
    private WorldGenerator goldGen = new WorldGenMinableZG(ZGBlocks.xathGoldOre, STONE, EnumOreGenZG.GOLD);
    private WorldGenerator tinGen = new WorldGenMinableZG(ZGBlocks.xathTinOre, STONE, EnumOreGenZG.TIN);
    private WorldGenerator azuriteGen = new WorldGenMinableZG(ZGBlocks.xathAzuriteOre, Blocks.field_150343_Z, EnumOreGenZG.AZURITE);
    public int waterLakesPerChunk = 2;
    public int lavaLakesPerChunk = 1;
    public int oilLakesPerChunk = 2;
    public int obsidianLakesPerChunk = 1;
    public int xathTallGrassPerChunk = 8;
    public boolean generateLakes = true;
    public boolean generateVines = false;
    public boolean generateCraters = false;

    @Override
    protected void generate(Biome biome, World world, Random rand) {
        int i;
        int genY;
        int x = rand.nextInt(16) + 8;
        int z = rand.nextInt(16) + 8;
        int y = genY = 248;
        Block BLOCK_TOP = biome.field_76752_A.func_177230_c();
        Block BLOCK_FILL = biome.field_76753_B.func_177230_c();
        if (biome.equals(ZGBiomes.XATHIUS_MOUNTAINS)) {
            EnumOreGenZG.GRAVEL.setMaxHeight(128);
            EnumOreGenZG.EMERALD.setMaxHeight(128);
            EnumOreGenZG.DIAMOND.setMaxHeight(128);
            EnumOreGenZG.REDSTONE.setMaxHeight(128);
            EnumOreGenZG.IRON.setMaxHeight(128);
            EnumOreGenZG.GOLD.setMaxHeight(128);
            EnumOreGenZG.TIN.setMaxHeight(128);
        }
        this.generateOre(this.dirtGen, EnumOreGenZG.DIRT, world, rand);
        this.generateOre(this.gravelGen, EnumOreGenZG.GRAVEL, world, rand);
        this.generateOre(this.prometheanGen, EnumOreGenZG.PROMETHEAN, world, rand);
        this.generateOre(this.emeraldGen, EnumOreGenZG.EMERALD, world, rand);
        this.generateOre(this.diamondGen, EnumOreGenZG.DIAMOND, world, rand);
        this.generateOre(this.redstoneGen, EnumOreGenZG.REDSTONE, world, rand);
        this.generateOre(this.ironGen, EnumOreGenZG.IRON, world, rand);
        this.generateOre(this.goldGen, EnumOreGenZG.GOLD, world, rand);
        this.generateOre(this.tinGen, EnumOreGenZG.TIN, world, rand);
        this.generateOre(this.azuriteGen, EnumOreGenZG.AZURITE, world, rand);
        ChunkPrimer chunkPrimer = new ChunkPrimer();
        ChunkPos forgeChunkPos = new ChunkPos(this.field_180294_c);
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_WATER) && this.generateLakes && this.waterLakesPerChunk > 0) {
            for (i = 0; i < this.waterLakesPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                Block blockToUse = biome.func_150561_m() == Biome.TempCategory.COLD ? Blocks.field_150432_aD : Blocks.field_150355_j;
                new WorldGenLakesZG(blockToUse, BLOCK_TOP).func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
            if (this.field_76833_y > 0) {
                for (i = 0; i < this.field_76833_y; ++i) {
                    new WorldGenWaterlily().func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
                }
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_LAVA) && this.generateLakes && this.lavaLakesPerChunk > 0) {
            for (i = 0; i < this.lavaLakesPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (rand.nextInt(100) > 5) continue;
                new WorldGenLakesZG((Block)Blocks.field_150353_l, STONE).func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)forgeChunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CUSTOM) && this.generateLakes && this.obsidianLakesPerChunk > 0) {
            for (i = 0; i < this.obsidianLakesPerChunk; ++i) {
                y = rand.nextInt(rand.nextInt(genY) + 8);
                if (rand.nextInt(100) > 10) continue;
                new WorldGenLakesZG(Blocks.field_150343_Z, STONE).func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
            }
        }
        if (this.xathTallGrassPerChunk > 0) {
            for (i = 0; i < this.xathTallGrassPerChunk + 4; ++i) {
                ZGDecorateHelper.generatePlants(new WorldGenTallGrassZG((ZGBlockTallGrass)ZGBlocks.xathTallGrass), world, rand, this.field_180294_c);
            }
        }
        if (this.generateOutposts && this.outpostsPerChunk > 0) {
            BiomeSpace spaceBiome;
            if (biome instanceof BiomeSpace && (spaceBiome = (BiomeSpace)biome).getBiomeType() == EnumBiomeTypeZG.OCEAN) {
                return;
            }
            y = rand.nextInt(rand.nextInt(genY) + 8);
            if (y >= 62) {
                IBlockState OUTPOST_STATE = ZGBlocks.blockOutpost.func_176223_P();
                WorldGenOutpost outpostGen = new WorldGenOutpost(OUTPOST_STATE, OUTPOST_STATE);
                for (int i2 = 0; i2 < this.outpostsPerChunk; ++i2) {
                    if (rand.nextInt(this.enableExtremeMode ? 200 : 100) > ConfigManagerZG.outpostGenChance) continue;
                    outpostGen.func_180709_b(world, rand, this.field_180294_c.func_177982_a(x, y, z));
                }
            }
        }
    }
}

